/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.log;

import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerWriter;
import com.kingdee.bos.search.msic.SerializationUtil;
import java.sql.Timestamp;
import java.util.LinkedList;

public class DefaultLogger
implements Logger {
    private boolean doWrite = true;
    private LinkedList<String> messages = new LinkedList();

    @Override
    public void debug(String message) {
        this.log(Logger.Type.Debug, message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log(Logger.Type.Debug, message, t);
    }

    @Override
    public void error(String message) {
        this.log(Logger.Type.Error, message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log(Logger.Type.Error, message, t);
    }

    @Override
    public void info(String message) {
        this.log(Logger.Type.Info, message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log(Logger.Type.Info, message, t);
    }

    @Override
    public void warn(String message) {
        this.log(Logger.Type.Warn, message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log(Logger.Type.Warn, message, t);
    }

    @Override
    public void log(Logger.Type type, String message) {
        this.log(type, message, null);
    }

    @Override
    public void echo(String message) {
        this.log(Logger.Type.Echo, message, null);
    }

    @Override
    public void log(Logger.Type type, String message, Throwable error) {
        StringBuilder s = new StringBuilder();
        s.append(Thread.currentThread().getName()).append(":").append((Object)type).append(", ");
        s.append(new Timestamp(System.currentTimeMillis()));
        s.append("\r\n\t").append(message);
        if (error != null) {
            s.append("\r\n").append(SerializationUtil.dump(error));
        }
        this.enqueue(s.toString());
    }

    private synchronized void enqueue(String message) {
        if (!this.doWrite) {
            return;
        }
        this.messages.addLast(message);
        this.notify();
    }

    private synchronized String dequeue() {
        while (this.messages.size() == 0) {
            try {
                this.wait();
            }
            catch (Throwable e) {
                if (Thread.interrupted()) {
                    return null;
                }
                System.out.println(SerializationUtil.dump(e));
            }
        }
        return this.messages.removeFirst();
    }

    DefaultLogger() {
        Thread t = new Thread(){

            @Override
            public void run() {
                String message;
                LoggerWriter.init();
                while ((message = DefaultLogger.this.dequeue()) != null) {
                    LoggerWriter.output(message);
                }
                DefaultLogger.this.doWrite = false;
            }
        };
        t.setName("KSEARCH_LOG_OUTPUT");
        t.start();
    }
}

