/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.IndexSearchProvider;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;

public class DefaultIndexSearcher
implements IndexSearchProvider {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(DefaultIndexSearcher.class);
    private SearcherManager manager;
    private String dirName;

    public DefaultIndexSearcher(SearcherManager manager, String dirName) {
        this.manager = manager;
        this.dirName = dirName;
    }

    @Override
    public String getDirName() {
        return this.dirName;
    }

    @Override
    public IndexSearcher acquire() throws IOException {
        return (IndexSearcher)this.manager.acquire();
    }

    @Override
    public void release(IndexSearcher searcher) throws IOException {
        this.manager.release((Object)searcher);
    }

    @Override
    public boolean refreshIfNeed() throws IOException {
        return this.manager.maybeRefresh();
    }

    @Override
    public boolean isBizFinished() {
        return false;
    }

    @Override
    public void close() {
        try {
            this.manager.close();
        }
        catch (IOException e) {
            logger.error("close " + this.dirName, e);
        }
    }
}

