/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.IndexService;
import com.kingdee.bos.search.lucene.IndexUtil;
import com.kingdee.bos.search.lucene.IndexWorker;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.TimeCaliper;
import com.kingdee.bos.search.lucene.bean.IndexBizState;
import com.kingdee.bos.search.lucene.bean.LuceneBizId;
import com.kingdee.bos.search.lucene.bean.WorkMode;
import com.kingdee.bos.search.lucene.cluster.SyncWorkModeCmd;
import com.kingdee.bos.search.msic.Tool;
import com.kingdee.bos.service.job.util.SQL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class IndexDispatcher
implements Runnable {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(IndexService.class);
    private String dc;
    private String bizUnit;
    private int SLEEP_TIME = 50;
    private Map<String, LinkedList<LuceneBizId>> dirIdMap = new HashMap<String, LinkedList<LuceneBizId>>();
    private static ExecutorService executorService = Executors.newFixedThreadPool(1);
    private CountDownLatch latch;
    private TimeCaliper caliper;

    public IndexDispatcher(String dc, String bizUnit) {
        this.dc = dc;
        this.bizUnit = bizUnit;
    }

    public void work() {
        int i = this.load(this.dc);
        Set<String> dirs = this.dirIdMap.keySet();
        if (i > 0 && dirs.size() > 0) {
            this.dispatch(dirs, this.dc);
        }
        this.dirIdMap.clear();
    }

    public void dispatch(Set<String> dirs, String dc) {
        this.latch = new CountDownLatch(dirs.size());
        for (String dir : dirs) {
            LinkedList<LuceneBizId> list = this.dirIdMap.get(dir);
            if (list.size() == 0) continue;
            IndexWorker task = new IndexWorker(this.latch, dc, dir, list, this.bizUnit);
            executorService.submit(task);
        }
        try {
            this.latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), e);
        }
    }

    public int load(String dc) {
        try {
            ArrayList<?> list = this.getBizList(dc);
            for (Object obj : list) {
                this.transformTodcMap(obj, dc);
            }
            return list.size();
        }
        catch (BOSException e) {
            logger.error("IndexDispatcher load from {" + dc + "} error:", e);
            return 0;
        }
    }

    private ArrayList<?> getBizList(String dc) throws BOSException {
        ArrayList list = null;
        LuceneEngine engine = LuceneEngine.getEngine(dc);
        WorkMode mode = engine.getWorkMode();
        if (mode == WorkMode.NORMAL) {
            String sql = "select * from " + Tool.getBizLuceneTable(this.bizUnit) + " where fdc = ? and fnode=? and fop is not null  and fop <> '" + (Object)((Object)IndexBizState.OP_DO_NOTHING) + "' and fop <> '" + (Object)((Object)IndexBizState.OP_DOING_INDEX) + "' and fdirName like '" + LuceneEngine.getServerName() + "%' and foptime <{ts '" + this.secondBefore() + "'} order by foptime";
            list = SQL.executeQuery((String)dc, (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{dc, LuceneEngine.getNode().getID()});
        } else if (mode == WorkMode.CLEAN_DATA) {
            String sql = "select top 500 * from " + Tool.getBizDelLuceneTable(this.bizUnit) + " where fdc =? and fnode=? and fop ='" + (Object)((Object)IndexBizState.OP_TO_DELETE_LATER) + "' and fdirName like '" + LuceneEngine.getServerName() + "%'";
            list = SQL.executeQuery((String)dc, (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{dc, LuceneEngine.getNode().getID()});
            sql = "select top 500 * from " + Tool.getBizLuceneTable(this.bizUnit) + " where fdc =? and fnode=? and fop ='" + (Object)((Object)IndexBizState.OP_TO_DELETE_LATER) + "' and fdirName like '" + LuceneEngine.getServerName() + "%'";
            ArrayList list2 = SQL.executeQuery((String)dc, (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{dc, LuceneEngine.getNode().getID()});
            list.addAll(list2);
            if (list.size() == 0) {
                LuceneEngine.nodeCoordinator.doThing(new SyncWorkModeCmd(dc, WorkMode.NORMAL));
            }
        }
        return list;
    }

    private String secondBefore() {
        return new Timestamp(System.currentTimeMillis() - 3000L).toString().substring(0, 19);
    }

    private boolean setDoingIndexState(LuceneBizId lbd, String dc) throws BOSException {
        if (lbd.getOp().equals((Object)IndexBizState.OP_TO_DELETE_LATER)) {
            return true;
        }
        String sql = "update " + Tool.getBizLuceneTable(this.bizUnit) + " set fop ='" + (Object)((Object)IndexBizState.OP_DOING_INDEX) + "' where fbillid = ? and fnode = ? and fop <> '" + (Object)((Object)IndexBizState.OP_DOING_INDEX) + "'";
        return SQL.executeUpdate((String)dc, (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{lbd.getBizId(), lbd.getNode()}) > 0;
    }

    private void transformTodcMap(Object obj, String dc) throws BOSException {
        LuceneBizId lbd = IndexUtil.toLuceneBizId(obj);
        if (!this.setDoingIndexState(lbd, dc)) {
            return;
        }
        this.innerAddMap(this.dirIdMap, lbd);
    }

    private void innerAddMap(Map<String, LinkedList<LuceneBizId>> map, LuceneBizId lbd) {
        LinkedList<LuceneBizId> raw = map.get(lbd.getIndexDirName());
        if (raw == null) {
            LinkedList<LuceneBizId> list = new LinkedList<LuceneBizId>();
            list.add(lbd);
            map.put(lbd.getIndexDirName(), list);
        } else {
            map.get(lbd.getIndexDirName()).add(lbd);
        }
    }

    @Override
    public void run() {
        do {
            this.work();
            try {
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (LuceneEngine.getEngine(this.dc).isRunning());
    }
}

