/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.Context;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.IndexBizState;
import com.kingdee.bos.search.lucene.bean.TempBizId;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

public class IndexService {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(IndexService.class);
    public static final IndexService INS = new IndexService();
    private BlockingQueue<TempBizId> bizIdQueue = new LinkedBlockingQueue<TempBizId>();
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private HashMap<String, LuceneEngine> engines = new HashMap();

    private IndexService() {
        this.init();
    }

    public void submit(Context ctx, String bosType, String bizId) throws Exception {
        LuceneEngine engine = LuceneEngine.getEngine(ctx.getAIS());
        if (engine == null || engine.testBosType(bosType)) {
            return;
        }
        this.bizIdQueue.offer(new TempBizId(ctx, bosType, bizId, IndexBizState.OP_TO_ADD));
    }

    public void delete(Context ctx, String bosType, String bizId) throws Exception {
    }

    private void init() {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            TempBizId t;
                            Context ctx;
                            LuceneEngine engine;
                            if (!(engine = LuceneEngine.getEngine((ctx = (t = (TempBizId)IndexService.this.bizIdQueue.take()).getCtx()).getAIS())).bizPlugin().getRealBizId(t)) {
                                continue;
                            }
                            boolean ifInLucene = engine.dataRepository().exist(ctx, t);
                            if (ifInLucene && t.getOp() == IndexBizState.OP_TO_ADD) {
                                t.setOp(IndexBizState.OP_TO_UPDATE);
                            }
                            if (t.getOp() == IndexBizState.OP_TO_ADD) {
                                engine.dataRepository().save(ctx, t);
                                continue;
                            }
                            engine.dataRepository().update(ctx, t);
                        }
                    }
                    catch (Throwable e) {
                        logger.error("error", e);
                        continue;
                    }
                    break;
                }
            }
        });
    }
}

