/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.search.biz.BOSSearchBizPlugin;
import com.kingdee.bos.search.biz.BOSSearchBizPluginManager;
import com.kingdee.bos.search.biz.DocBuilderManager;
import com.kingdee.bos.search.biz.IBOSSearchBizPlugin;
import com.kingdee.bos.search.dao.BaseCfgDAO;
import com.kingdee.bos.search.dao.SearchBizCfgDAO;
import com.kingdee.bos.search.ksconnection.KSConnectionPoolFactory;
import com.kingdee.bos.search.ksconnection.KSPool;
import com.kingdee.bos.search.ksconnection.KSearchConnection;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.IndexAcquirer;
import com.kingdee.bos.search.lucene.IndexDispatcher;
import com.kingdee.bos.search.lucene.IndexSearchProvider;
import com.kingdee.bos.search.lucene.IndexUtil;
import com.kingdee.bos.search.lucene.NodeLiveStateTask;
import com.kingdee.bos.search.lucene.SearchUpdater;
import com.kingdee.bos.search.lucene.TimeCaliper;
import com.kingdee.bos.search.lucene.bean.BaseConfig;
import com.kingdee.bos.search.lucene.bean.KSField;
import com.kingdee.bos.search.lucene.bean.SearchApp;
import com.kingdee.bos.search.lucene.bean.SearchBizCfg;
import com.kingdee.bos.search.lucene.bean.SearchResult;
import com.kingdee.bos.search.lucene.bean.WorkMode;
import com.kingdee.bos.search.lucene.cluster.ClearNodeSetCmd;
import com.kingdee.bos.search.lucene.cluster.NodeCoordinator;
import com.kingdee.bos.search.lucene.monitor.DeletePolicy;
import com.kingdee.bos.search.lucene.monitor.LuceneNode;
import com.kingdee.bos.search.lucene.monitor.LuceneNodeTool;
import com.kingdee.bos.search.lucene.monitor.NodeSynchronizer;
import com.kingdee.bos.search.metas.MonitorTimeEnum;
import com.kingdee.bos.search.msic.DDLTool;
import com.kingdee.bos.search.repository.DefaultBizDataRepos;
import com.kingdee.bos.search.repository.IBizDataRepository;
import com.kingdee.bos.search.schema.DateRange;
import com.kingdee.bos.search.schema.DocDataImport;
import com.kingdee.bos.search.schema.KSearchSchema;
import com.kingdee.bos.service.job.util.SQL;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.IndexWriter;

public class LuceneEngine {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(LuceneEngine.class);
    private static String IP;
    public static final int INDEX_DIR_NUMS = 1;
    public static final int MAX_ELECTION_TIMES = 13;
    public static final String LOCK_FILE = "write.lock";
    public static final int ThreadNums;
    public static final List<SearchResult> EMPTYSearchResult;
    public static final String bizFinishedName = "bizFinished";
    public static final long nodeIdleTimeout = 86400000L;
    public static final int DEFAULT_TOP_QUERY = 500;
    public static final int MAX_TOP_QUERY = 1000;
    public static final String[] DEFAULT_SELECTORS;
    private static String ROOT_INDEX_DIR;
    private static String serverName;
    private Map<String, Context> proxyCtxMap;
    private List<SearchBizCfg> searchBizCfgs;
    private Set<String> bosTypeSet = new HashSet<String>();
    private Set<String> disabledBosTypeSet = new HashSet<String>();
    private static String[] bizUnits;
    private boolean keepRunning = false;
    public static boolean getIPFromDb;
    private static LuceneNode myNode;
    private BaseConfig baseCfg;
    private static final Set<LuceneNode> luceneNodes;
    static Map<String, TimeCaliper> timeCalpers;
    private Map<String, File[]> bizDcFiles = new HashMap<String, File[]>();
    private Map<String, IndexWriter> bizDcFileWriters = new HashMap<String, IndexWriter>();
    private Map<String, IndexWriter> bizFinishedWriters = new HashMap<String, IndexWriter>();
    private ConcurrentHashMap<String, IndexSearchProvider> searchProviders = new ConcurrentHashMap();
    private IBizDataRepository bizDataRepos = null;
    private IBOSSearchBizPlugin bizPlugin = null;
    private DeletePolicy deletePolicy = null;
    private WorkMode workMode = WorkMode.NORMAL;
    private static ConcurrentHashMap<String, LuceneEngine> engineMap;
    private Map<String, Integer> cleanProgress = new HashMap<String, Integer>();
    private Map<String, SearchUpdater> updaters = new HashMap<String, SearchUpdater>();
    public static final NodeCoordinator nodeCoordinator;
    public static final Set<String> threadTaskSet;
    private String dc;
    private Map<String, KSPool> ksPools = new HashMap<String, KSPool>();

    public LuceneEngine(String dc, BaseConfig baseCfg) {
        this.dc = dc;
        this.baseCfg = baseCfg;
    }

    public static LuceneEngine getEngine(String dc) {
        LuceneEngine engine = engineMap.get(dc);
        if (engine == null) {
            try {
                BaseConfig cfg = BaseCfgDAO.INS.load(dc);
                if (!cfg.isBoot()) {
                    return null;
                }
                engine = new LuceneEngine(dc, cfg);
                engineMap.put(dc, engine);
                engine.start();
            }
            catch (BOSException e) {
                logger.error("", e);
            }
        }
        return engine;
    }

    public void start() {
        if (!this.baseCfg.isBoot()) {
            logger.error("\u6570\u636e\u4e2d\u5fc3{" + this.dc + "}\u672a\u542f\u7528\u5168\u6587\u68c0\u7d22\u670d\u52a1");
            return;
        }
        if (this.keepRunning) {
            return;
        }
        this.keepRunning = true;
        this.initRootDir();
        this.initProxyContext();
        this.initDataTable();
        this.initOthers();
        this.initIndexDirs();
        this.initKSPools();
        this.initLuceneNode();
        this.initWriter();
        this.startNodeLiveState();
        this.startIndexAcquirer();
        this.startDispatcher();
        this.startSeachUpdater();
    }

    public SearchApp searchApp() {
        return this.baseCfg.getSearchApp();
    }

    public WorkMode getWorkMode() {
        return this.workMode;
    }

    public void setWorkMode(WorkMode workMode) {
        this.workMode = workMode;
    }

    public boolean isRunning() {
        return this.keepRunning;
    }

    public void stop() {
        this.keepRunning = false;
        if (this.getUpdater(this.dc) != null) {
            this.getUpdater(this.dc).update("STOP_MY_SELF");
        }
        this.closeWriters();
        this.closeReaders();
        this.bizDcFiles.clear();
        BOSSearchBizPluginManager.clear();
        DocBuilderManager.clear();
        this.ksPools.clear();
    }

    public void stop(String bosType) {
        for (SearchBizCfg cfg : this.searchBizCfgs) {
            if (!cfg.getBosType().equals(bosType)) continue;
            cfg.setEnable(false);
            this.disabledBosTypeSet.add(bosType);
            break;
        }
    }

    public void start(String bosType) {
        this.disabledBosTypeSet.remove(bosType);
    }

    public boolean testBosType(String bosType) {
        if (!this.isRunning() || !this.baseCfg.isBoot()) {
            logger.error("LuceneEngine{" + this.dc + "} isRunning : " + this.isRunning() + " , isBoot() : " + this.baseCfg.isBoot());
            return false;
        }
        if (this.disabledBosTypeSet.contains(bosType)) {
            logger.error("LuceneEngine{" + this.dc + "}, \u5355\u636e\u7c7b\u578b(" + bosType + ")\u5df2\u5173\u95ed\u5168\u6587\u68c0\u7d22\u670d\u52a1");
            return false;
        }
        if (!this.bosTypeSet.contains(bosType)) {
            logger.error("LuceneEngine{" + this.dc + "}, \u5355\u636e\u7c7b\u578b(" + bosType + ")\u672a\u6ce8\u518c\u5168\u6587\u68c0\u7d22\u670d\u52a1");
            return false;
        }
        return true;
    }

    private void initOthers() {
        this.bizDataRepos = new DefaultBizDataRepos();
        this.bizPlugin = new BOSSearchBizPlugin();
        this.deletePolicy = new DeletePolicy(this.dc);
    }

    public void cleanData(MonitorTimeEnum timeEnum, String[] bosTypes) throws BOSException {
        this.deletePolicy.delete(timeEnum, bosTypes);
    }

    public Map<String, Integer> getCleanProgress() {
        return this.cleanProgress;
    }

    public Context getCtx(String dc) {
        return this.proxyCtxMap.get(dc);
    }

    public IBizDataRepository dataRepository() {
        return this.bizDataRepos;
    }

    public IBOSSearchBizPlugin bizPlugin() {
        return this.bizPlugin;
    }

    public List<SearchBizCfg> getBizCfgs() {
        return this.searchBizCfgs;
    }

    private void startNodeLiveState() {
        String prefix = "KSEARCH_NODE_MONITOR_";
        String name = prefix + this.dc;
        if (threadTaskSet.add(name)) {
            NodeLiveStateTask nodeLiveStateTask = new NodeLiveStateTask(this.dc, this.baseCfg);
            Thread t = new Thread(nodeLiveStateTask);
            t.setName(prefix + this.dc);
            t.start();
        }
    }

    public void startDataSyncJob(Context ctx, String bostype, String createTimeField, DateRange dateRange, List<DateRange> dateRanges) {
        SearchBizCfg cfg = this.getBizCfg(bostype);
        if (createTimeField == null) {
            createTimeField = cfg.getBizCreateTimeField();
        }
        String tName = "KSEARCH_DATA_IMPORT_" + ctx.getAIS();
        DocDataImport importJob = null;
        importJob = dateRanges != null ? new DocDataImport(ctx, cfg, createTimeField, dateRanges, true) : new DocDataImport(ctx, cfg, createTimeField, dateRange);
        Thread t = new Thread(importJob);
        t.setName(tName);
        t.start();
    }

    private SearchBizCfg getBizCfg(String bostype) {
        SearchBizCfg cfg = null;
        for (SearchBizCfg bizcfg : this.searchBizCfgs) {
            if (!bizcfg.getBosType().equals(bostype)) continue;
            cfg = bizcfg;
            break;
        }
        return cfg;
    }

    private void initRootDir() {
        String path = System.getProperty("EAS_INSTANCE_HOME");
        String[] temp = path.split("/");
        serverName = temp[temp.length - 1];
        if (this.baseCfg.getSearchApp() == SearchApp.EASLocal) {
            // empty if block
        }
    }

    private void initProxyContext() {
        this.proxyCtxMap = new HashMap<String, Context>();
        Context ctx = new Context((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"), "eas", this.dc, null);
        ctx.setUserName("Administrator");
        ctx.setClientHostIP(LuceneEngine.getIP());
        this.proxyCtxMap.put(this.dc, ctx);
    }

    private void initDataTable() {
        for (String bizUnit : bizUnits) {
            try {
                DDLTool.createIndexTable(this.dc, bizUnit);
            }
            catch (BOSException e) {
                logger.error("initDataTable error:" + this.dc + "..." + bizUnit, e);
            }
        }
    }

    private void initIndexDirs() {
        try {
            this.searchBizCfgs = SearchBizCfgDAO.INS.load(this.dc);
            this.loadBosTypeSet(this.searchBizCfgs);
            for (SearchBizCfg bizcfg : this.searchBizCfgs) {
                this.innerLoadBizIndex(bizcfg);
            }
        }
        catch (Exception e) {
            logger.error("init lucene index dir error:", e);
        }
    }

    private void initKSPools() {
        for (SearchBizCfg cfg : this.searchBizCfgs) {
            try {
                String key = this.dc + "_" + cfg.getBosType();
                if (cfg.getBosType().endsWith("log")) {
                    key = "EASLOG_" + cfg.getBosType();
                }
                KSConnectionPoolFactory factory = new KSConnectionPoolFactory(this.baseCfg, key);
                KSPool kspool = new KSPool(factory);
                kspool.addObjects(this.baseCfg.getPath(), 20);
                this.ksPools.put(key, kspool);
            }
            catch (Exception e) {
                this.keepRunning = false;
                logger.error("\u8fde\u63a5\u5168\u6587\u68c0\u7d22\u670d\u52a1(" + (Object)((Object)this.baseCfg.getSearchApp()) + ")\u5931\u8d25", e);
            }
        }
    }

    public static LuceneEngine getEngine4EasLog() {
        Iterator<Map.Entry<String, LuceneEngine>> ite = engineMap.entrySet().iterator();
        if (ite.hasNext()) {
            return ite.next().getValue();
        }
        return null;
    }

    private boolean innerLoadBizIndex(SearchBizCfg bizcfg) throws SQLException {
        boolean isSuccess = true;
        BOSSearchBizPluginManager.register(this.dc, bizcfg.getBosType(), bizcfg.getClassName());
        if (this.baseCfg.getSearchApp() != SearchApp.EASLocal) {
            isSuccess = KSearchSchema.buildBizIndexDir(this.baseCfg.getPath(), this.dc, bizcfg);
        }
        DocBuilderManager.register(this.getCtx(this.dc), bizcfg);
        return isSuccess;
    }

    private void initLuceneNode() {
        NodeSynchronizer.work(this.dc);
    }

    private void initWriter() {
    }

    private void startIndexAcquirer() {
        for (String bizUnit : bizUnits) {
            IndexAcquirer acquireTask = new IndexAcquirer(this.dc, bizUnit);
            Thread t = new Thread(acquireTask);
            t.setName("KSEARCH_ACRUIRER_" + this.dc + "_" + bizUnit);
            t.start();
        }
    }

    private void startDispatcher() {
        for (String bizUnit : bizUnits) {
            IndexDispatcher dispatchTask = new IndexDispatcher(this.dc, bizUnit);
            Thread t = new Thread(dispatchTask);
            t.setName("KSEARCH_DISPATCHER_" + this.dc + "_" + bizUnit);
            t.start();
        }
    }

    private void startSeachUpdater() {
    }

    public SearchUpdater getUpdater(String dc) {
        return this.updaters.get(dc);
    }

    public static Set<LuceneNode> getNodeSet(Context ctx) throws BOSException {
        if (luceneNodes.size() > 0) {
            return luceneNodes;
        }
        String sql = "select * from T_LUCENE_NODE";
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql);
        for (Object obj : list) {
            luceneNodes.add(LuceneNodeTool.mapToLuceneNode((Map)obj));
        }
        return luceneNodes;
    }

    public static void clearNodeSet() {
        luceneNodes.clear();
    }

    public void solidify() {
        this.bizDcFiles = Collections.unmodifiableMap(this.bizDcFiles);
        this.bizDcFileWriters = Collections.unmodifiableMap(this.bizDcFileWriters);
    }

    public Map<String, IndexWriter> getWriters() {
        return this.bizDcFileWriters;
    }

    public IndexWriter getFinishedWriter(String bosType) {
        return null;
    }

    public static LuceneNode getNode() {
        return myNode;
    }

    public static void reloadNode(Context ctx) throws BOSException {
        LuceneEngine.reloadNodeInner(ctx.getAIS(), myNode.getID());
    }

    public static void reloadNodeInner(String dc, String id) throws BOSException {
        String sql = "select * from T_LUCENE_NODE where fid=?";
        ArrayList list = SQL.executeQuery((String)dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{id});
        for (Object obj : list) {
            myNode = LuceneNodeTool.mapToLuceneNode((Map)obj);
        }
    }

    public static String getServerName() {
        return serverName;
    }

    public IndexWriter getWriter(String bizKey, String dc, String dirName) {
        return this.bizDcFileWriters.get(IndexUtil.generateWK(dc + File.separator + bizKey, dirName));
    }

    public void forceMergeWriters() {
        for (String key : this.bizDcFileWriters.keySet()) {
            try {
                this.bizDcFileWriters.get(key).forceMergeDeletes();
            }
            catch (IOException e) {
                logger.error("forceMergeWriters{" + key + "} error", e);
            }
        }
    }

    public void closeWriters() {
        for (String key : this.bizDcFileWriters.keySet()) {
            try {
                IndexWriter iw = this.bizDcFileWriters.get(key);
                if (iw == null) continue;
                iw.close();
            }
            catch (IOException e) {
                logger.error("close IndexWriter{" + key + "} error", e);
            }
        }
        this.bizDcFileWriters.clear();
    }

    public void closeReaders() {
        for (String key : this.searchProviders.keySet()) {
            this.searchProviders.get(key).close();
        }
        this.searchProviders.clear();
    }

    public Map<String, File[]> getDcFiles() {
        return this.bizDcFiles;
    }

    public ConcurrentHashMap<String, IndexSearchProvider> getSearchProviders() {
        return this.searchProviders;
    }

    public static String getIndexRootDir() {
        return ROOT_INDEX_DIR;
    }

    public static String getIP() {
        try {
            if (IP == null) {
                IP = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            logger.error("", e);
        }
        return IP;
    }

    public static void registerNode(String dc, String ip, String id) throws BOSException {
        String insert = "insert into T_LUCENE_NODE(fid,fip,fholder,ftime) values(?,?,?,?)";
        SQL.executeUpdate((String)dc, (String)insert, (int[])new int[]{12, 12, 12, 93}, (Object[])new Object[]{id, ip, "", new Timestamp(System.currentTimeMillis())});
    }

    public void restartEngine() {
        this.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.start();
    }

    public void reload() {
        nodeCoordinator.syncDo(new ClearNodeSetCmd(this.dc));
    }

    public void reloadCfg() {
        try {
            this.baseCfg = BaseCfgDAO.INS.load(this.dc);
            this.searchBizCfgs = SearchBizCfgDAO.INS.load(this.dc);
            this.loadBosTypeSet(this.searchBizCfgs);
            if (this.baseCfg.isBoot() && !this.isRunning()) {
                this.start();
            }
            if (!this.baseCfg.isBoot() && this.isRunning()) {
                this.stop();
            }
        }
        catch (Exception e) {
            logger.error(this.dc + ": reload failed ", e);
        }
    }

    private void loadBosTypeSet(List<SearchBizCfg> searchBizCfgs) {
        this.disabledBosTypeSet.clear();
        this.bosTypeSet.clear();
        for (SearchBizCfg searchBizCfg : searchBizCfgs) {
            if (searchBizCfg.isEnable()) {
                this.bosTypeSet.add(searchBizCfg.getBosType());
                continue;
            }
            this.disabledBosTypeSet.add(searchBizCfg.getBosType());
        }
    }

    public KSearchConnection getKSConnection(String dc, String bosType) throws Exception {
        String bizKey = dc + "_" + bosType;
        KSPool kspool = this.ksPools.get(bizKey);
        return (KSearchConnection)kspool.getResource(this.baseCfg.getPath() + bizKey);
    }

    public void returnKSConnection(String dc, String bosType, Object resource) throws Exception {
        if (resource == null) {
            return;
        }
        String bizKey = dc + "_" + bosType;
        KSPool kspool = this.ksPools.get(bizKey);
        kspool.returnResource(this.baseCfg.getPath() + bizKey, resource);
    }

    public boolean addBizSchema(Context ctx, SearchBizCfg cfg) throws Exception {
        if (!this.innerLoadBizIndex(cfg)) {
            return false;
        }
        SearchBizCfgDAO.INS.add(this.dc, cfg);
        this.reloadCfg();
        this.buildKsPools(cfg);
        return true;
    }

    private void buildKsPools(SearchBizCfg cfg) {
        String key = this.dc + "_" + cfg.getBosType();
        KSConnectionPoolFactory factory = new KSConnectionPoolFactory(this.baseCfg, key);
        KSPool kspool = new KSPool(factory);
        try {
            kspool.addObjects(this.baseCfg.getPath(), 5);
            this.ksPools.put(key, kspool);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316ksconnection\u8fde\u63a5\u6c60\u5931\u8d25");
        }
    }

    public boolean updateBizSchema(Context ctx, String bostype, List<KSField> fields, String bizCreateTimeField) throws Exception {
        SearchBizCfg cfg = SearchBizCfgDAO.INS.loadByBosType(ctx.getAIS(), bostype);
        cfg.setFields(fields);
        cfg.setBizCreateTimeField(bizCreateTimeField);
        if (!this.innerLoadBizIndex(cfg)) {
            return false;
        }
        SearchBizCfgDAO.INS.updateBizFields(this.dc, bostype, fields, bizCreateTimeField);
        this.reloadCfg();
        this.startDataSyncJob(ctx, cfg.getBosType(), cfg.getBizCreateTimeField(), new DateRange(cfg.getStartTime()), null);
        return true;
    }

    public boolean deleteBizSchema(Context ctx, String bostype) throws Exception {
        if (!KSearchSchema.unloadCore(this.baseCfg.getPath(), ctx.getAIS(), bostype)) {
            return false;
        }
        SearchBizCfgDAO.INS.delete(ctx.getAIS(), bostype);
        KSPool kspool = this.ksPools.remove(ctx.getAIS() + "_" + bostype);
        kspool.close();
        return true;
    }

    static {
        ThreadNums = Runtime.getRuntime().availableProcessors() * 2 + 1;
        EMPTYSearchResult = new ArrayList<SearchResult>();
        DEFAULT_SELECTORS = new String[]{"creator", "createTime", "lastUpdateUser", "lastUpdateTime"};
        bizUnits = new String[]{"wfr", "biz"};
        getIPFromDb = false;
        myNode = null;
        luceneNodes = new HashSet<LuceneNode>();
        timeCalpers = new HashMap<String, TimeCaliper>();
        engineMap = new ConcurrentHashMap();
        nodeCoordinator = new NodeCoordinator();
        threadTaskSet = new HashSet<String>();
    }
}

