/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.IndexUtil;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.LuceneSendMsg;
import com.kingdee.bos.search.lucene.bean.BaseConfig;
import com.kingdee.bos.search.lucene.bean.LuceneMsg;
import com.kingdee.bos.search.lucene.bean.SearchApp;
import com.kingdee.bos.search.lucene.bean.WorkMode;
import com.kingdee.bos.search.lucene.monitor.LuceneNodeTool;
import com.kingdee.bos.search.metas.BizCFGFactory;
import com.kingdee.bos.search.metas.BizCFGInfo;
import com.kingdee.bos.search.metas.BizMonitorCapacityFactory;
import com.kingdee.bos.search.metas.BizMonitorCapacityInfo;
import com.kingdee.bos.search.metas.IBizCFG;
import com.kingdee.bos.search.metas.IBizMonitorCapacity;
import com.kingdee.bos.search.metas.MonitorTimeEnum;
import com.kingdee.bos.search.msic.Tool;
import com.kingdee.bos.search.schema.KSearchSchema;
import com.kingdee.bos.service.job.util.SQL;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class NodeLiveStateTask
implements Runnable {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(NodeLiveStateTask.class);
    private String dc;
    private Context ctx;
    private BaseConfig baseCfg;
    private int SLEEPTIME = 180;

    public NodeLiveStateTask(String dc, BaseConfig baseCfg) {
        this.dc = dc;
        LuceneEngine engine = LuceneEngine.getEngine(dc);
        this.ctx = engine.getCtx(dc);
        this.baseCfg = baseCfg;
    }

    @Override
    public void run() {
        LuceneEngine engine;
        do {
            boolean locked = this.tryLock();
            try {
                if (locked) {
                    this.nodeIndexMonitor();
                }
                Thread.sleep((long)this.SLEEPTIME * 1000L);
            }
            catch (InterruptedException e) {
                logger.error("", e);
            }
            finally {
                if (locked) {
                    this.unLock();
                }
            }
        } while ((engine = LuceneEngine.getEngine(this.dc)).isRunning());
        LuceneEngine.threadTaskSet.remove(Thread.currentThread().getName());
    }

    private void nodeIndexMonitor() {
        try {
            Map<String, Map<String, Object>> bizDirSizeMap = this.getBizDirSizeMap();
            HashMap<String, Integer> bosTypeToNum = this.updateBizCFG(bizDirSizeMap);
            this.updateBizCapacity(bizDirSizeMap, bosTypeToNum);
            long totalCapacity = this.updateBaseConfigCapacity(bizDirSizeMap);
            this.judgeSendMsg(totalCapacity);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    private long updateBaseConfigCapacity(Map<String, Map<String, Object>> bizDirSizeMap) throws BOSException {
        long totalCapacity = 0L;
        for (String key : bizDirSizeMap.keySet()) {
            totalCapacity += Long.valueOf(bizDirSizeMap.get(key).get("size").toString()).longValue();
        }
        String updateSql = "update t_lucene_baseConfig set FCURCAPACITY=?";
        SQL.executeUpdate((String)this.dc, (String)updateSql, (int[])new int[]{12}, (Object[])new Object[]{String.valueOf(totalCapacity)});
        return totalCapacity;
    }

    private void updateBizCapacity(Map<String, Map<String, Object>> bizDirSizeMap, HashMap<String, Integer> bosTypeToNum) throws BOSException {
        HashMap<MonitorTimeEnum, Timestamp> timeStampMap = this.getTimestamp();
        IBizMonitorCapacity bizMonitorCapacity = BizMonitorCapacityFactory.getLocalInstance(this.ctx);
        for (MonitorTimeEnum time : timeStampMap.keySet()) {
            Timestamp timestamp = timeStampMap.get((Object)time);
            String querySql = "SELECT count(fbillid) as count,fbostype FROM t_wfr_luceneBizId where FOPTIME < ? group by fbostype union all SELECT count(fbillid) as count,fbostype FROM t_wfr_luceneBizIdDel where FOPTIME < ?  group by fbostype union all SELECT count(fbillid) as count,fbostype FROM t_biz_lucenebizid where FOPTIME < ?  group by fbostype union all SELECT count(fbillid) as count,fbostype FROM t_biz_luceneBizIdDel where FOPTIME < ?  group by fbostype";
            ArrayList list = SQL.executeQuery((String)this.dc, (String)querySql, (int[])new int[]{93, 93, 93, 93}, (Object[])new Object[]{timestamp, timestamp, timestamp, timestamp});
            HashMap<String, Integer> bosTypeToCount = new HashMap<String, Integer>();
            for (Object o : list) {
                String bostype = (String)((Map)o).get("fbostype");
                int count = Integer.parseInt(((Map)o).get("count").toString());
                if (bosTypeToCount.containsKey(bostype)) {
                    bosTypeToCount.put(bostype, (Integer)bosTypeToCount.get(bostype) + count);
                    continue;
                }
                bosTypeToCount.put(bostype, count);
            }
            for (String bosType : bizDirSizeMap.keySet()) {
                if (!bosTypeToCount.containsKey(bosType)) {
                    String deleteSql = "delete from t_lucene_bizMonitorCapacity where fbostype = ? and ftimeago=?";
                    SQL.executeUpdate((String)this.dc, (String)deleteSql, (int[])new int[]{12, 4}, (Object[])new Object[]{bosType, time.getValue()});
                    continue;
                }
                long capacity = Long.valueOf(bizDirSizeMap.get(bosType).get("size").toString());
                float radios = (float)((Integer)bosTypeToCount.get(bosType)).intValue() / (float)bosTypeToNum.get(bosType).intValue();
                long curTimeCapacity = Float.valueOf((float)capacity * radios).longValue();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
                filter.getFilterItems().add(new FilterItemInfo("timeAgo", (Object)time.getValue()));
                if (bizMonitorCapacity.exists(filter)) {
                    String updateSql = "update t_lucene_bizMonitorCapacity set findexnumber=?,findexsize=?  where fbostype = ? and ftimeago=?";
                    SQL.executeUpdate((String)this.dc, (String)updateSql, (int[])new int[]{4, 12, 12, 4}, (Object[])new Object[]{bosTypeToCount.get(bosType), Long.toString(curTimeCapacity), bosType, time.getValue()});
                    continue;
                }
                BizMonitorCapacityInfo bizMonitorCapacityInfo = new BizMonitorCapacityInfo();
                bizMonitorCapacityInfo.setBosType(bosType);
                bizMonitorCapacityInfo.setTimeAgo(time);
                bizMonitorCapacityInfo.setIndexNumber((Integer)bosTypeToCount.get(bosType));
                bizMonitorCapacityInfo.setIndexSize(Long.toString(curTimeCapacity));
                bizMonitorCapacity.addnew(bizMonitorCapacityInfo);
            }
        }
    }

    private HashMap<String, Integer> updateBizCFG(Map<String, Map<String, Object>> bizDirSizeMap) throws BOSException {
        String querySql = "SELECT count(fbillid) as count,fbostype FROM t_wfr_luceneBizId group by fbostype union all SELECT count(fbillid) as count,fbostype FROM t_wfr_luceneBizIdDel group by fbostype union all SELECT count(fbillid) as count,fbostype FROM t_biz_lucenebizid group by fbostype union all SELECT count(fbillid) as count,fbostype FROM t_biz_luceneBizIdDel group by fbostype";
        ArrayList list = SQL.executeQuery((String)this.dc, (String)querySql);
        HashMap<String, Integer> bosTypeToNum = new HashMap<String, Integer>();
        IBizCFG bizCFG = BizCFGFactory.getLocalInstance(this.ctx);
        for (Object o : list) {
            String bostype = (String)((Map)o).get("fbostype");
            Integer count = Integer.parseInt(((Map)o).get("count").toString());
            if (bosTypeToNum.containsKey(bostype)) {
                bosTypeToNum.put(bostype, bosTypeToNum.get(bostype) + count);
                continue;
            }
            bosTypeToNum.put(bostype, count);
        }
        for (String bosType : bizDirSizeMap.keySet()) {
            if (bosType == null || bosType.length() == 0) continue;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
            Map<String, Object> map = bizDirSizeMap.get(bosType);
            if (bizCFG.exists(filter)) {
                String updateSql = "update T_LUCENE_BIZCFG set findexSize=?,fpath=?  where fbostype = ?";
                SQL.executeUpdate((String)this.dc, (String)updateSql, (int[])new int[]{12, 12, 12}, (Object[])new Object[]{String.valueOf(map.get("size")), (String)map.get("path"), bosType});
                continue;
            }
            BizCFGInfo bizCFGInfo = new BizCFGInfo();
            bizCFGInfo.setBosType(bosType);
            bizCFGInfo.setIndexSize(String.valueOf(map.get("size")));
            bizCFGInfo.setPath((String)map.get("path"));
            bizCFG.addnew(bizCFGInfo);
        }
        return bosTypeToNum;
    }

    private void judgeSendMsg(long totalCapacity) {
        int beyondRatio;
        float f;
        BaseConfig baseCFG = LuceneNodeTool.loadBaseCfg(this.dc);
        int maxCapacity = baseCFG.getCapacity();
        long l = maxCapacity;
        if ((float)totalCapacity > (float)(l * 0x40000000L) * ((f = (float)(beyondRatio = baseCFG.getBeyondRatio())) / 100.0f)) {
            LuceneMsg lucenMsg = new LuceneMsg();
            lucenMsg.setTitle("\u641c\u7d22\u670d\u52a1\u78c1\u76d8\u9884\u8b66");
            lucenMsg.setBody("\u6570\u636e\u4e2d\u5fc3" + this.dc + "\uff0c\u641c\u7d22\u670d\u52a1\u5360\u7528\u8d85\u8fc7" + beyondRatio + "%\uff08\u76f8\u5bf9\u8bbe\u7f6e\u7684\u6700\u5927\u78c1\u76d8\u5bb9\u91cf:" + l + "GB\uff09\uff0c\u76ee\u524d\u7d22\u5f15\u5df2\u4f7f\u7528\u78c1\u76d8:" + IndexUtil.transferUnit(totalCapacity) + "\uff0c\u8bf7\u53ca\u65f6\u8fdb\u884c\u78c1\u76d8\u6e05\u7406");
            new LuceneSendMsg(lucenMsg, this.ctx).send();
        }
    }

    private long getTime(int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        Date dNow = new Date();
        Date offsetTime = new Date();
        calendar.setTime(dNow);
        calendar.add(field, amount);
        offsetTime = calendar.getTime();
        return offsetTime.getTime();
    }

    private HashMap<MonitorTimeEnum, Timestamp> getTimestamp() {
        HashMap<MonitorTimeEnum, Timestamp> hashMap = new HashMap<MonitorTimeEnum, Timestamp>();
        long time = this.getTime(2, -3);
        hashMap.put(MonitorTimeEnum.ThreeMonthsAgo, new Timestamp(time));
        time = this.getTime(2, -6);
        hashMap.put(MonitorTimeEnum.HalfYearAgo, new Timestamp(time));
        time = this.getTime(1, -1);
        hashMap.put(MonitorTimeEnum.AYearAgo, new Timestamp(time));
        time = this.getTime(1, -2);
        hashMap.put(MonitorTimeEnum.TwoYearsAgo, new Timestamp(time));
        return hashMap;
    }

    private Map<String, Map<String, Object>> getBizDirSizeMap() throws IOException {
        File[] fs;
        if (this.baseCfg.getSearchApp() == SearchApp.Solr) {
            return this.getBizDirSizeMapFromSolr();
        }
        HashMap<String, Map<String, Object>> maps = new HashMap<String, Map<String, Object>>();
        String root = LuceneEngine.getIndexRootDir() + File.separator + this.dc;
        File ir = new File(root);
        for (File f : fs = ir.listFiles()) {
            if (f.getName().equals("uuid.data")) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("size", IndexUtil.sizeOfDirectory(f));
            map.put("path", f.getPath());
            maps.put(f.getName(), map);
        }
        return maps;
    }

    private Map<String, Map<String, Object>> getBizDirSizeMapFromSolr() throws IOException {
        Map map = KSearchSchema.getKsMonitorInfo(this.baseCfg.getPath());
        HashMap<String, Map<String, Object>> infos = new HashMap<String, Map<String, Object>>();
        for (Object obj : map.keySet()) {
            String key = (String)obj;
            if (!key.startsWith(this.dc + "/")) continue;
            key = key.split("/")[1];
            infos.put(key, (Map)map.get(obj));
        }
        return infos;
    }

    private boolean tryLock() {
        if (LuceneEngine.getEngine(this.dc).getWorkMode() == WorkMode.CLEAN_DATA) {
            return false;
        }
        String holder = LuceneEngine.getIP() + "/" + LuceneEngine.getServerName();
        try {
            String sql = "select fid from T_LUCENE_NODE where fholder = ? and fid = ?";
            ArrayList list = SQL.executeQuery((String)this.dc, (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{holder, LuceneEngine.getNode().getID()});
            if (list.size() > 0) {
                sql = "update T_LUCENE_NODE set ftime=? where fid = ?";
                SQL.executeUpdate((String)this.dc, (String)sql, (int[])new int[]{93, 12}, (Object[])new Object[]{Tool.now(), LuceneEngine.getNode().getID()});
                return true;
            }
            sql = "select fid from T_LUCENE_NODE where (fholder is null or ftime < {ts '" + this.secondBefore() + "'}) and fid = ?";
            list = SQL.executeQuery((String)this.dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{LuceneEngine.getNode().getID()});
            if (list.size() > 0) {
                sql = "update T_LUCENE_NODE set fholder = ?,ftime=? where fid = ? ";
                int i = SQL.executeUpdate((String)this.dc, (String)sql, (int[])new int[]{12, 93, 12}, (Object[])new Object[]{holder, Tool.now(), LuceneEngine.getNode().getID()});
                return i > 0;
            }
        }
        catch (Exception e) {
            logger.error("check if node is alive in {" + this.dc + "}.error", e);
        }
        return false;
    }

    private void unLock() {
        String sql = "update T_LUCENE_NODE set fholder = null where fid = ?";
        try {
            SQL.executeUpdate((String)this.dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{LuceneEngine.getNode().getID()});
        }
        catch (BOSException e) {
            logger.error("unlock {" + this.dc + "}.error", e);
        }
    }

    private String secondBefore() {
        return new Timestamp(System.currentTimeMillis() - (long)this.SLEEPTIME * 1500L).toString().substring(0, 19);
    }
}

