/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.search.lucene.IndexSearchProvider;
import com.kingdee.bos.search.lucene.bean.KSField;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import com.kingdee.bos.search.lucene.tool.KSFieldCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class NormalSearchWorker
implements Callable<List<Map<String, String>>> {
    private IndexSearchProvider provider;
    private Query query;
    private SearchParam param;

    public NormalSearchWorker(IndexSearchProvider provider, Query query, SearchParam param) {
        this.provider = provider;
        this.query = query;
        this.param = param;
    }

    @Override
    public List<Map<String, String>> call() throws Exception {
        IndexSearcher searcher = this.provider.acquire();
        TopDocs docs = searcher.search(this.query, this.param.getTop());
        ScoreDoc[] sdocs = docs.scoreDocs;
        List<KSField> ksFields = KSFieldCache.INS.load(this.param.getDc(), this.param.getBosType());
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        for (ScoreDoc sdoc : sdocs) {
            HashMap<String, String> map = new HashMap<String, String>();
            int docID = sdoc.doc;
            Document doc = searcher.getIndexReader().document(docID);
            for (KSField field : ksFields) {
                String name = field.getName();
                map.put(name, doc.get(name));
            }
            mapList.add(map);
        }
        return mapList;
    }
}

