/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.IndexSearchProvider;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.QueryBuilder;
import com.kingdee.bos.search.lucene.SearchWorker;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import com.kingdee.bos.search.lucene.bean.SearchResult;
import com.kingdee.bos.search.lucene.tool.LuceneSearchThreadFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.lucene.search.Query;

public class SearchService {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(SearchService.class);
    public static SearchService INS = new SearchService();
    private ExecutorService workers = Executors.newFixedThreadPool(LuceneEngine.ThreadNums, new LuceneSearchThreadFactory());

    private SearchService() {
    }

    private String resultToString(List<Future<List<SearchResult>>> futures) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (Future<List<SearchResult>> future : futures) {
            for (SearchResult r : future.get()) {
                sb.append(r);
            }
        }
        return sb.toString();
    }

    public String submitTest(SearchParam param) throws Exception {
        return this.resultToString(this.search(param));
    }

    public List<Future<List<SearchResult>>> search(SearchParam param) {
        ArrayList<Future<List<SearchResult>>> futures = new ArrayList<Future<List<SearchResult>>>();
        LuceneEngine engine = LuceneEngine.getEngine(param.getDc());
        if (engine == null || !engine.testBosType(param.getBosType())) {
            return futures;
        }
        Iterator<IndexSearchProvider> itr = engine.getSearchProviders().values().iterator();
        Query query = QueryBuilder.normalQuery(param);
        while (itr.hasNext()) {
            IndexSearchProvider provider = itr.next();
            if (!provider.getDirName().startsWith(param.getSearchPath())) continue;
            SearchWorker worker = new SearchWorker(provider, query, param);
            futures.add(this.workers.submit(worker));
        }
        return futures;
    }
}

