/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.IndexSearchProvider;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import com.kingdee.bos.search.lucene.bean.SearchResult;
import com.kingdee.bos.search.msic.Tool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class SearchWorker
implements Callable<List<SearchResult>> {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(SearchWorker.class);
    private IndexSearchProvider provider;
    private Query query;
    private SearchParam param;

    public SearchWorker(IndexSearchProvider provider, Query query, SearchParam param) {
        this.provider = provider;
        this.query = query;
        this.param = param;
    }

    public List<SearchResult> work() throws IOException {
        return this.search(this.query, this.param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SearchResult> search(Query query, SearchParam param) throws IOException {
        LuceneEngine luceneEngine = LuceneEngine.getEngine(param.getDc());
        List<SearchResult> resultList = new ArrayList<SearchResult>();
        try {
            luceneEngine.testBosType(param.getBosType());
        }
        catch (Exception e1) {
            logger.error(param.getBosType() + "\u5168\u6587\u68c0\u7d22\u670d\u52a1\u6ca1\u6709\u5f00\u542f\u6216\u8005\u672a\u6ce8\u518c", e1);
            return resultList;
        }
        IndexSearcher searcher = this.provider.acquire();
        try {
            TopDocs docs = searcher.search(query, param.getTop());
            ScoreDoc[] sdocs = docs.scoreDocs;
            ArrayList<Map<String, String>> docMaps = new ArrayList<Map<String, String>>();
            for (ScoreDoc sdoc : sdocs) {
                int docID = sdoc.doc;
                Document doc = searcher.getIndexReader().document(docID);
                docMaps.add(this.docToMap(doc));
            }
            resultList = Tool.getSearchResult(query, param, docMaps);
        }
        catch (Exception e) {
            logger.error("search error", e);
        }
        finally {
            this.provider.release(searcher);
        }
        return resultList;
    }

    private Map<String, String> docToMap(Document doc) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", doc.get("id"));
        map.put("bosType", doc.get("bosType"));
        map.put("e_id", doc.get("e_id"));
        map.put("isEntry", doc.get("isEntry"));
        map.put("billName", doc.get("billName"));
        map.put("docVal", doc.get("docVal"));
        return map;
    }

    @Override
    public List<SearchResult> call() throws Exception {
        return this.work();
    }
}

