/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.search.ksconnection.KSearchConnection;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.DeleteParam;
import com.kingdee.bos.search.lucene.bean.PageResult;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import com.kingdee.bos.search.lucene.bean.SearchResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SolrSearchService {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(SolrSearchService.class);
    public static SolrSearchService INS = new SolrSearchService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> search4List(SearchParam param) {
        List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        LuceneEngine engine = null;
        engine = param.getDc().equals("EASLOG") && param.getBosType().endsWith("log") ? LuceneEngine.getEngine4EasLog() : LuceneEngine.getEngine(param.getDc());
        if (engine == null || !engine.testBosType(param.getBosType())) {
            return listMap;
        }
        KSearchConnection conn = null;
        try {
            conn = engine.getKSConnection(param.getDc(), param.getBosType());
            listMap = conn.query(param);
        }
        catch (Exception e) {
            logger.error("query4List error", e);
        }
        finally {
            try {
                engine.returnKSConnection(param.getDc(), param.getBosType(), conn);
            }
            catch (Exception e) {
                logger.error("reuturnKSConnection fail", e);
            }
        }
        return listMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResult> search4BillInfo(SearchParam param) {
        List<SearchResult> listMap = new ArrayList<SearchResult>();
        LuceneEngine engine = LuceneEngine.getEngine(param.getDc());
        if (engine == null || !engine.testBosType(param.getBosType())) {
            return listMap;
        }
        KSearchConnection conn = null;
        try {
            conn = engine.getKSConnection(param.getDc(), param.getBosType());
            listMap = conn.query4BillInfo(param);
        }
        catch (Exception e) {
            logger.error("query4BillInfo error", e);
        }
        finally {
            try {
                engine.returnKSConnection(param.getDc(), param.getBosType(), conn);
            }
            catch (Exception e) {
                logger.error("reuturnKSConnection fail", e);
            }
        }
        return listMap;
    }

    public void addEasLog(List<Map<String, Object>> logInfos) throws Exception {
        LuceneEngine engine = LuceneEngine.getEngine4EasLog();
        if (engine != null) {
            engine.getKSConnection("EASLOG", "easlog").addEasLog(logInfos);
        }
    }

    public void addEasLog(List<Map<String, Object>> logInfos, String dc, String bosType) throws Exception {
        LuceneEngine engine = LuceneEngine.getEngine4EasLog();
        if (engine != null) {
            engine.getKSConnection(dc, bosType).addEasLog(logInfos, dc, bosType);
        }
    }

    public void deleteDoc(DeleteParam deleteParam) throws Exception {
        logger.error("\u6267\u884csolr \u65e5\u5fd7\u5220\u9664\u64cd\u4f5c \uff1a " + deleteParam.getDc() + "_" + deleteParam.getBosType() + ", " + deleteParam.getDelIds());
        LuceneEngine engine = LuceneEngine.getEngine4EasLog();
        if (engine == null) {
            throw new Exception("error !!!  KSearch engine is null");
        }
        KSearchConnection ksConnection = engine.getKSConnection(deleteParam.getDc(), deleteParam.getBosType());
        if (ksConnection == null) {
            throw new Exception("error !!!  KSearch connection is null");
        }
        if (!deleteParam.isDelAll() && (deleteParam.getDelIds() == null || deleteParam.getDelIds().isEmpty())) {
            logger.error("warn !!! delete param is invalid !!!");
        }
        if (deleteParam.isDelAll()) {
            ksConnection.deleteDoc(deleteParam.getDc(), deleteParam.getBosType(), "*", "*");
        } else if (deleteParam.getDelIds() != null && !deleteParam.getDelIds().isEmpty()) {
            ksConnection.deleteDocs(deleteParam.getDc(), deleteParam.getBosType(), deleteParam.getDelIds());
        } else if (deleteParam.getQueryStr() != null && !"".equals(deleteParam.getQueryStr().trim())) {
            ksConnection.deleteDoc(deleteParam.getDc(), deleteParam.getBosType(), null, deleteParam.getQueryStr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult pageSearch(SearchParam searchParam) {
        LuceneEngine engine = null;
        PageResult pageResult = PageResult.buildResult(searchParam.getStart(), searchParam.getTop());
        engine = searchParam.getDc().equals("EASLOG") && searchParam.getBosType().endsWith("log") ? LuceneEngine.getEngine4EasLog() : LuceneEngine.getEngine(searchParam.getDc());
        if (engine == null || !engine.testBosType(searchParam.getBosType())) {
            return pageResult;
        }
        KSearchConnection conn = null;
        try {
            conn = engine.getKSConnection(searchParam.getDc(), searchParam.getBosType());
            pageResult = conn.pageQuery(searchParam);
        }
        catch (Exception e) {
            logger.error("query4List error", e);
        }
        finally {
            try {
                engine.returnKSConnection(searchParam.getDc(), searchParam.getBosType(), conn);
            }
            catch (Exception e) {
                logger.error("reuturnKSConnection fail", e);
            }
        }
        return pageResult;
    }
}

