/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene.monitor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.IndexBizState;
import com.kingdee.bos.search.lucene.bean.WorkMode;
import com.kingdee.bos.search.lucene.cluster.SyncWorkModeCmd;
import com.kingdee.bos.search.lucene.monitor.DeleteProcessTask;
import com.kingdee.bos.search.metas.MonitorTimeEnum;
import com.kingdee.bos.search.msic.Tool;
import com.kingdee.bos.service.job.util.SQL;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DeletePolicy {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(DeletePolicy.class);
    private String dc;

    public DeletePolicy(String dc) {
        this.dc = dc;
    }

    public void delete(MonitorTimeEnum timeEnum, String[] bosTypes) throws BOSException {
        Timestamp time = this.getTimestamp(timeEnum);
        this.updateDeleteState(time, bosTypes);
    }

    private Timestamp getTimestamp(MonitorTimeEnum timeEnum) throws BOSException {
        long time = 0L;
        if (timeEnum == MonitorTimeEnum.ThreeMonthsAgo) {
            time = this.getTime(2, -3);
        } else if (timeEnum == MonitorTimeEnum.HalfYearAgo) {
            time = this.getTime(2, -6);
        } else if (timeEnum == MonitorTimeEnum.AYearAgo) {
            time = this.getTime(1, -1);
        } else if (timeEnum == MonitorTimeEnum.TwoYearsAgo) {
            time = this.getTime(1, -2);
        } else {
            throw new BOSException("\u672a\u77e5\u7684\u679a\u4e3e\u7c7b\u578b\uff1a" + timeEnum.getAlias());
        }
        return new Timestamp(time);
    }

    private long getTime(int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        Date dNow = new Date();
        Date offsetTime = new Date();
        calendar.setTime(dNow);
        calendar.add(field, amount);
        offsetTime = calendar.getTime();
        return offsetTime.getTime();
    }

    private void updateDeleteState(Timestamp time, String[] bosTypes) throws BOSException {
        int total = 0;
        for (String bosType : bosTypes) {
            String bizUnit = "biz";
            if (bosType.equals("WORKFLOW")) {
                bizUnit = "wfr";
            }
            String timeAgo = "{ts '" + time.toString().substring(0, 19) + "'}";
            String update = "update " + Tool.getBizLuceneTable(bizUnit) + " set fop = '" + (Object)((Object)IndexBizState.OP_TO_DELETE_LATER) + "' where foptime <" + timeAgo + " and fbostype ='" + bosType + "'";
            total += SQL.executeUpdate((String)this.dc, (String)update);
            update = "update " + Tool.getBizDelLuceneTable(bizUnit) + " set fop = '" + (Object)((Object)IndexBizState.OP_TO_DELETE_LATER) + "' where foptime <" + timeAgo + " and fbostype ='" + bosType + "'";
            total += SQL.executeUpdate((String)this.dc, (String)update);
        }
        Thread t = new Thread(new DeleteProcessTask(this.dc, bosTypes, total));
        t.setName("KSEARCH_CLEAN_" + this.dc);
        t.start();
        LuceneEngine.nodeCoordinator.syncDo(new SyncWorkModeCmd(this.dc, WorkMode.CLEAN_DATA));
    }
}

