/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.msic;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.search.lucene.IndexUtil;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.F7Info;
import com.kingdee.bos.search.lucene.bean.FieldBizType;
import com.kingdee.bos.search.lucene.bean.FieldMapInfo;
import com.kingdee.bos.search.lucene.bean.FieldResultValue;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import com.kingdee.bos.search.lucene.bean.SearchResult;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;

public class Tool {
    public static String getBizLuceneTable(String bizUnit) {
        return "T_" + bizUnit.toUpperCase() + "_LUCENEBIZID";
    }

    public static String getBizDelLuceneTable(String bizUnit) {
        return "T_" + bizUnit.toUpperCase() + "_LUCENEBIZIDDEL";
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String bosType(String billId) {
        return new ObjectUuidPK(billId).getObjectType().toString();
    }

    public static List<SearchResult> getSearchResult(Query query, SearchParam param, List<Map<String, String>> docMaps) throws IOException, InvalidTokenOffsetsException {
        ArrayList<SearchResult> resultList = new ArrayList<SearchResult>();
        for (Map<String, String> doc : docMaps) {
            SearchResult result = new SearchResult();
            result.setSearchVal(param.getKeyword());
            FieldMapInfo info = new FieldMapInfo();
            info.setOwnerId(doc.get("o_id"));
            info.setBosType(doc.get("bosType"));
            info.setEntryId(doc.get("e_id"));
            info.setEntry(Boolean.valueOf(doc.get("isEntry")));
            info.setBillName(doc.get("billName"));
            String docVal = doc.get("docVal");
            info.setProps((Map)JSON.parseObject((String)docVal, Map.class));
            result.setBillInfo(info);
            Map map = (Map)JSON.parseObject((String)docVal, Map.class);
            String dc = param.getDc();
            EntityObjectInfo entity = IndexUtil.getEntityObj(LuceneEngine.getEngine(dc).getCtx(dc), info.getBosType());
            Iterator entries = map.entrySet().iterator();
            ArrayList<FieldResultValue> fvs = new ArrayList<FieldResultValue>();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!value.contains("<Strong>") || !value.contains("</Strong>") || Tool.isIdField(key)) continue;
                String highlight = Tool.getHighlight(value);
                String rawVal = Tool.unWrapHighlight(value);
                if (rawVal == null) continue;
                PropertyInfo prop = entity.getPropertyByName(key);
                String alias = null;
                if (prop != null) {
                    alias = prop.getAlias();
                }
                F7Info f7info = Tool.tryMakeF7Field(value);
                FieldResultValue fv = new FieldResultValue(key, alias, rawVal, highlight, f7info);
                fvs.add(fv);
            }
            result.setFieldValue(fvs);
            resultList.add(result);
        }
        return resultList;
    }

    private static boolean isIdField(String key) {
        if (key == null) {
            return false;
        }
        return "id".equalsIgnoreCase(key) || "fid".equalsIgnoreCase(key);
    }

    private static String unWrapHighlight(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith(FieldBizType.$F7$.name())) {
            String[] f7infoArray = value.split(":");
            String[] f7 = f7infoArray[1].split(";");
            boolean hitted = false;
            for (int i = 1; i < f7.length; ++i) {
                if (!f7[i].contains("<Strong>") || !f7[i].contains("</Strong>")) continue;
                hitted = true;
                return f7[i].replaceAll("<Strong>", "").replaceAll("</Strong>", "");
            }
            if (!hitted) {
                return null;
            }
        } else {
            return value.replace("<Strong>", "").replace("</Strong>", "");
        }
        return value;
    }

    private static String getHighlight(String value) {
        if (value.startsWith(FieldBizType.$F7$.name())) {
            String[] f7infoArray = value.split(":");
            String[] f7 = f7infoArray[1].split(";");
            for (int i = 1; i < f7.length; ++i) {
                if (!f7[i].contains("<Strong>") || !f7[i].contains("</Strong>")) continue;
                return f7[i];
            }
        }
        return value;
    }

    private static F7Info tryMakeF7Field(String fieldValue) {
        if (fieldValue.startsWith(FieldBizType.$F7$.name())) {
            if (fieldValue.contains("<Strong>") && fieldValue.contains("</Strong>")) {
                fieldValue = fieldValue.replaceAll("<Strong>", "").replaceAll("</Strong>", "");
            }
            String[] f7infoArray = fieldValue.split(":");
            String[] f7 = f7infoArray[1].split(";");
            return new F7Info(f7[0], f7[1], f7[2]);
        }
        return null;
    }
}

