/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.dom.expr;

import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlObject;
import com.kingdee.bos.sql.dom.expr.ExprType;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDoubleExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlNullExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SqlExprParser;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public abstract class SqlExpr
extends SqlObject
implements Serializable {
    private String exprWord = "";
    private volatile List subQueries = null;
    public int type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List subQueries() {
        if (this.subQueries == null) {
            SqlExpr sqlExpr = this;
            synchronized (sqlExpr) {
                if (this.subQueries == null) {
                    this.subQueries = new ArrayList();
                }
            }
        }
        return this.subQueries;
    }

    protected SqlExpr(int type) {
        this.type = type;
        switch (type) {
            case 13: {
                this.setExprWord("IN");
            }
        }
    }

    public String typename() {
        return ExprType.typename(this.type);
    }

    @Override
    public void output(StringBuffer buffer, String prefix) {
        buffer.append(prefix);
        buffer.append("SqlExpr:");
        buffer.append(this.typename());
        buffer.append("\n");
    }

    public static SqlExpr toExpr(int value) {
        return new SqlIntExpr(Integer.toString(value));
    }

    public static SqlExpr toExpr(long value) {
        throw new UnsupportedOperationException("");
    }

    public static SqlExpr toExpr(double value) {
        return new SqlIntExpr(Double.toString(value));
    }

    public static SqlExpr toExpr(Timestamp value) {
        if (value == null) {
            return SqlNullExpr.instance;
        }
        throw new UnsupportedOperationException("");
    }

    public static SqlExpr toExpr(byte[] value) {
        if (value == null) {
            return SqlNullExpr.instance;
        }
        throw new UnsupportedOperationException("");
    }

    public static SqlExpr toExpr(BigDecimal value) {
        if (value == null) {
            return SqlNullExpr.instance;
        }
        return new SqlDoubleExpr(value.toString());
    }

    public static SqlExpr toCharExpr(String value) {
        if (value == null) {
            return SqlNullExpr.instance;
        }
        return new SqlCharExpr(value);
    }

    public static SqlExpr toNCharExpr(String value) {
        if (value == null) {
            return SqlNullExpr.instance;
        }
        return new SqlNCharExpr(value);
    }

    public void output(StringBuffer buff) {
        try {
            new DrSQLFormater(buff).formatExpr(this);
        }
        catch (FormaterException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        this.output(buff);
        return buff.toString();
    }

    @Override
    public Object clone() {
        String str = this.toString();
        try {
            SqlExprParser parser = new SqlExprParser(str);
            SqlExpr new_expr = parser.expr();
            return new_expr;
        }
        catch (ParserException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getExprWord() {
        return this.exprWord;
    }

    public String getOrgValue() {
        return this.toString();
    }

    public void setExprWord(String exprWord) {
        this.exprWord = exprWord;
    }
}

