/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.pool;

import com.kingdee.bos.sql.pool.DBCPDataSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DBCPFactory {
    private static HashMap<String, DBCPDataSource> map = new HashMap();
    private static int defaultCloseTimeOut = 600000;
    private static final ArrayList closingDataSources = new ArrayList();

    public static synchronized DBCPDataSource createDBCPDataSource(String name, String driver, String url, String user, String pwd) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        DBCPDataSource dataSource = new DBCPDataSource(name);
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(url);
        dataSource.setUsername(user);
        dataSource.setPassword(pwd);
        map.put(name, dataSource);
        return dataSource;
    }

    public static List<String> getNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(map.keySet());
        return list;
    }

    public static DBCPDataSource getDBCPDataSource(String name) {
        return map.get(name);
    }

    public static void remove(String name) {
        DBCPDataSource dataSource = map.remove(name);
        DBCPFactory.addToClose(name, dataSource, defaultCloseTimeOut);
    }

    public static void reset(String name) {
        DBCPFactory.reset(name, defaultCloseTimeOut);
    }

    public static void reset(String name, int timeout) {
        DBCPDataSource dataSource = map.remove(name);
        DBCPFactory.addToClose(name, dataSource, timeout);
    }

    private static void addToClose(String name, final DBCPDataSource dataSource, final int timeout) {
        closingDataSources.add(dataSource);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < (long)timeout && dataSource.getNumActive() > 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    closingDataSources.remove((Object)dataSource);
                    dataSource.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        new Thread(r, "Closing DBCPDataSource:" + name).start();
    }

    public static List<DBCPDataSource> getClosingDataSources() {
        return closingDataSources;
    }
}

