/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell;

import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.stmt.SqlSelectStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlStmtParser;
import com.kingdee.bos.sql.parser.TokenList;
import com.kingdee.bos.sql.shell.InternalDataResultSet;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.sql.shell.trace.ConnectionInfo;
import com.kingdee.bos.sql.shell.trace.KSqlMonitor;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class InternalDataProcessor {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.sql.shell.InternalDataProcessor");
    public static final String INTERNAL_SQL_PREFIX = "/*ksql_internal*/";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultSet executeQuery(KDConnection conn, String sql) throws SQLException {
        SqlStmt stmt;
        try {
            Lexer lexer = new Lexer(sql);
            TokenList tokList = new TokenList(lexer);
            SqlStmtParser stmtParser = new SqlStmtParser(tokList);
            stmt = stmtParser.stmt();
        }
        catch (ParserException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SQLException(e.getMessage());
        }
        if (!(stmt instanceof SqlSelectStmt)) throw new SQLException("TODO");
        SqlSelectStmt selectStmt = (SqlSelectStmt)stmt;
        if (!(selectStmt.select instanceof SqlSelect)) throw new SQLException("TODO");
        SqlSelect select = (SqlSelect)selectStmt.select;
        if (!(select.tableSource instanceof SqlTableSource)) throw new SQLException("TODO");
        SqlTableSource tabSrc = (SqlTableSource)select.tableSource;
        if (!tabSrc.name.equalsIgnoreCase("KSQL_ENV")) throw new SQLException("TODO");
        String[] columnNames = new String[select.selectList.size()];
        Object[] row = new Object[select.selectList.size()];
        int[] types = new int[select.selectList.size()];
        int size = select.selectList.size();
        for (int i = 0; i < size; ++i) {
            SqlSelectItem item = (SqlSelectItem)select.selectList.get(i);
            if (!(item.expr instanceof SqlIdentifierExpr)) throw new SQLException("TODO");
            String itemName = ((SqlIdentifierExpr)item.expr).value;
            if (itemName.equalsIgnoreCase("DBTYPE")) {
                row[i] = conn.traceInfo.dbType;
                types[i] = 4;
            } else if (itemName.equalsIgnoreCase("DBTYPE_NAME")) {
                row[i] = DbType.getName(conn.traceInfo.dbType);
                types[i] = 12;
            } else if (itemName.equalsIgnoreCase("URL")) {
                row[i] = conn.traceInfo.url;
                types[i] = 12;
            } else if (itemName.equalsIgnoreCase("NATIVE_URL")) {
                row[i] = conn.traceInfo.originalUrl;
                types[i] = 12;
            } else if (itemName.equalsIgnoreCase("PASSWORD")) {
                row[i] = conn.traceInfo.password;
                types[i] = 12;
            } else if (itemName.equalsIgnoreCase("USERNAME")) {
                row[i] = conn.traceInfo.userName;
                types[i] = 12;
            } else if (itemName.equalsIgnoreCase("TEMPRECYCLETIME")) {
                row[i] = new Long(conn.traceInfo.tempRecycleTime);
                types[i] = 4;
            } else if (itemName.equalsIgnoreCase("BINDPORD")) {
                row[i] = new Integer(conn.traceInfo.bindPort);
                types[i] = 4;
            } else if (itemName.equalsIgnoreCase("ID")) {
                row[i] = conn.getId();
                types[i] = 12;
            } else {
                if (!itemName.equalsIgnoreCase("CONNECT_STACKTRACE")) throw new SQLException("TODO");
                ConnectionInfo connInfo = (ConnectionInfo)KSqlMonitor.getActivateConnectionMap().get(conn);
                if (connInfo != null) {
                    StringBuffer buff = new StringBuffer();
                    if (connInfo.stackTrace instanceof StackTraceElement[]) {
                        StackTraceElement[] elementArray = (StackTraceElement[])connInfo.stackTrace;
                        for (int j = 0; j < elementArray.length; ++j) {
                            buff.append(elementArray[j].toString());
                            buff.append("\n");
                        }
                    } else if (connInfo.stackTrace == null) {
                        buff.append("connection not close, but stackTrace is null");
                    } else {
                        buff.append(connInfo.stackTrace.toString());
                    }
                    row[i] = buff.toString();
                } else {
                    row[i] = null;
                }
                types[i] = 12;
            }
            columnNames[i] = item.alias != null && item.alias.length() != 0 ? item.alias : itemName;
        }
        return new InternalDataResultSet(columnNames, types, row);
    }
}

