/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell;

import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.privacy.PrivacyResultSet;
import com.kingdee.bos.privacy.PrivacyResultSetMetaData;
import com.kingdee.bos.sql.InspectSqlManageAdpter;
import com.kingdee.bos.sql.PraseSqlUtilAdpter;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.sql.shell.KDStatement;
import com.kingdee.bos.sql.shell.trace.ConnectionInfo;
import com.kingdee.bos.sql.shell.trace.ConnectionLogger;
import com.kingdee.bos.sql.shell.trace.KSqlMonitor;
import com.kingdee.bos.sql.shell.trace.LogItem;
import com.kingdee.bos.sql.shell.trace.TraceInfo;
import com.kingdee.util.ThreadScopeLogger;
import com.kingdee.util.Uuid;
import com.kingdee.util.WriteSQLPlanThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.CLOB;
import org.apache.log4j.Logger;

public class KDPreparedStatement
extends KDStatement
implements PreparedStatement {
    private static final Logger logger = Logger.getLogger(KDPreparedStatement.class);
    public final int MAX_STRING_LENGTH = 1000;
    private final String ksql;
    private final String dialect_sql;
    private final Object[] params;
    private final Object[] paramsAfterMap;
    private final ParamIndexer indexer;
    private final int conn_id;
    boolean createByNativeDataSource = false;
    List tempTableInfoOfLongIds = null;

    protected KDPreparedStatement(PreparedStatement stmt, KDConnection cn, String ksql, String dialect_sql, ParamData paramData) throws SQLException {
        super(stmt, cn);
        this.paramData = paramData;
        this.ksql = ksql;
        this.dialect_sql = dialect_sql;
        this.conn_id = cn.conn_id;
        int sqlParamCount = KDPreparedStatement.getSqlParamCount(this.ksql);
        int dialectSqlParamCount = KDPreparedStatement.getSqlParamCount(this.dialect_sql);
        this.indexer = !paramData.numOfParamChanged() && dialectSqlParamCount != sqlParamCount ? new MapParamIndexer(sqlParamCount, dialectSqlParamCount, this.ksql, this.dbType, cn.traceInfo()) : new SimpleParamIndexer(dialectSqlParamCount);
        Object[] ps = null;
        Object[] pam = null;
        if (ConnectionLogger.isValid()) {
            ps = new Object[sqlParamCount];
            if (dialectSqlParamCount != sqlParamCount) {
                pam = new Object[dialectSqlParamCount];
            }
        }
        this.params = ps;
        this.paramsAfterMap = pam;
    }

    private static int getSqlParamCount(String sql) {
        int sqlParamCount = 0;
        int len = sql.length();
        for (int i = 0; i < len; ++i) {
            char ch = sql.charAt(i);
            if (ch != '?') continue;
            ++sqlParamCount;
        }
        return sqlParamCount;
    }

    private void fillLogParameters(LogItem logItem) {
        int i;
        int size;
        if (this.params != null && this.params.length != 0) {
            if (logItem.parameters == null) {
                logItem.parameters = new ArrayList(this.params.length);
            }
            size = this.params.length;
            for (i = 0; i < size; ++i) {
                logItem.parameters.add(this.params[i]);
                if (this.params[i] == null) continue;
                logItem.bytes += (long)this.params[i].toString().length();
            }
        }
        if (this.paramsAfterMap != null && this.paramsAfterMap.length != 0) {
            if (logItem.parametersMapping == null) {
                logItem.parametersMapping = new ArrayList(this.paramsAfterMap.length);
            }
            size = this.paramsAfterMap.length;
            for (i = 0; i < size; ++i) {
                logItem.parametersMapping.add(this.paramsAfterMap[i]);
            }
        }
    }

    private LogItem beginLog(String method, long startTime) {
        LogItem logItem = null;
        if (ConnectionLogger.isValid() || ThreadScopeLogger.isEnable()) {
            logItem = new LogItem();
            logItem.url = this.cn.traceInfo.url;
            logItem.username = this.cn.traceInfo.userName;
            logItem.password = this.cn.traceInfo.password;
            logItem.method = method;
            logItem.executeTime = new Timestamp(startTime);
            logItem.ksql = this.ksql;
            logItem.dialect_sql = this.dialect_sql;
            logItem.dbType = this.dbType;
            logItem.conn_id = this.conn_id;
            logItem.bytes = 0L;
        }
        return logItem;
    }

    private void endLog(LogItem logItem, long startTime, int updateCount, String activateConnectionTrace) throws SQLException {
        if (InspectSqlManageAdpter.isEnable()) {
            InspectSqlManageAdpter.filter(logItem);
        }
        if (logItem == null) {
            return;
        }
        long endTime = System.currentTimeMillis();
        logItem.timespan = endTime - startTime;
        if (ThreadScopeLogger.isEnable()) {
            String logPlanId = null;
            if (ThreadScopeLogger.isCloudRecord()) {
                long sqlPlanTimeLimit;
                long l = sqlPlanTimeLimit = System.getProperty("sqlPlanTimeLimit") != null ? Long.valueOf(System.getProperty("sqlPlanTimeLimit")) : 2000L;
                if (logItem.timespan >= sqlPlanTimeLimit) {
                    logItem.sqlplan_id = logPlanId = Uuid.randomUUID().toString();
                    WriteSQLPlanThread.putLogItem(logItem);
                }
            }
            ThreadScopeLogger.loggerExecuteItem(logPlanId, logItem.method, this.ksql, startTime, endTime);
        }
        if (ConnectionLogger.isValid()) {
            if (updateCount != 0) {
                logItem.updateCount = updateCount;
            }
            this.fillLogParameters(logItem);
            this.cn.logger.write(logItem);
            if (activateConnectionTrace != null) {
                this.activateConnectionTrace(activateConnectionTrace);
            }
        }
    }

    private void logSQLException(LogItem logItem, SQLException ex, boolean isOutput) {
        if (ConnectionLogger.isValid() && logItem != null) {
            logItem.errorMessage = ex.getMessage();
        }
        if (isOutput) {
            logger.error((Object)("execute sql error: " + ex.getMessage() + "\r\nsql:" + this.dialect_sql + "\r\nksql:" + this.ksql));
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkInterrupt();
        ((PreparedStatement)this.stmt).addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.stmt).clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        boolean rtnVal;
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("KDPreparedStatement.execute", startTime);
        try {
            rtnVal = ((PreparedStatement)this.stmt).execute();
            if (this.createByNativeDataSource) {
                this.cn.getConnectionByNativeDataSource().commit();
            }
            this.appendCommit(this.dialect_sql);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, true);
            throw ex;
        }
        finally {
            if (logItem != null) {
                this.endLog(logItem, startTime, this.stmt.getUpdateCount(), this.ksql);
            }
        }
        return rtnVal;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        PrivacyResultSet kd_rs;
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("KDPreparedStatement.executeQuery", startTime);
        try {
            ResultSet rs = ((PreparedStatement)this.stmt).executeQuery();
            kd_rs = rs == null ? null : new PrivacyResultSet(rs, this);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, true);
            throw ex;
        }
        finally {
            this.endLog(logItem, startTime, 0, this.ksql);
        }
        return kd_rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkInterrupt();
        int rtnVal = -1;
        long startTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("KDPreparedStatement.executeUpdate", startTime);
        try {
            rtnVal = ((PreparedStatement)this.stmt).executeUpdate();
            if (this.createByNativeDataSource) {
                this.cn.getConnectionByNativeDataSource().commit();
            }
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, true);
            throw ex;
        }
        finally {
            this.endLog(logItem, startTime, rtnVal, this.ksql);
        }
        return rtnVal;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("KDPreparedStatement.executeBatch", startTime);
        int[] rtnVal = null;
        try {
            rtnVal = this.stmt.executeBatch();
            if (this.createByNativeDataSource) {
                this.cn.getConnectionByNativeDataSource().commit();
            }
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, false);
            throw ex;
        }
        finally {
            int updateCount = 0;
            if (logItem != null && rtnVal != null) {
                for (int i = 0; i < rtnVal.length; ++i) {
                    updateCount += rtnVal[i];
                }
            }
            this.endLog(logItem, startTime, updateCount, "execute batch.");
        }
        return rtnVal;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new PrivacyResultSetMetaData(((PreparedStatement)this.stmt).getMetaData(), this.dbType, this.paramData);
    }

    @Override
    public void setArray(int index, Array val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setArray(paras[i], val);
            }
        }
    }

    @Override
    public void setAsciiStream(int index, InputStream val, int length) throws SQLException {
        block6: {
            int[] paras = this.indexer.get(index);
            if (paras == null) break block6;
            if (this.dbType == 1 || this.dbType == 9 || this.dbType == 2 || this.dbType == 7 || this.dbType == 8) {
                byte[] bytes = new byte[length];
                try {
                    val.read(bytes);
                    val.reset();
                }
                catch (IOException e) {
                    logger.warn((Object)e);
                    throw new SQLException("can not read inputstream to bytes." + e.getMessage());
                }
                String str = new String(bytes);
                this.setLogParams(index, str);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], str);
                    ((PreparedStatement)this.stmt).setString(paras[i], str);
                }
            } else {
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setAsciiStream(paras[i], val, length);
                }
            }
        }
    }

    @Override
    public void setBigDecimal(int index, BigDecimal val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setBigDecimal(paras[i], val);
            }
        }
    }

    @Override
    public void setBinaryStream(int index, InputStream val, int p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setBinaryStream(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setBlob(int index, Blob val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setBlob(paras[i], val);
            }
        }
    }

    @Override
    public void setBoolean(int index, boolean val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val ? Boolean.TRUE : Boolean.FALSE);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val ? Boolean.TRUE : Boolean.FALSE);
                if (this.dbType == 5 || this.dbType == 12 || this.dbType == 13) {
                    ((PreparedStatement)this.stmt).setInt(paras[i], val ? 1 : 0);
                    continue;
                }
                ((PreparedStatement)this.stmt).setBoolean(paras[i], val);
            }
        }
    }

    @Override
    public void setByte(int index, byte val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, new Byte(val));
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], new Byte(val));
                ((PreparedStatement)this.stmt).setByte(paras[i], val);
            }
        }
    }

    @Override
    public void setBytes(int index, byte[] val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setBytes(paras[i], val);
            }
        }
    }

    @Override
    public void setCharacterStream(int index, Reader val, int p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setCharacterStream(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setClob(int index, Clob val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setClob(paras[i], val);
            }
        }
    }

    @Override
    public void setDate(int index, Date val) throws SQLException {
        if (this.dbType == 5) {
            this.setTimestamp(index, new Timestamp(val.getTime()));
        } else {
            int[] paras = this.indexer.get(index);
            if (paras != null) {
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setDate(paras[i], val);
                }
            }
        }
    }

    @Override
    public void setDate(int index, Date val, Calendar p3) throws SQLException {
        if (this.dbType == 5) {
            this.setTimestamp(index, new Timestamp(val.getTime()), p3);
        } else {
            int[] paras = this.indexer.get(index);
            if (paras != null) {
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setDate(paras[i], val, p3);
                }
            }
        }
    }

    @Override
    public void setDouble(int index, double val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, new Double(val));
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], new Double(val));
                ((PreparedStatement)this.stmt).setDouble(paras[i], val);
            }
        }
    }

    @Override
    public void setFloat(int index, float val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, new Float(val));
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], new Float(val));
                ((PreparedStatement)this.stmt).setFloat(paras[i], val);
            }
        }
    }

    @Override
    public void setInt(int index, int val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setInt(paras[i], val);
            }
        }
    }

    @Override
    public void setLong(int index, long val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, new Long(val));
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], new Long(val));
                ((PreparedStatement)this.stmt).setLong(paras[i], val);
            }
        }
    }

    @Override
    public void setNull(int index, int sqlType) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, null);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], null);
                ((PreparedStatement)this.stmt).setNull(paras[i], sqlType);
            }
        }
    }

    @Override
    public void setNull(int index, int p2, String p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, null);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], null);
                ((PreparedStatement)this.stmt).setNull(paras[i], p2, p3);
            }
        }
    }

    @Override
    public void setObject(int index, Object val) throws SQLException {
        block11: {
            int[] paras = this.indexer.get(index);
            if (paras == null) break block11;
            if (this.dbType == 5 || this.dbType == 12 || this.dbType == 13) {
                if (val instanceof Boolean) {
                    val = ((Boolean)val).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0);
                } else if (this.dbType == 5 && val instanceof Date) {
                    val = new Timestamp(((Date)val).getTime());
                }
                if (val instanceof String) {
                    String str = (String)val;
                    if (str.length() == 44 && str.charAt(43) == ' ') {
                        str = str.trim();
                        this.setString(index, str);
                    } else {
                        this.setObject(index, (Object)str, 1111);
                    }
                } else {
                    this.setLogParams(index, val);
                    for (int i = 0; i < paras.length; ++i) {
                        this.setLogParamsMap(paras[i], val);
                        ((PreparedStatement)this.stmt).setObject(paras[i], val);
                    }
                }
            } else {
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setObject(paras[i], val);
                }
            }
        }
    }

    @Override
    public void setObject(int index, Object val, int p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            if (this.dbType == 5 && val instanceof Date) {
                val = new Timestamp(((Date)val).getTime());
            }
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setObject(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setObject(int index, Object val, int p3, int p4) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            if (this.dbType == 5 && val instanceof Date) {
                val = new Timestamp(((Date)val).getTime());
            }
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setObject(paras[i], val, p3, p4);
            }
        }
    }

    @Override
    public void setRef(int index, Ref val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setRef(paras[i], val);
            }
        }
    }

    @Override
    public void setShort(int index, short val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, new Short(val));
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], new Short(val));
                ((PreparedStatement)this.stmt).setShort(paras[i], val);
            }
        }
    }

    @Override
    public void setString(int index, String val) throws SQLException {
        block4: {
            int[] paras = this.indexer.get(index);
            if (paras == null) break block4;
            if ((this.dbType == 2 || this.dbType == 7) && val != null && val.length() > 1000) {
                OraclePreparedStatement oracleStmt = (OraclePreparedStatement)this.stmt;
                CLOB clob = CLOB.createTemporary((Connection)this.cn.getNativeConnection(), (boolean)true, (int)1);
                oracleStmt.setFormOfUse(index, (short)2);
                clob.setString(1L, val);
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setClob(paras[i], (Clob)clob);
                }
            } else {
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setString(paras[i], val);
                }
            }
        }
    }

    private void setLogParams(int index, Object val) {
        if (this.params != null && this.params.length >= index) {
            this.params[index - 1] = val;
        }
    }

    private void setLogParamsMap(int index, Object val) {
        if (this.paramsAfterMap != null && this.paramsAfterMap.length >= index) {
            this.paramsAfterMap[index - 1] = val;
        }
    }

    @Override
    public void setTime(int index, Time val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setTime(paras[i], val);
            }
        }
    }

    @Override
    public void setTime(int index, Time val, Calendar p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setTime(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setTimestamp(int index, Timestamp val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setTimestamp(paras[i], val);
            }
        }
    }

    @Override
    public void setTimestamp(int index, Timestamp val, Calendar p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setTimestamp(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setUnicodeStream(int index, InputStream val, int p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setUnicodeStream(paras[i], val, p3);
            }
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.stmt).getParameterMetaData();
    }

    @Override
    public void setURL(int index, URL val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                PreparedStatement preStmt = (PreparedStatement)this.stmt;
                preStmt.setURL(paras[i], val);
            }
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        ConnectionInfo connInfo;
        Map activateConnInfoMap;
        if (this.tempTableInfoOfLongIds != null && !this.tempTableInfoOfLongIds.isEmpty()) {
            PraseSqlUtilAdpter.releaseTempTable(this.tempTableInfoOfLongIds);
        }
        this.stmt.close();
        if (this.createByNativeDataSource) {
            this.cn.decNativeStatementRef();
            this.cn.closeConnectionByNativeDataSource();
        }
        if (ConnectionLogger.isValid() && (activateConnInfoMap = KSqlMonitor.getActivateConnectionMap()) != null && (connInfo = (ConnectionInfo)activateConnInfoMap.get(this.getConnection())) != null && connInfo.lastStmtInfo != null) {
            connInfo.lastStmtInfo.closedTime = System.currentTimeMillis();
        }
    }

    public void setTempTableInfoOfLongIds(List ls) {
        this.tempTableInfoOfLongIds = ls;
    }

    public void setClob(int index, CLOB val, boolean matchIndex) throws SQLException {
        if (matchIndex) {
            this.setLogParamsMap(index, val);
            ((PreparedStatement)this.stmt).setClob(index, (Clob)val);
        }
    }

    private static class MapParamIndexer
    implements ParamIndexer {
        private final int[][] array;
        private final int totalCount;

        MapParamIndexer(int count, int totalCount, String ksql, int dbType, TraceInfo traceInfo) throws SQLException {
            this.array = new int[count][];
            this.totalCount = totalCount;
            ArrayList params = new ArrayList(count);
            try {
                ArrayList<String> questionMark = new ArrayList<String>(count);
                char ch = '\u0001';
                String tempSql = ksql;
                String character = null;
                while (tempSql.indexOf("?") > -1) {
                    while (ch == '$' || ch == '\'' || ch == '\\' || tempSql.indexOf(String.valueOf(ch)) != -1) {
                        ch = (char)(ch + 1);
                    }
                    character = "'" + ch + "'";
                    tempSql = tempSql.replaceFirst("[?]", character);
                    questionMark.add(character);
                    params.add(new ArrayList(4));
                    ch = (char)(ch + '\u0001');
                }
                String tempDiaSql = TransUtil.translate(tempSql, dbType, traceInfo, null);
                int len = tempDiaSql.length();
                boolean questionMarkFlag = false;
                String questionMarkCheckStr = "";
                int m = 1;
                for (int i = 0; i < len; ++i) {
                    ch = tempDiaSql.charAt(i);
                    if (questionMarkFlag) {
                        questionMarkCheckStr = questionMarkCheckStr + ch;
                        if (ch != 39) continue;
                        questionMarkFlag = false;
                        int questionMarkIndex = questionMark.indexOf(questionMarkCheckStr);
                        if (questionMarkIndex != -1) {
                            ((List)params.get(questionMarkIndex)).add(m);
                            ++m;
                        }
                        questionMarkCheckStr = "";
                        continue;
                    }
                    if (ch != 39) continue;
                    questionMarkFlag = true;
                    questionMarkCheckStr = "'";
                }
                questionMark = null;
            }
            catch (SqlTranslateException ex) {
                throw new SQLException(ex.getMessage());
            }
            for (int i = 0; i < count; ++i) {
                List lst = (List)params.get(i);
                int size = lst.size();
                int[] item = new int[size];
                for (int j = 0; j < size; ++j) {
                    item[j] = (Integer)lst.get(j);
                }
                this.array[i] = item;
            }
        }

        @Override
        public int[] get(int index) {
            if (index >= 1 && index <= this.array.length) {
                return this.array[index - 1];
            }
            if (index > this.array.length && index <= this.totalCount) {
                return null;
            }
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.totalCount);
        }
    }

    private static class SimpleParamIndexer
    implements ParamIndexer {
        private final int[][] array;

        SimpleParamIndexer(int count) {
            this.array = new int[count][1];
            for (int i = 0; i < count; ++i) {
                this.array[i][0] = i + 1;
            }
        }

        @Override
        public int[] get(int index) {
            if (index >= 1 && index <= this.array.length) {
                return this.array[index - 1];
            }
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.array.length);
        }
    }

    private static interface ParamIndexer {
        public int[] get(int var1);
    }
}

