/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell;

import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.shell.NologgingThreadState;
import com.kingdee.bos.sql.shell.nologging.NoLoggingConfig;
import java.sql.Connection;
import java.sql.SQLException;

public class VTUtil {
    public static String decorate(String sql, int dbType) {
        if (!DbType.isOracle(dbType)) {
            return sql;
        }
        if (sql.contains("INSERT INTO VT")) {
            if (VTUtil.appendEnabled()) {
                return sql.replaceFirst("INSERT INTO VT", "INSERT /*+ APPEND */ INTO VT");
            }
            return sql;
        }
        if (sql.contains("CREATE TABLE VT")) {
            if (!sql.toUpperCase().contains("NOLOGGING")) {
                int pos = sql.indexOf(" AS ");
                if (pos > 0) {
                    String left = sql.substring(0, pos);
                    String right = sql.substring(pos);
                    sql = left + " NOLOGGING" + right;
                } else {
                    sql = sql + " NOLOGGING";
                }
                return sql;
            }
        } else if (sql.contains("CREATE INDEX") && sql.contains("ON VT")) {
            if (!sql.toUpperCase().contains("NOLOGGING")) {
                return sql + " NOLOGGING";
            }
        } else if (sql.startsWith("DROP TABLE VT")) {
            if (KSqlUtil.isSupportPurge() && !sql.toUpperCase().contains("PURGE")) {
                return sql + " PURGE";
            }
            if (!KSqlUtil.isSupportPurge() && sql.toUpperCase().contains("PURGE")) {
                return sql.substring(0, sql.toUpperCase().indexOf("PURGE") - 1);
            }
        }
        return sql;
    }

    public static boolean needNewTransaction(Connection cn, int dbType, String sql) throws SQLException {
        return false;
    }

    public static boolean needCommit(Connection cn, int dbType, String sql) throws SQLException {
        if (VTUtil.appendEnabled() && DbType.isOracle(dbType)) {
            String s = sql.toUpperCase();
            return s.contains("/*+ APPEND */ INTO VT") && s.contains(" SELECT ");
        }
        return false;
    }

    public static void appendCommit(Connection cn, int dbType, String sql) throws SQLException {
        if (VTUtil.needCommit(cn, dbType, sql)) {
            cn.commit();
        }
    }

    public static boolean appendEnabled() {
        return NoLoggingConfig.enableNoLoggingAppend() && NologgingThreadState.isEnable();
    }
}

