/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.LoggerItem;
import com.kingdee.util.ThreadScopeRecord;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThreadScopeLogger {
    private static boolean ENABLE_ORMAPPING = true;
    private static boolean ENABLE_EXECUTE = true;
    private static boolean ENABLE_ADDBATCH = true;
    private static boolean ENABLE_COMMENT = true;
    private static boolean ENABLE_RESULTNEXT = true;
    private static ThreadLocal threadLocal = new ThreadLocal();
    public static boolean enable = false;
    public static AtomicBoolean cloudRecordSwitch = new AtomicBoolean(false);

    public static boolean isCloudRecord() {
        return cloudRecordSwitch.get();
    }

    public static boolean isEnable() {
        return enable;
    }

    public static void loggerExecuteItem(String method, String ksql, long startTime, long endTime) {
        ThreadScopeLogger.getExecuteItem(method, ksql, startTime, endTime);
    }

    public static void loggerExecuteItem(String sqlPlanId, String method, String ksql, long startTime, long endTime) {
        LoggerItem.ExecuteItem item = ThreadScopeLogger.getExecuteItem(method, ksql, startTime, endTime);
        if (item == null) {
            return;
        }
        item.sqlPlanId = sqlPlanId;
    }

    private static LoggerItem.ExecuteItem getExecuteItem(String method, String ksql, long startTime, long endTime) {
        if (!ENABLE_EXECUTE) {
            return null;
        }
        ThreadScopeRecord tsr = ThreadScopeLogger.getRecord();
        if (tsr == null) {
            return null;
        }
        LoggerItem.ExecuteItem item = (LoggerItem.ExecuteItem)tsr.newExecuteItem();
        item.method = method;
        item.ksql = ksql;
        item.startTime = startTime;
        item.endTime = endTime;
        return item;
    }

    public static void loggerOrmappingItem(String method, String type, long startTime, long endTime) {
        if (!ENABLE_ORMAPPING) {
            return;
        }
        ThreadScopeRecord tsr = ThreadScopeLogger.getRecord();
        if (tsr == null) {
            return;
        }
        LoggerItem.OrmappingItem item = (LoggerItem.OrmappingItem)tsr.newOrmappingItem();
        item.method = method;
        item.type = type;
        item.startTime = startTime;
        item.endTime = endTime;
    }

    public static void loggerCommentItem(String method, String comment, long startTime, long endTime) {
        if (!ENABLE_COMMENT) {
            return;
        }
        ThreadScopeRecord tsr = ThreadScopeLogger.getRecord();
        if (tsr == null) {
            return;
        }
        LoggerItem.CommentItem item = (LoggerItem.CommentItem)tsr.newCommentItem();
        item.method = method;
        item.comment = comment;
        item.startTime = startTime;
        item.endTime = endTime;
    }

    public static void loggerAddBatchItem(String method, String ksql, long startTime, long endTime) {
        if (!ENABLE_ADDBATCH) {
            return;
        }
        ThreadScopeRecord tsr = ThreadScopeLogger.getRecord();
        if (tsr == null) {
            return;
        }
        LoggerItem.AddBatchItem item = (LoggerItem.AddBatchItem)tsr.newAddBatchItem();
        item.method = method;
        item.ksql = ksql;
        item.startTime = startTime;
        item.endTime = endTime;
    }

    public static void loggerResultNextItem(String method, long startTime, long endTime) {
        if (!ENABLE_RESULTNEXT) {
            return;
        }
        ThreadScopeRecord tsr = ThreadScopeLogger.getRecord();
        if (tsr == null) {
            return;
        }
        LoggerItem.ResultNextItem item = (LoggerItem.ResultNextItem)tsr.newResultNextItem();
        item.method = method;
        item.startTime = startTime;
        item.endTime = endTime;
    }

    public static ThreadScopeRecord getRecord() {
        ThreadScopeRecord tsr = (ThreadScopeRecord)threadLocal.get();
        return tsr;
    }

    public static void openRecord(String desc, boolean isCloudRecording) {
        if (!enable) {
            enable = true;
        }
        if (isCloudRecording && !cloudRecordSwitch.get()) {
            cloudRecordSwitch.set(true);
        }
        ThreadScopeRecord tsr = new ThreadScopeRecord(desc);
        threadLocal.set(tsr);
    }

    public static ThreadScopeRecord endRecord() {
        if (ThreadScopeLogger.isCloudRecord()) {
            cloudRecordSwitch.set(false);
        }
        if (!ThreadScopeLogger.isEnable()) {
            return null;
        }
        ThreadScopeRecord tsr = (ThreadScopeRecord)threadLocal.get();
        if (tsr == null) {
            return null;
        }
        tsr.end();
        threadLocal.remove();
        return tsr;
    }
}

