/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.management.util.CompositeDataBuilder;
import com.kingdee.bos.management.util.MBeanDataException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

class SessionInfoCompositeDataBuilder
extends CompositeDataBuilder {
    private static String SESSIONID = "SessionID";
    private static String CONTEXTID = "ContextID";
    private static String USERID = "UserID";
    private static String SOLUTION = "Solution";
    private static String AIS = "AIS";
    private static String LOCALE = "Locale";
    private static String CLIENTHOSTIP = "ClientHostIP";
    private static String CLIENTHOSTNAME = "ClientHostName";
    private static String USERNAME = "UserName";

    public SessionInfoCompositeDataBuilder(String sessionId, SessionInfo session) {
        this(sessionId, session, true);
    }

    public SessionInfoCompositeDataBuilder(String sessionId, SessionInfo session, boolean fixedFieldonly) {
        this();
        Context ctx = session.getContext();
        this.addValue(SESSIONID, SESSIONID, sessionId);
        this.addValue(CONTEXTID, CONTEXTID, ctx.getContextID());
        this.addValue(USERID, USERID, ctx.getCaller().toString());
        this.addValue(SOLUTION, SOLUTION, ctx.getSolution());
        this.addValue(AIS, AIS, ctx.getAIS());
        this.addValue(LOCALE, LOCALE, ctx.getLocale().toString());
        this.addValue(CLIENTHOSTIP, CLIENTHOSTIP, ctx.getClientHostIP());
        this.addValue(CLIENTHOSTNAME, CLIENTHOSTNAME, ctx.getClientHostName());
        this.addValue(USERNAME, USERNAME, ctx.getUserName());
        if (!fixedFieldonly) {
            this.addValue(session.session);
            String[] ctxFields = ctx.getUserDefineFields();
            if (ctxFields != null && ctxFields.length > 0) {
                for (int i = 0; i < ctxFields.length; ++i) {
                    this.addValue(ctxFields[i], ctx.get((Object)ctxFields[i]));
                }
            }
        }
    }

    private SessionInfoCompositeDataBuilder() {
        super("SessionInfoCompisteData", "SessionInfo CompisteData");
    }

    public static TabularData getTabularData() {
        try {
            TabularType type = new TabularType("SessionInfoTabularData", "SessionInfo TabularData", SessionInfoCompositeDataBuilder.getFixedCompositeType(), new String[]{"SessionID"});
            return new TabularDataSupport(type);
        }
        catch (OpenDataException ode) {
            throw new MBeanDataException(ode.getMessage());
        }
    }

    private static CompositeType getFixedCompositeType() {
        SessionInfoCompositeDataBuilder builder = new SessionInfoCompositeDataBuilder();
        builder.addValue(SESSIONID, SESSIONID, SimpleType.STRING, null);
        builder.addValue(CONTEXTID, CONTEXTID, SimpleType.STRING, null);
        builder.addValue(USERID, USERID, SimpleType.STRING, null);
        builder.addValue(SOLUTION, SOLUTION, SimpleType.STRING, null);
        builder.addValue(AIS, AIS, SimpleType.STRING, null);
        builder.addValue(LOCALE, LOCALE, SimpleType.STRING, null);
        builder.addValue(CLIENTHOSTIP, CLIENTHOSTIP, SimpleType.STRING, null);
        builder.addValue(CLIENTHOSTNAME, CLIENTHOSTNAME, SimpleType.STRING, null);
        builder.addValue(USERNAME, USERNAME, SimpleType.STRING, null);
        return builder.getCompositeType();
    }
}

