/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session;

import com.kingdee.bos.framework.session.OpenDataHelper;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManageMBean;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.management.NotifySupportBuddyMBean;
import com.kingdee.util.StringUtils;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class SessionManage
extends NotifySupportBuddyMBean
implements SessionManageMBean {
    public SessionManage(SessionManager source) {
        super(source);
    }

    @Override
    public String getInstanceName() {
        return null;
    }

    @Override
    public int getApplicationCount() {
        return SessionManager.applications.size();
    }

    @Override
    public CompositeData getApplication(String ais) {
        if (!StringUtils.isEmpty((String)ais) && SessionManager.applications.containsKey(ais)) {
            return OpenDataHelper.toCompositeData(ais, this.sessionManager().getApplication(ais));
        }
        return null;
    }

    @Override
    public String[] getApplicationNames() {
        return SessionManager.applications.keySet().toArray(new String[0]);
    }

    @Override
    public String[] getSessionIds() {
        return SessionManager.sessions.keySet().toArray(new String[0]);
    }

    @Override
    public CompositeData getSession(String sessionId) {
        if (!StringUtils.isEmpty((String)sessionId) && SessionManager.sessions.containsKey(sessionId)) {
            return OpenDataHelper.toCompositeData(sessionId, this.sessionManager().getSession(sessionId), false);
        }
        return null;
    }

    @Override
    public int getSessionCount() {
        return SessionManager.sessions.size();
    }

    @Override
    public TabularData getSessions() {
        return OpenDataHelper.toSessionTabularData(SessionManager.sessions);
    }

    @Override
    public TabularData getSessionsByAis(String ais) {
        return OpenDataHelper.toSessionTabularData(SessionManager.sessions, new AisSessionFilter(ais));
    }

    private final SessionManager sessionManager() {
        return (SessionManager)this.getSource();
    }

    private class AisSessionFilter
    implements OpenDataHelper.ISessionFilter {
        private final String ais;

        public AisSessionFilter(String ais) {
            assert (!StringUtils.isEmpty((String)ais));
            this.ais = ais;
        }

        @Override
        public boolean match(SessionInfo session) {
            return this.ais.equals(session.getContext().getAIS());
        }
    }
}

