/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import com.kingdee.bos.framework.ejb.DBConnMonitor;
import com.kingdee.bos.framework.ejb.EJBUtils;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DBConnCounter
extends InvokeMonitor
implements DBConnMonitor {
    public static final Logger logger = Logger.getLogger((String)DBConnCounter.class.getName());
    private static DBConnCounter monitor = new DBConnCounter();
    private static boolean isValid = false;
    private static ThreadLocal logVec = new ThreadLocal();
    static HashSet excludeSet = new HashSet();
    static int filter_leak_threshold = 1;
    static int filter_max_threshold = 10;
    static int filter_cumulate_threshold = 1000;

    protected DBConnCounter(boolean client, boolean server) {
        super(client, server);
    }

    public DBConnCounter() {
        super(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        String onoff;
        String deploy = System.getProperty("eas.deploy");
        String perfLog = deploy + "/PerfLog_Server.properties";
        Properties prop = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(perfLog);
            prop.load(is);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        String exclude = prop.getProperty("dbconnection_exclude");
        if (exclude != null) {
            StringTokenizer token = new StringTokenizer(exclude, ";");
            while (token.hasMoreTokens()) {
                excludeSet.add(token.nextToken());
            }
        }
        if ((onoff = prop.getProperty("dbconnection")) != null && onoff.equalsIgnoreCase("on")) {
            isValid = true;
            monitor.recordInvokeStart(true);
            RPCEngineFactory.addInvokeMonitor((InvokeMonitor)monitor);
            EJBUtils.addConnMonitor((DBConnMonitor)monitor);
        } else {
            isValid = false;
        }
        String threshold = prop.getProperty("dbconn_filter_leak_threshold");
        if (threshold != null) {
            filter_leak_threshold = Integer.parseInt(threshold);
        }
        if ((threshold = prop.getProperty("dbconn_filter_max_threshold")) != null) {
            filter_max_threshold = Integer.parseInt(threshold);
        }
        if ((threshold = prop.getProperty("dbconn_filter_cumulate_threshold")) != null) {
            filter_cumulate_threshold = Integer.parseInt(threshold);
        }
    }

    public static boolean isValid() {
        return isValid;
    }

    public static synchronized void setValid(boolean valid) {
        if (valid) {
            monitor.recordInvokeStart(true);
            RPCEngineFactory.addInvokeMonitor((InvokeMonitor)monitor);
            EJBUtils.addConnMonitor((DBConnMonitor)monitor);
        } else {
            EJBUtils.removeConnMonitor((DBConnMonitor)monitor);
        }
        isValid = valid;
    }

    private static void startInvokeCount(String method) {
        if (!isValid) {
            return;
        }
        logVec.set(new Vector());
    }

    private static void endInvokeCount(String method, long invokeTime, int invokeID) {
        if (!isValid) {
            return;
        }
        Vector tmpVec = (Vector)logVec.get();
        logVec.set(null);
        if (tmpVec != null) {
            DBConnCounter.printConnLog(method, tmpVec, invokeTime, invokeID);
        }
    }

    private static synchronized void printConnLog(String method, Vector logVec, long invokeTime, int invokeID) {
        String log;
        int i;
        if (!isValid) {
            return;
        }
        if (logVec.size() == 0) {
            return;
        }
        int cumulate = 0;
        int max = 0;
        int leak = 0;
        HashSet<String> hashCodeSet = new HashSet<String>();
        for (i = 0; i < logVec.size(); ++i) {
            String hashCode;
            StringTokenizer token;
            log = (String)logVec.get(i);
            if (log.startsWith("getConn")) {
                ++cumulate;
                token = new StringTokenizer(log);
                token.nextToken();
                hashCode = token.nextToken();
                hashCodeSet.add(hashCode);
                int size = hashCodeSet.size();
                if (size <= max) continue;
                max = size;
                continue;
            }
            token = new StringTokenizer(log);
            token.nextToken();
            hashCode = token.nextToken();
            hashCodeSet.remove(hashCode);
        }
        leak = hashCodeSet.size();
        if (cumulate < filter_cumulate_threshold && max < filter_max_threshold && leak < filter_leak_threshold) {
            logVec.clear();
            return;
        }
        logger.debug((Object)"");
        logger.debug((Object)method);
        logger.debug((Object)("current thread: " + Thread.currentThread().getName() + "  invoke_id: " + invokeID));
        logger.debug((Object)"==============start conn log==============");
        for (i = 0; i < logVec.size(); ++i) {
            log = (String)logVec.get(i);
            logger.debug((Object)log);
        }
        logger.debug((Object)"==============end conn log==============");
        logger.debug((Object)("invoke time: " + invokeTime));
        logger.debug((Object)("cumulate: " + cumulate + " max: " + max + " leak: " + leak));
        logger.debug((Object)"");
        logVec.clear();
    }

    public static void countConnLog(String connLog) {
        if (!isValid) {
            return;
        }
        Vector tmpVec = (Vector)logVec.get();
        if (tmpVec != null) {
            tmpVec.add(connLog);
        }
    }

    public void invokePerformed(InvokeRecord rec) {
        if (!isValid) {
            return;
        }
        if ((rec.command == 0 || rec.command == 20) && rec.detail != null && rec.detail instanceof InvokeRecord.MethodInvoke) {
            String remoteInterface = ((InvokeRecord.MethodInvoke)rec.detail).method.getDeclaringClass().getName();
            Method method = ((InvokeRecord.MethodInvoke)rec.detail).method;
            StringBuffer sb = new StringBuffer();
            sb.append(remoteInterface);
            sb.append(".");
            sb.append(method.getName());
            if (excludeSet.contains(sb.toString())) {
                return;
            }
            sb.append("(");
            Class<?>[] params = method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                sb.append(params[i].getName());
                if (i >= params.length - 1) continue;
                sb.append(", ");
            }
            sb.append(") ");
            sb.append(method.getReturnType().getName());
            long invokeTime = rec.getTime();
            int invokeID = ((InvokeRecord.MethodInvoke)rec.detail).invokeId;
            DBConnCounter.endInvokeCount(sb.toString(), invokeTime, invokeID);
        }
    }

    public void invokeStart(String methodStr, InvokeRecord rec) {
        if (!isValid) {
            return;
        }
        if ((rec.command == 0 || rec.command == 20) && rec.detail != null && rec.detail instanceof InvokeRecord.MethodInvoke) {
            DBConnCounter.startInvokeCount(methodStr);
        }
    }

    public void passConnectionInfo(int connId, long startTime, long endTime, String type) {
        DBConnCounter.countConnLog(type + " " + connId + " " + (endTime - startTime));
    }
}

