/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import com.kingdee.bos.invokecounter.HttpCounterUtils;
import com.kingdee.bos.invokecounter.HttpRpcCounter;
import com.kingdee.bos.invokecounter.HttpSqlCounter;
import com.kingdee.bos.invokecounter.PerfEventCounter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class HttpSqlFilter
implements Filter {
    private FilterConfig config;

    public void destroy() {
        this.config = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            String uri = ((HttpServletRequest)request).getRequestURL().toString();
            String queryString = ((HttpServletRequest)request).getQueryString();
            if (HttpCounterUtils.isMonitorOn((HttpServletRequest)request)) {
                HttpCounterUtils.pushHandlerNo();
            }
            HttpSqlCounter.startInvoke(request, response, uri, queryString);
            HttpRpcCounter.startHttp(uri, queryString);
            PerfEventCounter.startHttp(request, response);
            chain.doFilter(request, response);
        }
        finally {
            HttpSqlCounter.endInvoke(request, response);
            PerfEventCounter.endHttp(request, response);
            HttpRpcCounter.endHttp();
            if (HttpCounterUtils.isMonitorOn((HttpServletRequest)request)) {
                HttpCounterUtils.popHandlerNo();
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
    }
}

