/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import com.kingdee.bos.framework.ejb.DBConnMonitor;
import com.kingdee.bos.framework.ejb.EJBUtils;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.kingdee.bos.rpcwrapper.IServerSession;
import com.kingdee.bos.rpcwrapper.IServerSessionListener;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.rpcwrapper.ServerSessionContainer;
import com.kingdee.bos.sql.shell.IInterruptListener;
import com.kingdee.bos.sql.shell.KDPreparedStatement;
import com.kingdee.bos.sql.shell.KDResultSet;
import com.kingdee.bos.sql.shell.KDStatement;
import com.kingdee.bos.sql.shell.trace.ConnectionLogger;
import com.kingdee.bos.sql.shell.trace.LogItem;
import com.kingdee.bos.sql.shell.trace.LoggerDest;
import com.kingdee.bos.sql.shell.trace.NextDest;
import com.kingdee.bos.workflow.enactment.app.ApplicationMonitor;
import com.kingdee.bos.workflow.enactment.app.DefaultApplicationManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PerfEventCounter
extends InvokeMonitor
implements LoggerDest,
NextDest,
DBConnMonitor,
ApplicationMonitor,
IServerSessionListener,
IInterruptListener {
    private static Logger logger = Logger.getLogger(PerfEventCounter.class);
    private static Map perfMap = new Hashtable();
    private static Map idMap = new Hashtable();
    private static PerfEventCounter monitor = new PerfEventCounter();
    private static boolean isValid = false;
    private static Object threadMX = null;
    private static Method getCurrentThreadCpuTimeMethod = null;
    private static Method getThreadCpuTimeMethod = null;
    private static Method getThreadInfoMethod = null;
    private static Method getStackTraceMethod = null;
    private static Method getIdMethod = null;
    private static List gcMXList = null;
    private static Method gcCountMethod = null;
    private static Method gcTimeMethod = null;
    private static Map tagMap = new HashMap();
    private static Map threadSetMap = new HashMap();

    protected PerfEventCounter(boolean client, boolean server) {
        super(client, server);
    }

    public PerfEventCounter() {
        super(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        String version = System.getProperty("java.version");
        String subStr = version.substring(0, 3);
        double versionD = Double.parseDouble(subStr);
        if (versionD >= 1.5) {
            try {
                Class<?> mapClass = Class.forName("java.util.concurrent.ConcurrentHashMap");
                perfMap = (Map)mapClass.newInstance();
                idMap = (Map)mapClass.newInstance();
                Class<?> facClass = Class.forName("java.lang.management.ManagementFactory");
                Method getThreadMethod = facClass.getMethod("getThreadMXBean", null);
                Method getGCMethod = facClass.getMethod("getGarbageCollectorMXBeans", null);
                threadMX = getThreadMethod.invoke(facClass, null);
                Class<?> threadMXClass = Class.forName("java.lang.management.ThreadMXBean");
                Method isSupportedMethod = threadMXClass.getMethod("isThreadCpuTimeSupported", null);
                Method isEnabledMethod = threadMXClass.getMethod("isThreadCpuTimeEnabled", null);
                Boolean isSupported = (Boolean)isSupportedMethod.invoke(threadMX, null);
                Boolean isEnabled = (Boolean)isEnabledMethod.invoke(threadMX, null);
                if (isSupported.booleanValue() && isEnabled.booleanValue()) {
                    getCurrentThreadCpuTimeMethod = threadMXClass.getMethod("getCurrentThreadCpuTime", null);
                    getThreadCpuTimeMethod = threadMXClass.getMethod("getThreadCpuTime", Long.TYPE);
                }
                getThreadInfoMethod = threadMXClass.getMethod("getThreadInfo", Long.TYPE, Integer.TYPE);
                Class<?> threadInfoClass = Class.forName("java.lang.management.ThreadInfo");
                getStackTraceMethod = threadInfoClass.getMethod("getStackTrace", null);
                Class<?> threadClass = Class.forName("java.lang.Thread");
                getIdMethod = threadClass.getMethod("getId", null);
                gcMXList = (List)getGCMethod.invoke(facClass, null);
                Class<?> gcMXClass = Class.forName("java.lang.management.GarbageCollectorMXBean");
                gcCountMethod = gcMXClass.getMethod("getCollectionCount", null);
                gcTimeMethod = gcMXClass.getMethod("getCollectionTime", null);
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        } else {
            perfMap = new Hashtable();
            idMap = new Hashtable();
        }
        String deploy = System.getProperty("eas.deploy");
        String perfLog = deploy + "/PerfLog_Server.properties";
        Properties prop = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(perfLog);
            prop.load(is);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        String onoff = prop.getProperty("perfevent");
        if (onoff != null && onoff.equalsIgnoreCase("on")) {
            isValid = true;
            monitor.recordInvokeStart(true);
            RPCEngineFactory.addInvokeMonitor((InvokeMonitor)monitor);
            DefaultApplicationManager.addApplicationMonitor((ApplicationMonitor)monitor);
            ConnectionLogger.addLoggerDest((LoggerDest)monitor);
            KDResultSet.addNextDest((NextDest)monitor);
            EJBUtils.addConnMonitor((DBConnMonitor)monitor);
            SessionManager.addServerSessionListener((IServerSessionListener)monitor);
            KDStatement.addInterruptListener((IInterruptListener)monitor);
            KDPreparedStatement.addInterruptListener((IInterruptListener)monitor);
        } else {
            isValid = false;
        }
    }

    public static boolean isValid() {
        return isValid;
    }

    public static synchronized void setValid(boolean valid) {
        if (valid) {
            monitor.recordInvokeStart(true);
            RPCEngineFactory.addInvokeMonitor((InvokeMonitor)monitor);
            DefaultApplicationManager.addApplicationMonitor((ApplicationMonitor)monitor);
            ConnectionLogger.addLoggerDest((LoggerDest)monitor);
            KDResultSet.addNextDest((NextDest)monitor);
            EJBUtils.addConnMonitor((DBConnMonitor)monitor);
            SessionManager.addServerSessionListener((IServerSessionListener)monitor);
            KDStatement.addInterruptListener((IInterruptListener)monitor);
            KDPreparedStatement.addInterruptListener((IInterruptListener)monitor);
        } else {
            DefaultApplicationManager.removeApplicationMonitor((ApplicationMonitor)monitor);
            ConnectionLogger.removeLoggerDest((LoggerDest)monitor);
            KDResultSet.removeNextDest((NextDest)monitor);
            EJBUtils.removeConnMonitor((DBConnMonitor)monitor);
            SessionManager.removeServerSessionListener((IServerSessionListener)monitor);
            KDStatement.removeInterruptListener((IInterruptListener)monitor);
            KDPreparedStatement.removeInterruptListener((IInterruptListener)monitor);
        }
        isValid = valid;
        perfMap.clear();
        idMap.clear();
        tagMap.clear();
        threadSetMap.clear();
    }

    public static synchronized List getRPCPerfMap() {
        if (!isValid) {
            return null;
        }
        int priority = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        ArrayList<Object> list = new ArrayList<Object>();
        long now = System.currentTimeMillis();
        Object[] nameVec = perfMap.keySet().toArray();
        for (int j = 0; j < nameVec.length; ++j) {
            String threadName = (String)nameVec[j];
            PerfEvent event = (PerfEvent)perfMap.get(threadName);
            Long threadId = (Long)idMap.get(threadName);
            if (event == null) continue;
            long[] perfData = new long[10];
            list.add(threadName);
            list.add(event.name);
            list.add(perfData);
            perfData[0] = now - event.startTime;
            perfData[1] = event.sqlTime + event.nextTime;
            perfData[2] = event.sqlTime;
            perfData[3] = event.sqlExeNumber;
            perfData[4] = event.nextTime;
            perfData[5] = event.nextNumber;
            perfData[6] = -1L;
            if (threadMX != null && getThreadCpuTimeMethod != null && threadId != null) {
                try {
                    long cpuTime = (Long)getThreadCpuTimeMethod.invoke(threadMX, threadId);
                    perfData[6] = (cpuTime - event.cpuTime) / 1000000L;
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
            perfData[7] = -1L;
            perfData[8] = -1L;
            long gcCount = 0L;
            long gcTime = 0L;
            if (gcMXList != null) {
                try {
                    int size = gcMXList.size();
                    for (int i = 0; i < size; ++i) {
                        Object gcMX = gcMXList.get(i);
                        gcCount += ((Long)gcCountMethod.invoke(gcMX, null)).longValue();
                        gcTime += ((Long)gcTimeMethod.invoke(gcMX, null)).longValue();
                    }
                    perfData[7] = gcCount - event.gcCount;
                    perfData[8] = gcTime - event.gcTime;
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
            perfData[9] = event.connIdSet.size();
            if (threadMX != null && getThreadInfoMethod != null && threadId != null && getStackTraceMethod != null) {
                try {
                    Object threadInfo = getThreadInfoMethod.invoke(threadMX, threadId, 100);
                    StackTraceElement[] stackVec = (StackTraceElement[])getStackTraceMethod.invoke(threadInfo, null);
                    list.add(stackVec);
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
                continue;
            }
            list.add(new StackTraceElement[0]);
        }
        Thread.currentThread().setPriority(priority);
        return list;
    }

    private PerfEvent startPerfEvent() {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        PerfEvent event = new PerfEvent();
        perfMap.put(threadName, event);
        if (getIdMethod != null) {
            try {
                Long threadId = (Long)getIdMethod.invoke((Object)thread, null);
                idMap.put(threadName, threadId);
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
        event.startTime = System.currentTimeMillis();
        if (threadMX != null && getCurrentThreadCpuTimeMethod != null) {
            try {
                event.cpuTime = (Long)getCurrentThreadCpuTimeMethod.invoke(threadMX, null);
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
        if (gcMXList != null) {
            try {
                int size = gcMXList.size();
                for (int i = 0; i < size; ++i) {
                    Object gcMX = gcMXList.get(i);
                    event.gcCount += ((Long)gcCountMethod.invoke(gcMX, null)).longValue();
                    event.gcTime += ((Long)gcTimeMethod.invoke(gcMX, null)).longValue();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
        return event;
    }

    private void endPerfEvent() {
        String threadName = Thread.currentThread().getName();
        perfMap.remove(threadName);
        idMap.remove(threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeStart(String methodStr, InvokeRecord rec) {
        block13: {
            Object session;
            StringBuffer sb;
            Method method;
            block16: {
                String methodName;
                String remoteInterface;
                block14: {
                    block15: {
                        if (!isValid) {
                            return;
                        }
                        if (rec.command != 0 && rec.command != 20 || rec.detail == null || !(rec.detail instanceof InvokeRecord.MethodInvoke)) break block13;
                        if (((InvokeRecord.MethodInvoke)rec.detail).method == null) {
                            return;
                        }
                        PerfEvent event = this.startPerfEvent();
                        remoteInterface = ((InvokeRecord.MethodInvoke)rec.detail).method.getDeclaringClass().getName();
                        method = ((InvokeRecord.MethodInvoke)rec.detail).method;
                        sb = new StringBuffer();
                        sb.append(remoteInterface);
                        sb.append(".");
                        methodName = method.getName();
                        sb.append(methodName);
                        sb.append("(");
                        if (!"com.kingdee.bos.dao.query.server.IVirtualModeDataAccess".equals(remoteInterface) || !"doAllQueryTask".equals(methodName) && !"getRowSet".equals(methodName)) break block14;
                        if (!"doAllQueryTask".equals(methodName)) break block15;
                        sb.append(((InvokeRecord.MethodInvoke)rec.detail).args[3]);
                        break block16;
                    }
                    if (!"getRowSet".equals(methodName)) break block16;
                    sb.append(((InvokeRecord.MethodInvoke)rec.detail).args[1]);
                    break block16;
                }
                if ("com.kingdee.bos.dao.query.server.IQueryDataAccess".equals(remoteInterface) && ("getRowSet".equals(methodName) || "getQuerySql".equals(methodName))) {
                    sb.append(((InvokeRecord.MethodInvoke)rec.detail).args[0]);
                } else {
                    Class<?>[] params = method.getParameterTypes();
                    for (int i = 0; i < params.length; ++i) {
                        sb.append(params[i].getName());
                        if (i >= params.length - 1) continue;
                        sb.append(", ");
                    }
                }
            }
            sb.append(") ");
            sb.append(method.getReturnType().getName());
            event.name = sb.toString();
            String thread = Thread.currentThread().getName();
            Map i = tagMap;
            synchronized (i) {
                tagMap.put(thread, new Boolean(true));
            }
            IServerSession rpc = ServerSessionContainer.getCurrentSession();
            if (rpc != null && (session = rpc.get((Object)"bos_sessionid")) != null) {
                Map map = threadSetMap;
                synchronized (map) {
                    HashSet<String> threadSet = (HashSet<String>)threadSetMap.get(session);
                    if (threadSet == null) {
                        threadSet = new HashSet<String>();
                        threadSetMap.put(session, threadSet);
                    }
                    threadSet.add(thread);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokePerformed(InvokeRecord rec) {
        if (!isValid) {
            return;
        }
        if ((rec.command == 0 || rec.command == 20) && rec.detail != null && rec.detail instanceof InvokeRecord.MethodInvoke) {
            Object session;
            this.endPerfEvent();
            String thread = Thread.currentThread().getName();
            Map map = tagMap;
            synchronized (map) {
                tagMap.remove(thread);
            }
            IServerSession rpc = ServerSessionContainer.getCurrentSession();
            if (rpc != null && (session = rpc.get((Object)"bos_sessionid")) != null) {
                Map map2 = threadSetMap;
                synchronized (map2) {
                    Set threadSet = (Set)threadSetMap.get(session);
                    if (threadSet != null) {
                        threadSet.remove(thread);
                    }
                }
            }
        }
    }

    public void startApplication(String operation) {
        if (!isValid) {
            return;
        }
        PerfEvent event = this.startPerfEvent();
        event.name = operation;
    }

    public void endApplication(String operation, long timespan, String proc_name, String instance_number) {
        if (!isValid) {
            return;
        }
        this.endPerfEvent();
    }

    public void log(LogItem item) {
        if (!isValid) {
            return;
        }
        String threadName = Thread.currentThread().getName();
        PerfEvent event = (PerfEvent)perfMap.get(threadName);
        if (event != null) {
            if (!"KDPreparedStatement.addBatch".equals(item.method) && !"Statement.addBatch".equals(item.method)) {
                ++event.sqlExeNumber;
            }
            event.sqlTime += item.timespan;
        }
    }

    public void passNextInfo(int conn_id, long nextTimespan, long firstNextTime, int row, long length, int lobNum) {
        if (!isValid) {
            return;
        }
        String threadName = Thread.currentThread().getName();
        PerfEvent event = (PerfEvent)perfMap.get(threadName);
        if (event != null) {
            ++event.nextNumber;
            event.nextTime += nextTimespan;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IServerSession rpcSession) {
        Object session;
        if (!isValid) {
            return;
        }
        if (rpcSession != null && (session = rpcSession.get((Object)"bos_sessionid")) != null) {
            Set threadSet;
            Map map = threadSetMap;
            synchronized (map) {
                threadSet = (Set)threadSetMap.remove(session);
            }
            if (threadSet != null) {
                Iterator iter = threadSet.iterator();
                Map map2 = tagMap;
                synchronized (map2) {
                    while (iter.hasNext()) {
                        Object thread = iter.next();
                        if (!tagMap.containsKey(thread)) continue;
                        tagMap.put(thread, new Boolean(false));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void interruptPerfEvent(String threadName) {
        if (!isValid) {
            return;
        }
        Map map = tagMap;
        synchronized (map) {
            if (tagMap.containsKey(threadName)) {
                tagMap.put(threadName, new Boolean(false));
            }
        }
    }

    public void checkInterrupt() throws SQLException {
        if (!isValid) {
            return;
        }
        String thread = Thread.currentThread().getName();
        Boolean tag = (Boolean)tagMap.get(thread);
        if (tag != null && !tag.booleanValue()) {
            throw new SQLException("manual interrupt or rpc session timeout!");
        }
    }

    public void passConnectionInfo(int connId, long startTime, long endTime, String type) {
        if (!isValid) {
            return;
        }
        String threadName = Thread.currentThread().getName();
        PerfEvent event = (PerfEvent)perfMap.get(threadName);
        if (event != null) {
            if ("getConn".equals(type)) {
                String conn_id = Integer.toString(connId);
                event.connIdSet.add(conn_id);
            } else {
                String conn_id = Integer.toString(connId);
                event.connIdSet.remove(conn_id);
            }
        }
    }

    public static void startHttp(ServletRequest request, ServletResponse response) {
        if (!isValid) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String url = req.getRequestURL().toString();
        if (url == null || url.endsWith("perfevent.jsp")) {
            return;
        }
        StringBuffer sbTmp = new StringBuffer(url);
        Enumeration paramEnum = req.getParameterNames();
        if (paramEnum.hasMoreElements()) {
            sbTmp.append("?");
        }
        while (paramEnum.hasMoreElements()) {
            String key = (String)paramEnum.nextElement();
            String value = req.getParameter(key);
            if ("javax.faces.ViewState".equals(key)) {
                value = String.valueOf(value.length()) + "B";
            }
            sbTmp.append(key);
            sbTmp.append("=");
            sbTmp.append(value);
            sbTmp.append(";");
        }
        PerfEvent pe = monitor.startPerfEvent();
        pe.name = sbTmp.toString();
    }

    public static void endHttp(ServletRequest request, ServletResponse respons) {
        if (!isValid) {
            return;
        }
        monitor.endPerfEvent();
    }

    static class PerfEvent {
        String name = "";
        long startTime = 0L;
        long cpuTime = 0L;
        long gcTime = 0L;
        long gcCount = 0L;
        long sqlTime = 0L;
        long sqlExeNumber = 0L;
        long nextTime = 0L;
        long nextNumber = 0L;
        Set connIdSet = new HashSet();

        PerfEvent() {
        }
    }
}

