/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import com.kingdee.bos.dao.query.CachedQueryMonitor;
import com.kingdee.bos.dao.query.QueryDataAccessInterceptor;
import com.kingdee.bos.framework.cache.CachedInvokeInterceptor;
import com.kingdee.bos.framework.cache.CachedInvokeMonitor;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.UIActionListener;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.framework.cache.notify.RPCInvokeCacheIntercepter;
import com.kingdee.bos.invokecounter.IUserInputListener;
import com.kingdee.bos.invokecounter.RPCLogEventQueue;
import com.kingdee.bos.rpc.InvokeIntercepter;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class RPCInvokeCounter
extends InvokeMonitor
implements CachedInvokeMonitor,
CachedQueryMonitor,
UIActionListener,
IUserInputListener {
    private static DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    static Set actionSet = new HashSet();
    static Map stackMap = new HashMap();
    static Map vecMap = new Hashtable();
    static Map levelMap = new HashMap();
    static Map totalMap = new HashMap();
    static Map waitMap = new HashMap();
    static Map waitTimeMap = new HashMap();
    static Map cpuTimeMap = new HashMap();
    static Map gcMap = new HashMap();
    static boolean isFilterTime = false;
    static long filterTimeThreshold = 10000L;
    static ArrayList logLineList = new ArrayList();
    static boolean isWarn = false;
    static int warn_number_0_threshold = 30;
    static int warn_number_1_threshold = 10;
    static long warn_byte_threshold = 65536L;
    private static Object threadMX = null;
    private static Method threadMXMethod = null;
    private static List gcMXList = null;
    private static Method gcCountMethod = null;
    private static Method gcTimeMethod = null;
    private static Method getStackTraceMethod = null;
    static boolean isDebug = false;
    static boolean isDebugUIHandler = false;
    private static ThreadLocal callHandler = new ThreadLocal(){

        protected Object initialValue() {
            return new Boolean(false);
        }
    };
    static boolean isFromMenu = false;
    public static final Logger logger = Logger.getLogger((String)RPCInvokeCounter.class.getName());
    public static final Logger loggerStack = Logger.getLogger((String)(RPCInvokeCounter.class.getName() + "Stack"));
    private static HashSet debugRpcSet = new HashSet();
    private static RPCInvokeCounter monitor = new RPCInvokeCounter();
    private static Method getReqMapMethod = null;
    private static Method getResMapMethod = null;
    private static Method mthGetSysContext = null;
    private static Method mthGetNumber = null;
    private static Method mthGetDCNumber = null;
    private static Method mthGetUserName = null;
    private static Method mthGetCurrentOrgUnit = null;
    private static Method mthGetProperty = null;
    private static Class clsUIConfig = null;
    private static Method mthGetURL = null;
    private static String os_user = System.getProperty("user.name");
    private static boolean isValid = false;
    public static boolean showError = false;
    private static int root_id = -1;

    protected RPCInvokeCounter(boolean client, boolean server) {
        super(client, server);
    }

    protected RPCInvokeCounter() {
        this(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (logger.getLevel() != null && logger.getLevel().equals((Object)Level.DEBUG)) {
            String warn;
            try {
                Class<?> reqClass = Class.forName("com.kingdee.eas.framework.batchHandler.RequestContext");
                Class<?> resClass = Class.forName("com.kingdee.eas.framework.batchHandler.ResponseContext");
                getReqMapMethod = reqClass.getMethod("getParameter", null);
                getResMapMethod = resClass.getMethod("getResponse", null);
                Class<?> clsSysContext = Class.forName("com.kingdee.eas.common.client.SysContext");
                Class<?> clsOrgUnitInfo = Class.forName("com.kingdee.eas.basedata.org.OrgUnitInfo");
                mthGetSysContext = clsSysContext.getMethod("getSysContext", null);
                mthGetNumber = clsOrgUnitInfo.getMethod("getNumber", null);
                mthGetDCNumber = clsSysContext.getMethod("getDCNumber", null);
                mthGetUserName = clsSysContext.getMethod("getUserName", null);
                mthGetCurrentOrgUnit = clsSysContext.getMethod("getCurrentOrgUnit", null);
                mthGetProperty = clsSysContext.getMethod("getProperty", Object.class);
                clsUIConfig = Class.forName("com.kingdee.eas.base.uiframe.client.UIConfig");
                mthGetURL = clsUIConfig.getMethod("getUrl", null);
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
            String version = System.getProperty("java.version");
            String subStr = version.substring(0, 3);
            double versionD = Double.parseDouble(subStr);
            if (versionD >= 1.5) {
                try {
                    Class<?> mapClass = Class.forName("java.util.concurrent.ConcurrentHashMap");
                    vecMap = (Map)mapClass.newInstance();
                    Class<?> facClass = Class.forName("java.lang.management.ManagementFactory");
                    Method getThreadMethod = facClass.getMethod("getThreadMXBean", null);
                    Method getGCMethod = facClass.getMethod("getGarbageCollectorMXBeans", null);
                    threadMX = getThreadMethod.invoke(facClass, null);
                    Class<?> threadMXClass = Class.forName("java.lang.management.ThreadMXBean");
                    threadMXMethod = threadMXClass.getMethod("getCurrentThreadCpuTime", null);
                    gcMXList = (List)getGCMethod.invoke(facClass, null);
                    Class<?> gcMXClass = Class.forName("java.lang.management.GarbageCollectorMXBean");
                    gcCountMethod = gcMXClass.getMethod("getCollectionCount", null);
                    gcTimeMethod = gcMXClass.getMethod("getCollectionTime", null);
                    getStackTraceMethod = Thread.class.getMethod("getStackTrace", null);
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
            String deploy = System.getProperty("easclient.root");
            String perfLog = deploy + "/PerfLog_Client.properties";
            Properties prop = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(perfLog);
                prop.load(is);
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ex) {}
                }
            }
            String valid = prop.getProperty("rpc");
            isValid = valid != null && valid.equalsIgnoreCase("on");
            String filter = prop.getProperty("filter_time");
            if (filter != null && filter.equalsIgnoreCase("on")) {
                isFilterTime = true;
                String threshold = prop.getProperty("filter_time_threshold");
                if (threshold != null) {
                    filterTimeThreshold = Long.parseLong(threshold);
                }
            } else {
                isFilterTime = false;
            }
            String debug = prop.getProperty("debug");
            if (debug != null && debug.equalsIgnoreCase("on")) {
                String debugRpc;
                isDebug = true;
                String debugUIHandler = prop.getProperty("debug_uihandler");
                if (debugUIHandler != null && debugUIHandler.equalsIgnoreCase("on")) {
                    isDebugUIHandler = true;
                }
                if ((debugRpc = prop.getProperty("debug_rpc")) != null) {
                    StringTokenizer token = new StringTokenizer(debugRpc, ";");
                    while (token.hasMoreTokens()) {
                        String rpc = token.nextToken();
                        if (rpc == null || rpc.trim().equals("")) continue;
                        debugRpcSet.add(rpc.trim());
                    }
                }
            } else {
                isDebug = false;
            }
            if ((warn = prop.getProperty("warn")) != null && warn.equalsIgnoreCase("on")) {
                String byte_threshold;
                String number_1_threshold;
                isWarn = true;
                String number_0_threshold = prop.getProperty("warn_number_0_threshold");
                if (number_0_threshold != null) {
                    warn_number_0_threshold = Integer.parseInt(number_0_threshold);
                }
                if ((number_1_threshold = prop.getProperty("warn_number_1_threshold")) != null) {
                    warn_number_1_threshold = Integer.parseInt(number_1_threshold);
                }
                if ((byte_threshold = prop.getProperty("warn_byte_threshold")) != null) {
                    warn_byte_threshold = Long.parseLong(byte_threshold);
                }
            } else {
                isWarn = false;
            }
            RPCEngineFactory.addInvokeMonitor((InvokeMonitor)monitor);
            CachedInvokeInterceptor.addMonitor((CachedInvokeMonitor)monitor);
            QueryDataAccessInterceptor.addMonitor((CachedQueryMonitor)monitor);
            UIActionMonitor.addListener((UIActionListener)monitor);
            RPCLogEventQueue.addListener(monitor);
        }
        RPCEngineFactory.addInvokeIntercepters((InvokeIntercepter)RPCInvokeCacheIntercepter.INSTANCE);
    }

    private static long[] getStackData() {
        String name = Thread.currentThread().getName();
        long[] data = (long[])totalMap.get(name);
        if (data == null) {
            data = new long[]{0L, 0L, 0L, 0L, 0L};
            totalMap.put(name, data);
        }
        return data;
    }

    private static Stack getStack() {
        String name = Thread.currentThread().getName();
        Stack rpcStack = (Stack)stackMap.get(name);
        if (rpcStack == null) {
            rpcStack = new Stack();
            stackMap.put(name, rpcStack);
        }
        return rpcStack;
    }

    private static Vector getVector() {
        String name = Thread.currentThread().getName();
        Vector rpcVector = (Vector)vecMap.get(name);
        if (rpcVector == null) {
            rpcVector = new Vector();
            vecMap.put(name, rpcVector);
        }
        return rpcVector;
    }

    private static void setVector(Vector rpcVector) {
        String name = Thread.currentThread().getName();
        vecMap.put(name, rpcVector);
    }

    private static Integer getStackLevel() {
        String name = Thread.currentThread().getName();
        Integer level = (Integer)levelMap.get(name);
        if (level == null) {
            level = 0;
            levelMap.put(name, level);
        }
        return level;
    }

    private static void setStackLevel(int add) {
        String name = Thread.currentThread().getName();
        Integer level = RPCInvokeCounter.getStackLevel();
        int levelInt = level + add;
        level = levelInt;
        levelMap.put(name, level);
    }

    public static void endInvokeCount(String remoteInterface, String method, long timespan, long requestBytes, long responseBytes, int invokeID, int subaction_id, long net_time) {
        if (!isValid) {
            return;
        }
        if (remoteInterface.endsWith("IMessageCenter") && method.startsWith("receiveTempMsg")) {
            return;
        }
        Integer level = RPCInvokeCounter.getStackLevel();
        if (level == 0 && remoteInterface.startsWith("#####")) {
            return;
        }
        if (level > 0) {
            long[] waitVec = RPCInvokeCounter.getWaitRPCNumber();
            long[] waitTimeVec = RPCInvokeCounter.getWaitTime();
            if (!(remoteInterface.startsWith("-----") || remoteInterface.startsWith("+++++") || remoteInterface.startsWith("#####"))) {
                waitVec[1] = waitVec[1] + 1L;
                waitVec[4] = waitVec[4] + (requestBytes + responseBytes);
                if (!method.startsWith("Execute")) {
                    waitVec[6] = waitVec[6] + 1L;
                }
                waitTimeVec[2] = System.currentTimeMillis();
            }
            if (waitVec[1] > waitVec[0]) {
                waitVec[0] = waitVec[1];
            }
            if (waitVec[4] > waitVec[3]) {
                waitVec[3] = waitVec[4];
            }
            if ((waitVec[1] != 1L || waitVec[6] != 1L) && waitVec[6] > waitVec[5]) {
                waitVec[5] = waitVec[6];
            }
            if (remoteInterface.startsWith("#####")) {
                waitVec[1] = 0L;
                waitVec[2] = waitVec[2] + 1L;
                waitVec[4] = 0L;
                waitVec[6] = 0L;
                long waitTime = waitTimeVec[2] - waitTimeVec[1];
                if (waitTime > waitTimeVec[0]) {
                    waitTimeVec[0] = waitTime;
                }
                waitTimeVec[1] = System.currentTimeMillis();
            }
        }
        RPCInvokeCounter.getVector().add(remoteInterface + "." + method);
        long[] data = new long[]{timespan, requestBytes, responseBytes, invokeID, System.currentTimeMillis(), net_time};
        Object[] related = new Object[]{data, subaction_id};
        RPCInvokeCounter.getVector().add(related);
    }

    public static synchronized void startActionCount(String ui, String action) {
        if (!isValid) {
            return;
        }
        if (RPCInvokeCounter.getVector() != null) {
            RPCInvokeCounter.getStack().push(RPCInvokeCounter.getVector());
            RPCInvokeCounter.setStackLevel(1);
        }
        RPCInvokeCounter.setVector(new Vector());
        if (RPCInvokeCounter.getStackLevel() == 1) {
            long[] waitVec = RPCInvokeCounter.getWaitRPCNumber();
            waitVec[0] = 0L;
            waitVec[1] = 0L;
            waitVec[2] = 1L;
            waitVec[3] = 0L;
            waitVec[4] = 0L;
            waitVec[5] = 0L;
            waitVec[6] = 0L;
            long[] waitTimeVec = RPCInvokeCounter.getWaitTime();
            waitTimeVec[0] = 0L;
            waitTimeVec[1] = System.currentTimeMillis();
            waitTimeVec[2] = waitTimeVec[1];
            waitTimeVec[3] = waitTimeVec[1];
            String thread = Thread.currentThread().getName();
            long[] cpuTime = new long[]{0L, 0L};
            if (threadMX != null && threadMXMethod != null) {
                try {
                    cpuTime[0] = (Long)threadMXMethod.invoke(threadMX, null);
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
            cpuTimeMap.put(thread, cpuTime);
            long[] gcVec = new long[]{0L, 0L, 0L, 0L};
            gcMap.put(thread, gcVec);
            if (gcMXList != null) {
                try {
                    int size = gcMXList.size();
                    for (int i = 0; i < size; ++i) {
                        Object gcMX = gcMXList.get(i);
                        gcVec[0] = gcVec[0] + (Long)gcCountMethod.invoke(gcMX, null);
                        gcVec[2] = gcVec[2] + (Long)gcTimeMethod.invoke(gcMX, null);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
            if (thread.startsWith("AWT-EventQueue")) {
                root_id = Uuid.create().hashCode();
                callHandler.set(new Boolean(false));
                isFromMenu = "clickMenuItem".equals(action) || "openFavorite".equals(action);
            }
        }
    }

    public static synchronized int endActionCount(String ui, String action, long actionTime) {
        if (!isValid) {
            return 0;
        }
        int invokeNumber = 0;
        invokeNumber = RPCInvokeCounter.getVector().size();
        long totalTime = 0L;
        long totalNetTime = 0L;
        long request = 0L;
        long response = 0L;
        int rpcNumber = invokeNumber / 2;
        int action_id = Uuid.create().hashCode();
        boolean isFirst = false;
        long MaxWaitRPCNumber = 0L;
        long MaxWaitUserRPCNumber = 0L;
        long MaxWaitRPCBytes = 0L;
        long MaxWaitTime = 0L;
        logLineList.add("");
        if (actionSet.contains(ui + "." + action)) {
            isFirst = false;
            logLineList.add(ui + "." + action);
        } else {
            isFirst = true;
            logLineList.add(ui + "." + action + " (no.1)");
            actionSet.add(ui + "." + action);
        }
        String threadName = Thread.currentThread().getName();
        StringBuffer sb = new StringBuffer();
        sb.append("thread: ");
        sb.append(threadName);
        sb.append("  stack: ");
        sb.append(RPCInvokeCounter.getStackLevel());
        sb.append("  action_id: ");
        sb.append(action_id);
        sb.append("  root_id: ");
        if (threadName.startsWith("AWT-EventQueue")) {
            sb.append(root_id);
        } else {
            sb.append(-1);
        }
        if (RPCInvokeCounter.getStackLevel() == 1) {
            try {
                Object sysContextObject = mthGetSysContext.invoke(null, null);
                if (sysContextObject != null) {
                    sb.append("  ip: ");
                    sb.append(mthGetURL.invoke((Object)clsUIConfig, null));
                    sb.append("  dc: ");
                    sb.append(mthGetDCNumber.invoke(sysContextObject, null));
                    sb.append("  dbtype: ");
                    sb.append(mthGetProperty.invoke(sysContextObject, "dbType"));
                    sb.append("  user: ");
                    sb.append(mthGetUserName.invoke(sysContextObject, null));
                    Object objCurrentOrgUnit = mthGetCurrentOrgUnit.invoke(sysContextObject, null);
                    sb.append("  ou: ");
                    if (objCurrentOrgUnit != null) {
                        sb.append(mthGetNumber.invoke(objCurrentOrgUnit, new Object[0]));
                    }
                    sb.append("  os_user: ");
                    if (os_user != null) {
                        sb.append(os_user);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
            sb.append("  callHandler: ");
            sb.append(callHandler.get());
        }
        logLineList.add(sb.toString());
        if (RPCInvokeCounter.getStackLevel() == 1) {
            sb = new StringBuffer();
            sb.append("==============rpcInvoke start============== ");
            long[] waitTimeVec = RPCInvokeCounter.getWaitTime();
            Date date = new Date(waitTimeVec[3]);
            sb.append(df.format(date));
            logLineList.add(sb.toString());
        } else {
            logLineList.add("==============rpcInvoke start==============");
        }
        for (int i = 0; i < invokeNumber; ++i) {
            Object rpcInvoke = RPCInvokeCounter.getVector().get(i);
            if (rpcInvoke instanceof Object[]) {
                Object[] related = (Object[])rpcInvoke;
                long[] data = (long[])related[0];
                totalTime += data[0];
                totalNetTime += data[5];
                request += data[1];
                response += data[2];
                sb = new StringBuffer();
                sb.append("time: ");
                sb.append(data[0]);
                sb.append("  req: ");
                sb.append(data[1]);
                sb.append(" B  ");
                sb.append("res: ");
                sb.append(data[2]);
                sb.append(" B  ");
                sb.append("invoke_id: ");
                sb.append(data[3]);
                sb.append("  end_time: ");
                Date endDate = new Date(data[4]);
                sb.append(df.format(endDate));
                if (related[1] != null) {
                    sb.append("  subaction_id: ");
                    sb.append(related[1]);
                }
                sb.append("  net_time: ");
                sb.append(data[5]);
                logLineList.add(sb.toString());
                continue;
            }
            String tmpStr = (String)rpcInvoke;
            if (tmpStr.startsWith("----------")) {
                --rpcNumber;
            } else if (tmpStr.startsWith("++++++++++")) {
                --rpcNumber;
            } else if (tmpStr.startsWith("#####")) {
                --rpcNumber;
            }
            logLineList.add(rpcInvoke);
        }
        if (RPCInvokeCounter.getStackLevel() == 1) {
            sb = new StringBuffer();
            sb.append("==============rpcInvoke end============== ");
            Date date = new Date();
            sb.append(df.format(date));
            logLineList.add(sb.toString());
        } else {
            logLineList.add("==============rpcInvoke end==============");
        }
        sb = new StringBuffer();
        sb.append("rpcNumber: ");
        sb.append(rpcNumber);
        sb.append("  rpcTime: ");
        sb.append(totalTime);
        sb.append("  netTime: ");
        sb.append(totalNetTime);
        sb.append("  rpcBytes: ");
        sb.append(request + response);
        sb.append(" B");
        logLineList.add(sb.toString());
        long[] data = RPCInvokeCounter.getStackData();
        data[0] = data[0] + totalTime;
        data[1] = data[1] + request;
        data[2] = data[2] + response;
        data[3] = data[3] + (long)rpcNumber;
        data[4] = data[4] + totalNetTime;
        if (RPCInvokeCounter.getStackLevel() == 1) {
            sb = new StringBuffer();
            sb.append("stackRpcNumber: ");
            sb.append(data[3]);
            sb.append("  stackRpcTime: ");
            sb.append(data[0]);
            sb.append("  stackNetTime: ");
            sb.append(data[4]);
            sb.append("  stackRpcBytes: ");
            sb.append(data[1] + data[2]);
            sb.append(" B");
            logLineList.add(sb.toString());
            data[0] = 0L;
            data[1] = 0L;
            data[2] = 0L;
            data[3] = 0L;
            data[4] = 0L;
        }
        sb = new StringBuffer();
        sb.append("actionTime: ");
        sb.append(actionTime);
        sb.append("  ");
        if (RPCInvokeCounter.getStackLevel() == 1) {
            long[] cpuTime = (long[])cpuTimeMap.remove(threadName);
            if (threadMX != null && threadMXMethod != null) {
                try {
                    cpuTime[1] = (Long)threadMXMethod.invoke(threadMX, null);
                }
                catch (Exception ex) {
                    cpuTime[1] = 0L;
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
            long[] gcVec = (long[])gcMap.remove(threadName);
            if (gcMXList != null) {
                try {
                    int size = gcMXList.size();
                    for (int i = 0; i < size; ++i) {
                        Object gcMX = gcMXList.get(i);
                        gcVec[1] = gcVec[1] + (Long)gcCountMethod.invoke(gcMX, null);
                        gcVec[3] = gcVec[3] + (Long)gcTimeMethod.invoke(gcMX, null);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
            sb.append("cpuTime: ");
            sb.append((cpuTime[1] - cpuTime[0]) / 1000000L);
            sb.append("  gcCount: ");
            sb.append(gcVec[1] - gcVec[0]);
            sb.append("  gcTime: ");
            sb.append(gcVec[3] - gcVec[2]);
        }
        logLineList.add(sb.toString());
        if (RPCInvokeCounter.getStackLevel() == 1) {
            sb = new StringBuffer();
            long[] waitTimeVec = RPCInvokeCounter.getWaitTime();
            waitTimeVec[2] = System.currentTimeMillis();
            long waitTime = waitTimeVec[2] - waitTimeVec[1];
            if (waitTime > waitTimeVec[0]) {
                waitTimeVec[0] = waitTime;
            }
            sb.append("waitTime: ");
            sb.append(waitTimeVec[0]);
            MaxWaitTime = waitTimeVec[0];
            long[] waitVec = RPCInvokeCounter.getWaitRPCNumber();
            sb.append("  operation: ");
            sb.append(waitVec[2]);
            sb.append("  waitRpcNumber: ");
            sb.append(waitVec[0]);
            MaxWaitRPCNumber = waitVec[0];
            sb.append("  waitUserRpcNumber: ");
            sb.append(waitVec[5]);
            MaxWaitUserRPCNumber = waitVec[5];
            sb.append("  waitRpcBytes: ");
            sb.append(waitVec[3]);
            MaxWaitRPCBytes = waitVec[3];
            sb.append(" B");
            waitVec[0] = 0L;
            waitVec[1] = 0L;
            waitVec[2] = 1L;
            logLineList.add(sb.toString());
        }
        if (isWarn && RPCInvokeCounter.getStackLevel() == 1 && threadName.startsWith("AWT-EventQueue")) {
            boolean isOutputWarn = false;
            if (isFirst && MaxWaitRPCNumber > (long)warn_number_0_threshold || !isFirst && MaxWaitRPCNumber > (long)warn_number_1_threshold || MaxWaitRPCBytes > warn_byte_threshold || showError && ((Boolean)callHandler.get()).booleanValue() && (MaxWaitUserRPCNumber > 0L || MaxWaitRPCNumber > 2L)) {
                isOutputWarn = true;
            }
            if (isOutputWarn) {
                StringBuffer msg = new StringBuffer();
                if (isFirst) {
                    msg.append("Action Name: ");
                    msg.append(ui);
                    msg.append(".");
                    msg.append(action);
                    msg.append(" (no.1)");
                    msg.append("\nAction ID: ");
                    msg.append(action_id);
                    if (MaxWaitRPCNumber > (long)warn_number_0_threshold) {
                        msg.append("\n\n\u5355\u6b21\u7528\u6237\u64cd\u4f5c\uff0c\u7f51\u7edc\u901a\u8baf\u6b21\u6570\u4e3a");
                        msg.append(MaxWaitRPCNumber);
                        msg.append("\u6b21\uff0c\u8d85\u51fa");
                        msg.append(warn_number_0_threshold);
                        msg.append("\u6b21\u7684\u4e0a\u9650\uff01");
                    }
                    if (MaxWaitRPCBytes > warn_byte_threshold) {
                        msg.append("\n\n\u5355\u6b21\u7528\u6237\u64cd\u4f5c\uff0c\u7f51\u7edc\u901a\u8baf\u6570\u636e\u91cf\u4e3a");
                        msg.append(MaxWaitRPCBytes);
                        msg.append("\u5b57\u8282\uff0c\u8d85\u51fa");
                        msg.append(warn_byte_threshold);
                        msg.append("\u5b57\u8282\u7684\u4e0a\u9650\uff01");
                    }
                } else {
                    msg.append("Action Name: ");
                    msg.append(ui);
                    msg.append(".");
                    msg.append(action);
                    msg.append("\nAction ID: ");
                    msg.append(action_id);
                    if (MaxWaitRPCNumber > (long)warn_number_1_threshold) {
                        msg.append("\n\n\u5355\u6b21\u7528\u6237\u64cd\u4f5c\uff0c\u7f51\u7edc\u901a\u8baf\u6b21\u6570\u4e3a");
                        msg.append(MaxWaitRPCNumber);
                        msg.append("\u6b21\uff0c\u8d85\u51fa");
                        msg.append(warn_number_1_threshold);
                        msg.append("\u6b21\u7684\u4e0a\u9650\uff01");
                    }
                    if (MaxWaitRPCBytes > warn_byte_threshold) {
                        msg.append("\n\n\u5355\u6b21\u7528\u6237\u64cd\u4f5c\uff0c\u7f51\u7edc\u901a\u8baf\u6570\u636e\u91cf\u4e3a");
                        msg.append(MaxWaitRPCBytes);
                        msg.append("\u5b57\u8282\uff0c\u8d85\u51fa");
                        msg.append(warn_byte_threshold);
                        msg.append("\u5b57\u8282\u7684\u4e0a\u9650\uff01");
                    }
                }
                if (showError && ((Boolean)callHandler.get()).booleanValue() && (MaxWaitUserRPCNumber > 0L || MaxWaitRPCNumber > 2L)) {
                    msg.append("\n\n\u5355\u6b21\u7528\u6237\u64cd\u4f5c\uff0c\u975e\u901a\u8baf\u70b9\u7684RPC\u6b21\u6570\u4e3a");
                    msg.append(MaxWaitUserRPCNumber);
                    msg.append("\u6b21\uff0c\u7b49\u5f85\u7684RPC\u6b21\u6570\u4e3a");
                    msg.append(MaxWaitRPCNumber);
                    msg.append("\u6b21\uff01");
                    msg.append("\n\n\u8bf7\u4f7f\u7528rpc stack log\u8fdb\u884c\u5206\u6790\u3002");
                }
                msg.append("\n\n");
                int size = logLineList.size();
                for (int i = 0; i < size; ++i) {
                    msg.append(logLineList.get(i));
                    msg.append("\n");
                }
                try {
                    Class<?> bClass = Class.forName("com.kingdee.eas.util.client.AdvMsgBox");
                    Method methodCreate = bClass.getMethod("createAdvMsgBox", Component.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE);
                    Method methodModal = bClass.getMethod("setModal", Boolean.TYPE);
                    Method methodShow = bClass.getMethod("show", null);
                    Object box = methodCreate.invoke(bClass, null, "rpc log\u5ba1\u8ba1\u8d85\u6807", "rpc log\u5ba1\u8ba1\u8d85\u6807", msg.toString(), 8188, 8188);
                    methodModal.invoke(box, false);
                    methodShow.invoke(box, null);
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
            }
        }
        if (isFilterTime) {
            if (RPCInvokeCounter.getStackLevel() == 1) {
                long[] waitTimeVec = RPCInvokeCounter.getWaitTime();
                if (waitTimeVec[0] >= filterTimeThreshold) {
                    RPCInvokeCounter.writeLogLineList();
                } else {
                    logLineList.clear();
                }
            }
        } else if (isWarn && RPCInvokeCounter.getStackLevel() == 1 || !isWarn) {
            RPCInvokeCounter.writeLogLineList();
        }
        RPCInvokeCounter.setVector((Vector)RPCInvokeCounter.getStack().pop());
        RPCInvokeCounter.setStackLevel(-1);
        RPCInvokeCounter.endInvokeCount("----------" + ui, action, 0L, 0L, 0L, -1, action_id, 0L);
        return invokeNumber;
    }

    private static void writeLogLineList() {
        int size = logLineList.size();
        for (int i = 0; i < size; ++i) {
            logger.debug(logLineList.get(i));
        }
        logLineList.clear();
    }

    public static synchronized void printMainFrameVector() {
        if (!isValid) {
            return;
        }
        logger.debug((Object)"");
        logger.debug((Object)"MainFrame Quit");
        StringBuffer sb = new StringBuffer();
        sb.append("end_time: ");
        Date date = new Date(System.currentTimeMillis());
        sb.append(df.format(date));
        sb.append("  quit_id: ");
        sb.append(Uuid.create().hashCode());
        try {
            Object sysContextObject = mthGetSysContext.invoke(null, null);
            if (sysContextObject != null) {
                sb.append("  ip: ");
                sb.append(mthGetURL.invoke((Object)clsUIConfig, null));
                sb.append("  dc: ");
                sb.append(mthGetDCNumber.invoke(sysContextObject, null));
                sb.append("  dbtype: ");
                sb.append(mthGetProperty.invoke(sysContextObject, "dbType"));
                sb.append("  user: ");
                sb.append(mthGetUserName.invoke(sysContextObject, null));
                Object objCurrentOrgUnit = mthGetCurrentOrgUnit.invoke(sysContextObject, null);
                sb.append("  ou: ");
                if (objCurrentOrgUnit != null) {
                    sb.append(mthGetNumber.invoke(objCurrentOrgUnit, new Object[0]));
                }
                sb.append("  os_user: ");
                if (os_user != null) {
                    sb.append(os_user);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        logger.debug((Object)sb.toString());
        logger.debug((Object)"==============eas client start==============");
        for (Object name : vecMap.keySet()) {
            Vector vector = (Vector)vecMap.get(name);
            Integer level = (Integer)levelMap.get(name);
            long maxRpcTimespan = 0L;
            long threadTime = 0L;
            int invokeNumber = 0;
            if (vector != null) {
                invokeNumber = vector.size();
            }
            if (invokeNumber > 0) {
                logLineList.add("");
                logLineList.add(name + " : " + invokeNumber / 2 + " times");
                logLineList.add("stack level: " + level);
                logLineList.add("==============rpcInvoke start==============");
                for (int i = 0; i < invokeNumber; ++i) {
                    Object rpcInvoke = vector.get(i);
                    if (rpcInvoke instanceof Object[]) {
                        Object[] related = (Object[])rpcInvoke;
                        long[] data = (long[])related[0];
                        threadTime += data[0];
                        if (data[0] > maxRpcTimespan) {
                            maxRpcTimespan = data[0];
                        }
                        sb = new StringBuffer();
                        sb.append("time: ");
                        sb.append(data[0]);
                        sb.append("  req: ");
                        sb.append(data[1]);
                        sb.append(" B  ");
                        sb.append("res: ");
                        sb.append(data[2]);
                        sb.append(" B  ");
                        sb.append("invoke_id: ");
                        sb.append(data[3]);
                        sb.append("  end_time: ");
                        Date endDate = new Date(data[4]);
                        sb.append(df.format(endDate));
                        if (related[1] != null) {
                            sb.append("  subaction_id: ");
                            sb.append(related[1]);
                        }
                        sb.append("  net_time: ");
                        sb.append(data[5]);
                        logLineList.add(sb.toString());
                        continue;
                    }
                    logLineList.add(rpcInvoke);
                }
                logLineList.add("==============rpcInvoke end==============");
                logLineList.add("rpc time: " + threadTime);
            }
            if (isFilterTime) {
                if (maxRpcTimespan >= filterTimeThreshold) {
                    RPCInvokeCounter.writeLogLineList();
                    continue;
                }
                logLineList.clear();
                continue;
            }
            RPCInvokeCounter.writeLogLineList();
        }
        logger.debug((Object)"");
        logger.debug((Object)"==============eas client end==============");
        levelMap.clear();
        stackMap.clear();
        totalMap.clear();
        vecMap.clear();
        actionSet.clear();
        waitMap.clear();
        waitTimeMap.clear();
        logLineList.clear();
        cpuTimeMap.clear();
        gcMap.clear();
    }

    public void invokePerformed(InvokeRecord rec) {
        if (!isValid) {
            return;
        }
        if (rec.command == 0 || rec.command == 20) {
            if (rec.detail != null && rec.detail instanceof InvokeRecord.MethodInvoke) {
                String remoteInterface = ((InvokeRecord.MethodInvoke)rec.detail).model.getName();
                if (remoteInterface == null) {
                    remoteInterface = ((InvokeRecord.MethodInvoke)rec.detail).method.getDeclaringClass().getName();
                }
                Method method = ((InvokeRecord.MethodInvoke)rec.detail).method;
                Object[] args = ((InvokeRecord.MethodInvoke)rec.detail).args;
                Class model = ((InvokeRecord.MethodInvoke)rec.detail).model;
                String repository = ((InvokeRecord.MethodInvoke)rec.detail).repository;
                if ("com.kingdee.eas.base.permission.IMainMenuItem".equals(remoteInterface) && "getMainMenuItemInfo".equals(method.getName())) {
                    return;
                }
                StringBuffer sb = new StringBuffer();
                sb.append(method.getName());
                sb.append("(");
                Class<?>[] params = method.getParameterTypes();
                for (int i = 0; i < params.length; ++i) {
                    sb.append(params[i].getName());
                    if (i >= params.length - 1) continue;
                    sb.append(", ");
                }
                sb.append(") ");
                sb.append(method.getReturnType().getName());
                long timespan = rec.getTime();
                long net_time = rec.getRequestTime() + rec.getResponseTime();
                long requestBytes = rec.requestAcutalBytes;
                long responseBytes = rec.responseActualBytes;
                int invokeID = ((InvokeRecord.MethodInvoke)rec.detail).invokeId;
                String methodName = method.getName();
                if (remoteInterface.equals("com.kingdee.eas.framework.IServiceHandlerFacade") && methodName.equals("Execute") && (RPCInvokeCounter.getStackLevel() == 1 || isFromMenu && RPCInvokeCounter.getStackLevel() == 2)) {
                    callHandler.set(new Boolean(true));
                }
                if (isDebug) {
                    try {
                        Thread thread = Thread.currentThread();
                        StackTraceElement[] stackVec = new StackTraceElement[]{};
                        if (getStackTraceMethod != null) {
                            stackVec = (StackTraceElement[])getStackTraceMethod.invoke((Object)thread, null);
                        }
                        boolean isHandlerRPC = false;
                        if (remoteInterface.equals("com.kingdee.eas.framework.IServiceHandlerFacade") && methodName.equals("Execute")) {
                            isHandlerRPC = true;
                            if (isDebugUIHandler) {
                                Object req = ((InvokeRecord.MethodInvoke)rec.detail).args[0];
                                Object res = ((InvokeRecord.MethodInvoke)rec.detail).result;
                                loggerStack.debug((Object)"");
                                loggerStack.debug((Object)"com.kingdee.eas.framework.IServiceHandlerFacade.Execute");
                                loggerStack.debug((Object)("invoke_id: " + invokeID));
                                loggerStack.debug((Object)"==============stack==============");
                                for (int i = 0; i < stackVec.length; ++i) {
                                    loggerStack.debug((Object)stackVec[i].toString());
                                }
                                loggerStack.debug((Object)"==============request==============");
                                Map reqMap = (Map)getReqMapMethod.invoke(req, null);
                                for (Object key : reqMap.keySet()) {
                                    Object value = reqMap.get(key);
                                    String valueStr = value == null ? "null" : value.toString();
                                    loggerStack.debug((Object)(key + "  :  " + valueStr));
                                }
                                loggerStack.debug((Object)"==============response==============");
                                Map resMap = (Map)getResMapMethod.invoke(res, null);
                                for (Object key : resMap.keySet()) {
                                    Object value = resMap.get(key);
                                    String valueStr = value == null ? "null" : value.toString();
                                    loggerStack.debug((Object)(key + "  :  " + valueStr));
                                }
                                loggerStack.debug((Object)"==============end==============");
                            }
                        }
                        boolean isFindProxy = false;
                        String invoker = "";
                        for (int i = 0; i < stackVec.length; ++i) {
                            String className = stackVec[i].getClassName();
                            if (!isFindProxy && className.startsWith("$Proxy")) {
                                isFindProxy = true;
                                if (i + 1 < stackVec.length) {
                                    invoker = stackVec[i + 1].toString();
                                }
                            }
                            if (isFindProxy && className.indexOf("UIActionPostman") >= 0 && i + 1 < stackVec.length) {
                                invoker = stackVec[i + 1].toString();
                                break;
                            }
                            if (!isFindProxy || className.indexOf("UI") < 0) continue;
                            invoker = stackVec[i].toString();
                            break;
                        }
                        sb.append("  [");
                        sb.append(invoker);
                        sb.append("]");
                        String key = remoteInterface + "." + methodName;
                        if (debugRpcSet.contains(key)) {
                            loggerStack.debug((Object)"");
                            loggerStack.debug((Object)(remoteInterface + "." + sb.toString()));
                            loggerStack.debug((Object)("invoke_id: " + invokeID));
                            if (isDebugUIHandler) {
                                loggerStack.debug((Object)("MultiParamKey: " + MultiParamKey.create((Class)model, (Method)method, (Object[])args)));
                            }
                            loggerStack.debug((Object)"==============rpcStack start==============");
                            for (int i = 0; i < stackVec.length; ++i) {
                                loggerStack.debug((Object)stackVec[i].toString());
                            }
                            loggerStack.debug((Object)"==============rpcStack end==============");
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex, (Throwable)ex);
                    }
                }
                if (repository != null && repository.length() > 0) {
                    remoteInterface = "[" + repository + "]" + remoteInterface;
                }
                RPCInvokeCounter.endInvokeCount(remoteInterface, sb.toString(), timespan, requestBytes, responseBytes, invokeID, -1, net_time);
            }
        } else if (rec.command == 3 && rec.detail != null) {
            String remoteInterface = ((InvokeRecord.CreateObject)rec.detail).model.getName();
            String method = "createObject()";
            if (remoteInterface.equals("com.kingdee.eas.framework.IServiceHandlerFacade") || remoteInterface.equals("com.kingdee.eas.base.permission.IMainMenuItem")) {
                return;
            }
            long timespan = rec.getTime();
            long net_time = rec.getRequestTime() + rec.getResponseTime();
            long requestBytes = rec.requestAcutalBytes;
            long responseBytes = rec.responseActualBytes;
            RPCInvokeCounter.endInvokeCount(remoteInterface, method, timespan, requestBytes, responseBytes, 0, -1, net_time);
        }
    }

    public static void clearActionSet() {
        actionSet.clear();
    }

    public static void cachedInvoke(Method method, long timespan) {
        if (!isValid) {
            return;
        }
        String remoteInterface = "++++++++++" + method.getDeclaringClass().getName();
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        sb.append("(");
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            sb.append(params[i].getName());
            if (i >= params.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") ");
        sb.append(method.getReturnType().getName());
        RPCInvokeCounter.endInvokeCount(remoteInterface, sb.toString(), timespan, 0L, 0L, -1, -1, 0L);
    }

    public static void cachedQuery(String remoteInterface, String method, long timespan) {
        if (!isValid) {
            return;
        }
        RPCInvokeCounter.endInvokeCount("++++++++++" + remoteInterface, method, timespan, 0L, 0L, -1, -1, 0L);
    }

    private static long[] getWaitRPCNumber() {
        String name = Thread.currentThread().getName();
        long[] waitVec = (long[])waitMap.get(name);
        if (waitVec == null) {
            waitVec = new long[]{0L, 0L, 1L, 0L, 0L, 0L, 0L};
            waitMap.put(name, waitVec);
        }
        return waitVec;
    }

    private static long[] getWaitTime() {
        String name = Thread.currentThread().getName();
        long[] waitVec = (long[])waitTimeMap.get(name);
        if (waitVec == null) {
            waitVec = new long[]{0L, 0L, 0L, 0L};
            waitTimeMap.put(name, waitVec);
        }
        return waitVec;
    }

    public void passCachedInvokeInfo(Method method, long timespan) {
        RPCInvokeCounter.cachedInvoke(method, timespan);
    }

    public void passCachedQueryInfo(String remoteInterface, String method, long timespan) {
        RPCInvokeCounter.cachedQuery(remoteInterface, method, timespan);
    }

    public void endAction(String ui, String action, long actionTime) {
        RPCInvokeCounter.endActionCount(ui, action, actionTime);
    }

    public void startAction(String ui, String action) {
        RPCInvokeCounter.startActionCount(ui, action);
    }

    public void clearAction() {
        actionSet.clear();
        RPCInvokeCounter.printMainFrameVector();
    }

    @Override
    public void inputPerformed(String type) {
        RPCInvokeCounter.endInvokeCount("##########input", type, 0L, 0L, 0L, -1, -1, 0L);
    }
}

