/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.invokecounter;

import com.kingdee.bos.sql.shell.KDResultSet;
import com.kingdee.bos.sql.shell.trace.ConnectionLogger;
import com.kingdee.bos.sql.shell.trace.LogItem;
import com.kingdee.bos.sql.shell.trace.LoggerDest;
import com.kingdee.bos.sql.shell.trace.NextDest;
import com.kingdee.bos.workflow.enactment.app.ApplicationMonitor;
import com.kingdee.bos.workflow.enactment.app.DefaultApplicationManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WorkflowSqlCounter
implements LoggerDest,
ApplicationMonitor,
NextDest {
    public static final Logger logger = Logger.getLogger((String)WorkflowSqlCounter.class.getName());
    public static final Logger loggerPre = Logger.getLogger((String)(WorkflowSqlCounter.class.getName() + "Pre"));
    public static final WorkflowSqlCounter monitor = new WorkflowSqlCounter();
    private static DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    private static boolean isValid = false;
    private static ThreadLocal threadSqlVec = new ThreadLocal();
    private static ThreadLocal threadMethodTime = new ThreadLocal();
    private static ThreadLocal threadCPUTime = new ThreadLocal();
    private static ThreadLocal threadGC = new ThreadLocal();
    private static HashSet excludeSet = new HashSet();
    private static boolean isFilterTime = false;
    private static long filter_time_threshold = 10000L;
    private static long filter_vector_threshold = 10000L;
    private static Object threadMX = null;
    private static Method threadMXMethod = null;
    private static List gcMXList = null;
    private static Method gcCountMethod = null;
    private static Method gcTimeMethod = null;
    private static boolean isPreOutput = false;

    public static boolean isFilterTime() {
        return isFilterTime;
    }

    public static void setFilterTime(boolean isFilter) {
        isFilterTime = isFilter;
    }

    public static long getFilterTimeThreshold() {
        return filter_time_threshold;
    }

    public static void setFilterTimeThreshold(long threshold) {
        filter_time_threshold = threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        String onoff;
        String version = System.getProperty("java.version");
        String subStr = version.substring(0, 3);
        double versionD = Double.parseDouble(subStr);
        if (versionD >= 1.5) {
            try {
                Class<?> facClass = Class.forName("java.lang.management.ManagementFactory");
                Method getThreadMethod = facClass.getMethod("getThreadMXBean", null);
                Method getGCMethod = facClass.getMethod("getGarbageCollectorMXBeans", null);
                threadMX = getThreadMethod.invoke(facClass, null);
                Class<?> threadMXClass = Class.forName("java.lang.management.ThreadMXBean");
                Method isSupportedMethod = threadMXClass.getMethod("isThreadCpuTimeSupported", null);
                Method isEnabledMethod = threadMXClass.getMethod("isThreadCpuTimeEnabled", null);
                Boolean isSupported = (Boolean)isSupportedMethod.invoke(threadMX, null);
                Boolean isEnabled = (Boolean)isEnabledMethod.invoke(threadMX, null);
                if (isSupported.booleanValue() && isEnabled.booleanValue()) {
                    threadMXMethod = threadMXClass.getMethod("getCurrentThreadCpuTime", null);
                }
                gcMXList = (List)getGCMethod.invoke(facClass, null);
                Class<?> gcMXClass = Class.forName("java.lang.management.GarbageCollectorMXBean");
                gcCountMethod = gcMXClass.getMethod("getCollectionCount", null);
                gcTimeMethod = gcMXClass.getMethod("getCollectionTime", null);
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
        String deploy = System.getProperty("eas.deploy");
        String perfLog = deploy + "/PerfLog_Server.properties";
        Properties prop = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(perfLog);
            prop.load(is);
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ex) {}
            }
        }
        String exclude = prop.getProperty("workflowsql_exclude");
        if (exclude != null) {
            StringTokenizer token = new StringTokenizer(exclude, ";");
            while (token.hasMoreTokens()) {
                excludeSet.add(token.nextToken());
            }
        }
        if ((onoff = prop.getProperty("workflowsql")) != null && onoff.equalsIgnoreCase("on")) {
            isValid = true;
            ConnectionLogger.addLoggerDest((LoggerDest)monitor);
            DefaultApplicationManager.addApplicationMonitor((ApplicationMonitor)monitor);
            KDResultSet.addNextDest((NextDest)monitor);
        } else {
            isValid = false;
        }
        String preOutput = prop.getProperty("rpcsql_pre");
        isPreOutput = preOutput != null && preOutput.equalsIgnoreCase("on");
        String filter = prop.getProperty("workflowsql_filter_time");
        if (filter != null && filter.equalsIgnoreCase("on")) {
            isFilterTime = true;
            String threshold = prop.getProperty("workflowsql_filter_time_threshold");
            if (threshold != null) {
                filter_time_threshold = Long.parseLong(threshold);
            }
        } else {
            isFilterTime = false;
        }
    }

    public static boolean isValid() {
        return isValid;
    }

    public static synchronized void setValid(boolean valid) {
        if (valid) {
            ConnectionLogger.addLoggerDest((LoggerDest)monitor);
            DefaultApplicationManager.addApplicationMonitor((ApplicationMonitor)monitor);
            KDResultSet.addNextDest((NextDest)monitor);
        } else {
            ConnectionLogger.removeLoggerDest((LoggerDest)monitor);
            DefaultApplicationManager.removeApplicationMonitor((ApplicationMonitor)monitor);
            KDResultSet.removeNextDest((NextDest)monitor);
        }
        isValid = valid;
    }

    public static void startInvokeCount(String method) {
        if (!isValid) {
            return;
        }
        if (isPreOutput) {
            loggerPre.debug((Object)(method + " start"));
        }
        threadSqlVec.set(new Vector());
        Timestamp[] methodTime = new Timestamp[2];
        methodTime[0] = new Timestamp(System.currentTimeMillis());
        threadMethodTime.set(methodTime);
        long[] cpuTime = new long[]{0L, 0L};
        if (threadMX != null && threadMXMethod != null) {
            try {
                cpuTime[0] = (Long)threadMXMethod.invoke(threadMX, null);
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
        threadCPUTime.set(cpuTime);
        long[] gcVec = new long[]{0L, 0L, 0L, 0L};
        threadGC.set(gcVec);
        if (gcMXList != null) {
            try {
                int size = gcMXList.size();
                for (int i = 0; i < size; ++i) {
                    Object gcMX = gcMXList.get(i);
                    gcVec[0] = gcVec[0] + (Long)gcCountMethod.invoke(gcMX, null);
                    gcVec[2] = gcVec[2] + (Long)gcTimeMethod.invoke(gcMX, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public static void endInvokeCount(String method, long invokeTime, String proc_name, String instance_number) {
        if (!isValid) {
            return;
        }
        if (isPreOutput) {
            loggerPre.debug((Object)(method + " end"));
        }
        String thread = Thread.currentThread().getName();
        Vector ksqlVec = (Vector)threadSqlVec.get();
        threadSqlVec.set(null);
        Timestamp[] methodTime = (Timestamp[])threadMethodTime.get();
        threadMethodTime.set(null);
        if (methodTime == null) {
            return;
        }
        methodTime[1] = new Timestamp(System.currentTimeMillis());
        long[] cpuTime = (long[])threadCPUTime.get();
        threadCPUTime.set(null);
        if (threadMX != null && threadMXMethod != null) {
            try {
                cpuTime[1] = (Long)threadMXMethod.invoke(threadMX, null);
            }
            catch (Exception ex) {
                cpuTime[1] = 0L;
                logger.error((Object)ex, (Throwable)ex);
            }
        } else {
            cpuTime[1] = 0L;
        }
        long[] gcVec = (long[])threadGC.get();
        threadGC.set(null);
        if (gcMXList != null) {
            try {
                int size = gcMXList.size();
                for (int i = 0; i < size; ++i) {
                    Object gcMX = gcMXList.get(i);
                    gcVec[1] = gcVec[1] + (Long)gcCountMethod.invoke(gcMX, null);
                    gcVec[3] = gcVec[3] + (Long)gcTimeMethod.invoke(gcMX, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
        if (ksqlVec != null) {
            WorkflowSqlCounter.printKSQL(method, ksqlVec, invokeTime, proc_name, instance_number, methodTime, cpuTime, gcVec);
        }
    }

    private static synchronized void printKSQL(String method, Vector ksqlVec, long invokeTime, String proc_name, String instance_number, Timestamp[] methodTime, long[] cpuTime, long[] gcVec) {
        if (!isValid) {
            return;
        }
        if (!isFilterTime || isFilterTime && invokeTime >= filter_time_threshold) {
            long totalTime = 0L;
            long totalNextTime = 0L;
            long request = 0L;
            long response = 0L;
            long totalLobNum = 0L;
            logger.debug((Object)"");
            logger.debug((Object)(method + " : " + ksqlVec.size() + " times"));
            StringBuffer sbTmp = new StringBuffer();
            sbTmp.append("thread: ");
            sbTmp.append(Thread.currentThread().getName());
            sbTmp.append("  proc_name: ");
            sbTmp.append(proc_name);
            sbTmp.append("  instance_number: ");
            sbTmp.append(instance_number);
            logger.debug((Object)sbTmp.toString());
            sbTmp = new StringBuffer();
            sbTmp.append("==============start sql============== ");
            sbTmp.append(df.format(methodTime[0]));
            logger.debug((Object)sbTmp.toString());
            int addBatchNumber = 0;
            int nextNumber = 0;
            for (int i = 0; i < ksqlVec.size(); ++i) {
                Object tmpItem = ksqlVec.get(i);
                if (tmpItem instanceof LogItem) {
                    LogItem item = (LogItem)tmpItem;
                    if ("KDPreparedStatement.addBatch".equals(item.method) || "Statement.addBatch".equals(item.method)) {
                        ++addBatchNumber;
                    }
                    String line = item.dialect_sql;
                    String sql = "";
                    long sqlBytes = 0L;
                    int sql_id = -1;
                    if (line == null) {
                        sql = item.method;
                        sql_id = item.getSql_id();
                    } else {
                        sql_id = item.getSql_id();
                        sqlBytes = item.bytes;
                        request += sqlBytes;
                        int startIndex = line.indexOf(" FROM ");
                        sql = startIndex >= 100 && line.startsWith("SELECT") ? line.substring(startIndex) : line;
                    }
                    logger.debug((Object)sql);
                    StringBuffer sbRelated = new StringBuffer();
                    sbRelated.append("timespan: ");
                    sbRelated.append(item.timespan);
                    sbRelated.append("  sql_id: ");
                    sbRelated.append(sql_id);
                    if (item.executeTime != null) {
                        sbRelated.append("  startTime: ");
                        sbRelated.append(df.format(item.executeTime));
                    }
                    sbRelated.append("  conn_id: ");
                    sbRelated.append(item.conn_id);
                    sbRelated.append("  bytes: ");
                    sbRelated.append(sqlBytes);
                    if ("KDPreparedStatement.addBatch".equals(item.method) || "Statement.addBatch".equals(item.method) || "KDConnection.prepareStatement".equals(item.method)) {
                        sbRelated.append("  ");
                        sbRelated.append(item.method);
                    }
                    logger.debug((Object)sbRelated.toString());
                    totalTime += item.timespan;
                    continue;
                }
                long[] record = (long[])tmpItem;
                ++nextNumber;
                totalNextTime += record[1];
                response += record[4] * record[3];
                totalLobNum += record[5] * record[3];
                logger.debug((Object)"----------KDResultSet.next");
                StringBuffer sbRelated = new StringBuffer();
                sbRelated.append("timespan: ");
                sbRelated.append(record[1]);
                sbRelated.append("  sql_id: -1  startTime: ");
                Timestamp stamp = new Timestamp(record[2]);
                sbRelated.append(df.format(stamp));
                sbRelated.append("  conn_id: ");
                sbRelated.append(record[0]);
                sbRelated.append("  row: ");
                sbRelated.append(record[3]);
                sbRelated.append("  bytes: ");
                sbRelated.append(record[4] * record[3]);
                sbRelated.append("  lobNum: ");
                sbRelated.append(record[5] * record[3]);
                logger.debug((Object)sbRelated.toString());
            }
            sbTmp = new StringBuffer();
            sbTmp.append("==============end sql============== ");
            sbTmp.append(df.format(methodTime[1]));
            logger.debug((Object)sbTmp.toString());
            sbTmp = new StringBuffer();
            sbTmp.append("dbTime: ");
            sbTmp.append(totalTime + totalNextTime);
            sbTmp.append("  sqlTime: ");
            sbTmp.append(totalTime);
            sbTmp.append("  sqlExeNumber: ");
            sbTmp.append(ksqlVec.size() - addBatchNumber - nextNumber);
            sbTmp.append("  nextTime: ");
            sbTmp.append(totalNextTime);
            sbTmp.append("  nextNumber: ");
            sbTmp.append(nextNumber);
            sbTmp.append("  req: ");
            sbTmp.append(request);
            sbTmp.append("  res: ");
            sbTmp.append(response);
            sbTmp.append("  lobNum: ");
            sbTmp.append(totalLobNum);
            sbTmp.append("  bytes: ");
            sbTmp.append(request + response);
            logger.debug((Object)sbTmp.toString());
            sbTmp = new StringBuffer();
            sbTmp.append("invokeTime: ");
            sbTmp.append(invokeTime);
            sbTmp.append("  cpuTime: ");
            sbTmp.append((cpuTime[1] - cpuTime[0]) / 1000000L);
            sbTmp.append("  gcCount: ");
            sbTmp.append(gcVec[1] - gcVec[0]);
            sbTmp.append("  gcTime: ");
            sbTmp.append(gcVec[3] - gcVec[2]);
            logger.debug((Object)sbTmp.toString());
            logger.debug((Object)"");
        }
        ksqlVec.clear();
    }

    public static void countKSQL(LogItem item) {
        if (!isValid) {
            return;
        }
        Vector ksqlVec = (Vector)threadSqlVec.get();
        if (ksqlVec != null) {
            int vecSize = ksqlVec.size();
            if ((long)vecSize >= filter_vector_threshold) {
                if ((long)vecSize == filter_vector_threshold) {
                    item.dialect_sql = "There are more sqls, but I can't write them in memory!";
                    ksqlVec.add(item);
                }
            } else {
                ksqlVec.add(item);
            }
        }
    }

    public void log(LogItem logitem) {
        if (!isValid) {
            return;
        }
        WorkflowSqlCounter.countKSQL(logitem);
    }

    public static void countNext(long conn_id, long nextTime, long firstNextTime, int row, long length, int lobNum) {
        int vecSize;
        if (!isValid) {
            return;
        }
        Vector ksqlVec = (Vector)threadSqlVec.get();
        long[] nextRecord = new long[]{conn_id, nextTime, firstNextTime, row, length, lobNum};
        if (ksqlVec != null && (long)(vecSize = ksqlVec.size()) < filter_vector_threshold) {
            ksqlVec.add(nextRecord);
        }
    }

    public static boolean isPreOutput() {
        return isPreOutput;
    }

    public static void setPreOutput(boolean isPreOutput) {
        WorkflowSqlCounter.isPreOutput = isPreOutput;
    }

    public void endApplication(String operation, long timespan, String proc_name, String instance_number) {
        WorkflowSqlCounter.endInvokeCount(operation, timespan, proc_name, instance_number);
    }

    public void startApplication(String operation) {
        WorkflowSqlCounter.startInvokeCount(operation);
    }

    public void passNextInfo(int conn_id, long nextTimespan, long firstNextTime, int row, long length, int lobNum) {
        WorkflowSqlCounter.countNext(conn_id, nextTimespan, firstNextTime, row, length, lobNum);
    }
}

