/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.management;

import com.kingdee.bos.management.NotifySupportBuddyListener;
import com.kingdee.util.objbuddy.BuddyEvent;
import com.kingdee.util.objbuddy.LifecycleEvent;
import com.kingdee.util.objbuddy.OperationPerformEvent;
import com.kingdee.util.objbuddy.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;

public class BuddyEventNotificationConvertor {
    private static List convertors = new ArrayList(1);

    private BuddyEventNotificationConvertor() {
    }

    public void registerConvertor(IBuddyEventNotificationConvertor convertor) {
        convertors.add(convertor);
    }

    public static Notification toNotification(NotifySupportBuddyListener listener, BuddyEvent event) {
        for (int i = 0; i < convertors.size(); ++i) {
            IBuddyEventNotificationConvertor conv = (IBuddyEventNotificationConvertor)convertors.get(i);
            Notification n = conv.toNotification(listener, event);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    static {
        convertors.add(new Default());
    }

    private static class Default
    implements IBuddyEventNotificationConvertor {
        private Default() {
        }

        @Override
        public Notification toNotification(NotifySupportBuddyListener listener, BuddyEvent event) {
            if (event instanceof PropertyChangeEvent) {
                PropertyChangeEvent pce = (PropertyChangeEvent)event;
                return new AttributeChangeNotification(listener.getBuddyInstance().getSource().getClass().getName(), listener.getSequenceNumber(), System.currentTimeMillis(), pce.getDescription(), pce.getPropertyName(), pce.getPropertyType(), pce.getOldValue(), pce.getNewValue());
            }
            if (event instanceof OperationPerformEvent) {
                OperationPerformEvent ope = (OperationPerformEvent)event;
                Notification n = new Notification("kingdee.bos.operation.perform", listener.getBuddyInstance().getSource().getClass().getName(), listener.getSequenceNumber(), System.currentTimeMillis(), ope.getDescription());
                n.setUserData(ope.getArgsString());
                return n;
            }
            if (event instanceof LifecycleEvent) {
                return new Notification("kingdee.bos.lifecycle", listener.getBuddyInstance().getSource().getClass().getName(), listener.getSequenceNumber(), System.currentTimeMillis(), event.getDescription());
            }
            return null;
        }
    }

    public static interface IBuddyEventNotificationConvertor {
        public Notification toNotification(NotifySupportBuddyListener var1, BuddyEvent var2);
    }
}

