/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.management;

import com.kingdee.bos.health.managent.HealthAgent;
import com.kingdee.bos.management.CannotCreateMBeanException;
import com.kingdee.bos.management.JMRemoteException;
import com.kingdee.bos.management.MBeanFactory;
import com.kingdee.bos.management.config.MBeanConfigException;
import com.kingdee.util.StringUtils;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;

public class ManagementService {
    private static Logger logger = Logger.getLogger(ManagementService.class);
    private static final int DEFUALT_HTTP_MAX_ACTIVE_CLIENT_COUNT = 10;
    private static final String CONFIG_FILE_NAME = "jmxconnector.properties";
    private static ManagementService instance = null;
    private int jmxHttpAdapterPort = 0;

    private ManagementService() {
    }

    public static synchronized ManagementService getInstance() {
        if (instance == null) {
            instance = new ManagementService();
        }
        return instance;
    }

    public void startup() {
        Properties props = this.loadConfig();
        int rmiPort = this.parseConfig(props, "rmi.port", 0);
        int httpPort = this.parseConfig(props, "http.port", 0);
        int maxActiveClientCount = this.parseConfig(props, "http.maxActiveClientCount", 10);
        if (rmiPort > 0) {
            this.startRMIAdaptor(rmiPort, props);
        } else if (httpPort >= 2000) {
            rmiPort = httpPort - 1000;
            this.startRMIAdaptor(rmiPort, props);
        }
        if (httpPort >= 0) {
            this.startHtmlAdaptor(httpPort, maxActiveClientCount, props);
        }
        MBeanFactory.createAutoStartMBeans();
    }

    public int getHttpAdaptorPort() {
        return this.jmxHttpAdapterPort;
    }

    private Properties loadConfig() throws MBeanConfigException {
        InputStream is = null;
        try {
            Properties props = new Properties();
            File configFile = new File(this.getConfigFileName());
            if (configFile.exists()) {
                is = new FileInputStream(configFile);
                props.load(is);
            }
            Properties properties = props;
            return properties;
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage(), (Throwable)ioe);
            throw new MBeanConfigException(ioe.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getConfigFileName() {
        String fileName = System.getProperty(CONFIG_FILE_NAME);
        if (!StringUtils.isEmpty((String)fileName)) {
            return fileName;
        }
        String bosConfigFile = System.getProperty("bos.config");
        if (!StringUtils.isEmpty((String)bosConfigFile)) {
            int index;
            if (File.separatorChar != '/') {
                bosConfigFile = bosConfigFile.replace('/', File.separatorChar);
            }
            if ((index = bosConfigFile.lastIndexOf(File.separatorChar)) >= 0) {
                return bosConfigFile.substring(0, index + 1) + CONFIG_FILE_NAME;
            }
        }
        return CONFIG_FILE_NAME;
    }

    private int parseConfig(Properties props, String key, int defaultValue) {
        String str = props.getProperty(key);
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException _ex) {
            logger.info((Object)("invalid config of jmxconnector.properties#" + key + ", using defualt config value."));
            return defaultValue;
        }
    }

    public void startRMIAdaptor(int rmiPort, Properties props) throws JMRemoteException {
        try {
            HealthAgent.registerServerMBean((int)rmiPort, (Properties)props);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void startHtmlAdaptor(int httpPort, int maxActiveClientCount, Properties props) throws CannotCreateMBeanException {
        try {
            MBeanServer mbs = MBeanFactory.MBEAN_SERVER;
            ObjectName objName = new ObjectName("Adaptor:type=html");
            HtmlAdaptorServer server = new HtmlAdaptorServer();
            String user = props.getProperty("user", "admin");
            String password = props.getProperty("password", "EASadmin$268");
            server.addUserAuthenticationInfo(new AuthInfo(user, password));
            mbs.registerMBean(server, objName);
            mbs.setAttribute(objName, new Attribute("MaxActiveClientCount", maxActiveClientCount));
            mbs.setAttribute(objName, new Attribute("Port", httpPort));
            mbs.invoke(objName, "start", null, null);
            if (httpPort == 0) {
                Field sockListenField = HtmlAdaptorServer.class.getDeclaredField("sockListen");
                sockListenField.setAccessible(true);
                long startTime = System.currentTimeMillis();
                while (!server.isActive() && System.currentTimeMillis() - startTime < 50000L) {
                    Thread.sleep(100L);
                }
                ServerSocket sockListen = (ServerSocket)sockListenField.get(server);
                this.jmxHttpAdapterPort = sockListen.getLocalPort();
            } else {
                this.jmxHttpAdapterPort = httpPort;
            }
        }
        catch (Exception e) {
            if (e instanceof ReflectionException) {
                logger.error((Object)((ReflectionException)e).getTargetException());
            }
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new CannotCreateMBeanException(e.getMessage());
        }
    }
}

