/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.management.config;

import com.kingdee.bos.management.MBeanMetadata;
import com.kingdee.bos.management.config.MBeanConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractMBeanConfig
implements MBeanConfig {
    protected abstract Map getMBeanMetadatas();

    @Override
    public MBeanMetadata getMBeanMetadata(String beanId) {
        return (MBeanMetadata)this.getMBeanMetadatas().get(beanId);
    }

    @Override
    public String[] getAutoStartMBeans() {
        return this.getMBeansByFilter(new MBeanFilter(){

            @Override
            public boolean match(MBeanMetadata md) {
                return md.isAutoStart();
            }
        });
    }

    @Override
    public String[] getAllMBeans() {
        return this.getMBeansByFilter(new MBeanFilter(){

            @Override
            public boolean match(MBeanMetadata md) {
                return true;
            }
        });
    }

    @Override
    public String[] getMBeansByType(final String type) {
        assert (type != null && type.length() > 0);
        return this.getMBeansByFilter(new MBeanFilter(){

            @Override
            public boolean match(MBeanMetadata md) {
                return type.equals(md.getType());
            }
        });
    }

    @Override
    public String[] getMBeansByClassName(final String className) {
        assert (className != null && className.length() > 0);
        return this.getMBeansByFilter(new MBeanFilter(){

            @Override
            public boolean match(MBeanMetadata md) {
                return className.equals(md.getClassName());
            }
        });
    }

    private String[] getMBeansByFilter(MBeanFilter filter) {
        ArrayList<String> list = new ArrayList<String>();
        Map mdMap = this.getMBeanMetadatas();
        Iterator iter = mdMap.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String name = (String)iter.next();
            MBeanMetadata md = (MBeanMetadata)mdMap.get(name);
            if (filter.match(md)) {
                list.add(name);
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    private static interface MBeanFilter {
        public boolean match(MBeanMetadata var1);
    }
}

