/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.management.config;

import com.kingdee.bos.management.MBeanMetadata;
import com.kingdee.bos.management.config.AbstractMBeanConfig;
import com.kingdee.bos.management.config.MBeanConfigException;
import com.kingdee.bos.management.config.MBeanMetadataImpl;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import com.kingdee.util.objbuddy.BuddyObjectRegistry;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MBeanConfigImpl
extends AbstractMBeanConfig {
    private Map mds = this.buildMetadataMap();
    private static final String CLASSNAME_PREFIX = "com.kingdee.bos.";
    private static final String DOMAIN_PREFIX = "kingdee.bos.";
    private static final String CONFIG_FILENAME = "mbeans.properties";
    private static final String SP_CONFIG_FILENAME = "sp_mbeans.properties";

    @Override
    protected synchronized Map getMBeanMetadatas() throws MBeanConfigException {
        return this.mds;
    }

    private Map buildMetadataMap() {
        ConfigurationItem item;
        int i;
        List mbeanMDs;
        XMLConfiguration conf;
        HashMap<String, MBeanMetadata> mbeanMd = new HashMap<String, MBeanMetadata>();
        URL url = this.getClass().getResource(CONFIG_FILENAME);
        if (url != null) {
            conf = XMLConfiguration.getInstance((URL)url);
            mbeanMDs = conf.getConfigItemList();
            for (i = 0; i < mbeanMDs.size(); ++i) {
                item = (ConfigurationItem)mbeanMDs.get(i);
                mbeanMd.put(item.getName(), this.buildMD(item));
            }
        }
        if ((url = this.getClass().getResource(SP_CONFIG_FILENAME)) != null) {
            conf = XMLConfiguration.getInstance((URL)url);
            mbeanMDs = conf.getConfigItemList();
            for (i = 0; i < mbeanMDs.size(); ++i) {
                item = (ConfigurationItem)mbeanMDs.get(i);
                mbeanMd.put(item.getName(), this.buildMD(item));
            }
        }
        return mbeanMd;
    }

    private MBeanMetadata buildMD(ConfigurationItem item) {
        String buddy;
        String mbeanId = item.getName();
        int lastDotPos = mbeanId.lastIndexOf(46);
        boolean maybeDefault = lastDotPos != -1 && lastDotPos != mbeanId.length() - 1;
        String className = item.getProperty("className");
        if (maybeDefault && StringUtils.isEmpty((String)className)) {
            className = CLASSNAME_PREFIX + mbeanId;
        }
        String domain = item.getProperty("domain");
        if (maybeDefault && StringUtils.isEmpty((String)domain)) {
            domain = DOMAIN_PREFIX + mbeanId.substring(0, lastDotPos);
        }
        String name = item.getProperty("name");
        if (maybeDefault && StringUtils.isEmpty((String)name)) {
            name = mbeanId.substring(lastDotPos + 1);
        }
        String type = item.getProperty("type");
        boolean autoStart = Boolean.valueOf(item.getProperty("autoStart"));
        if (!autoStart && !StringUtils.isEmpty((String)(buddy = item.getProperty("buddy")))) {
            BuddyObjectRegistry.regisiterObjectBuddy((String)buddy, (String)className);
        }
        return new MBeanMetadataImpl(className, domain, name, type, autoStart);
    }
}

