/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.management.util;

import com.kingdee.bos.management.util.MBeanDataException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;

public class CompositeDataBuilder {
    private final String typeName;
    private final String typeDescription;
    private final List values;
    private static final SimpleType[] simpleTypeArray = new SimpleType[]{SimpleType.VOID, SimpleType.BOOLEAN, SimpleType.CHARACTER, SimpleType.BYTE, SimpleType.SHORT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.FLOAT, SimpleType.DOUBLE, SimpleType.STRING, SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.DATE, SimpleType.OBJECTNAME};
    static Map simpleTypeMap = new HashMap(simpleTypeArray.length);

    public CompositeDataBuilder(String typeName, String typeDescription) {
        this.typeName = typeName;
        this.typeDescription = typeDescription;
        this.values = new ArrayList();
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void addValue(Map values) {
        for (String key : values.keySet()) {
            Object val = values.get(key);
            this.addValue(key, val);
        }
    }

    public void addValue(String name, Object value) {
        assert (name != null && name.length() > 0);
        if (value == null) {
            return;
        }
        this.addValue(name, name, this.getOpenType(value), value);
    }

    public void addValue(String name, String description, String value) {
        this.addValue(name, description, SimpleType.STRING, value);
    }

    public void addValue(String name, String description, OpenType type, Object value) {
        this.values.add(new CompositeDataValue(name, description, type, value));
    }

    public CompositeType getCompositeType() {
        int n = this.values.size();
        String[] itemNames = new String[n];
        String[] itemDescriptions = new String[n];
        OpenType[] itemTypes = new OpenType[n];
        for (int i = 0; i < n; ++i) {
            CompositeDataValue value = (CompositeDataValue)this.values.get(i);
            itemNames[i] = value.name;
            itemDescriptions[i] = value.description;
            itemTypes[i] = value.type;
        }
        try {
            return new CompositeType(this.typeName, this.typeDescription, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException ode) {
            throw new MBeanDataException(ode.getMessage());
        }
    }

    public CompositeData toCompositeData() {
        int n = this.values.size();
        Object[] itemValues = new Object[n];
        String[] itemNames = new String[n];
        for (int i = 0; i < n; ++i) {
            CompositeDataValue value = (CompositeDataValue)this.values.get(i);
            itemNames[i] = value.name;
            itemValues[i] = value.value;
        }
        CompositeType type = this.getCompositeType();
        try {
            return new CompositeDataSupport(type, itemNames, itemValues);
        }
        catch (OpenDataException ode) {
            throw new MBeanDataException(ode.getMessage());
        }
    }

    private final OpenType getOpenType(Object obj) {
        assert (obj != null);
        if (obj instanceof CompositeData) {
            return ((CompositeData)obj).getCompositeType();
        }
        if (obj instanceof TabularData) {
            return ((TabularData)obj).getTabularType();
        }
        String className = obj.getClass().getName();
        int n = 0;
        while (className.startsWith("[", n)) {
            ++n;
        }
        if (n > 0) {
            className = className.substring(n + 1, className.length() - 1);
        }
        OpenType type = (OpenType)simpleTypeMap.get(className);
        if (n > 0 && type != null) {
            try {
                return new ArrayType(n, type);
            }
            catch (OpenDataException ode) {
                throw new MBeanDataException(ode.getMessage());
            }
        }
        return type;
    }

    static {
        for (int i = 0; i < simpleTypeArray.length; ++i) {
            simpleTypeMap.put(simpleTypeArray[i].getClassName(), simpleTypeArray[i]);
        }
    }

    private class CompositeDataValue {
        String name;
        String description;
        OpenType type;
        Object value;

        public CompositeDataValue(String name, String description, OpenType type, Object value) {
            assert (name != null && name.length() > 0);
            this.name = name;
            this.description = description;
            if (type != null) {
                this.type = type;
                this.value = value;
            } else {
                this.type = SimpleType.STRING;
                this.value = value == null ? null : value.toString();
            }
        }
    }
}

