/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.jmx;

import com.kingdee.bos.rpc.performance.MaxInvokeMonitor;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.bos.rpc.performance.PerformanceValue;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public class PerformanceService
implements DynamicMBean {
    private MaxInvokeMonitor invokeMonitor = null;

    public synchronized void startInvokeMonitor() {
        if (this.invokeMonitor == null) {
            this.invokeMonitor = new MaxInvokeMonitor();
            this.invokeMonitor.install();
        }
    }

    public synchronized void stopInvokeMonitor() {
        if (this.invokeMonitor != null) {
            this.invokeMonitor.restore();
            this.invokeMonitor = null;
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        PerformanceValue value = PerformanceManager.getValue((String)attribute);
        if (value == null) {
            throw new AttributeNotFoundException(attribute);
        }
        return value.value();
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList l = new AttributeList();
        PerformanceValue[] vs = PerformanceManager.getValues((String[])attributes);
        for (int i = 0; i < vs.length; ++i) {
            if (vs[i] == null) continue;
            l.add(new Attribute(vs[i].name(), vs[i].value()));
        }
        return l;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        PerformanceValue[] pvs = PerformanceManager.getValues();
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[pvs.length];
        for (int i = 0; i < attrs.length; ++i) {
            PerformanceValue v = pvs[i];
            attrs[i] = new MBeanAttributeInfo(v.name(), v.type().getName(), v.name(), true, false, false);
        }
        return new MBeanInfo(PerformanceService.class.getName(), "RPC Performance Monitor", attrs, null, null, null);
    }

    @Override
    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }
}

