/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.vm.management;

import com.kingdee.bos.vm.management.RuntimeMBean;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Runtime
implements RuntimeMBean {
    @Override
    public String getVmName() {
        return System.getProperty("java.vm.name");
    }

    @Override
    public String getVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    public String getVmVersion() {
        return System.getProperty("java.vm.version");
    }

    @Override
    public String getSpecName() {
        return System.getProperty("java.vm.specification.name");
    }

    @Override
    public String getSpecVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    @Override
    public String getSpecVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    @Override
    public String getClassPath() {
        return System.getProperty("java.class.path");
    }

    @Override
    public String[] getClassPaths() {
        return this.getClassPath().split(";");
    }

    @Override
    public String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    @Override
    public String[] getLibraryPaths() {
        return this.getLibraryPath().split(";");
    }

    @Override
    public String[] getProperties() {
        Properties props = System.getProperties();
        String[] arrStr = new String[props.size()];
        Enumeration<Object> e = props.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = props.getProperty(key);
            arrStr[i] = key + "=" + val;
            ++i;
        }
        return arrStr;
    }

    @Override
    public String[] getPropertyNames() {
        return System.getProperties().keySet().toArray(new String[0]);
    }

    @Override
    public String getProperty(String key) {
        return System.getProperty(key);
    }

    @Override
    public void setProperty(String key, String value) {
        System.setProperty(key, value);
    }

    @Override
    public String getClassURL(String className) {
        String url = null;
        try {
            Class<?> clazz = Class.forName(className);
            url = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (ClassNotFoundException cnfe) {
            url = cnfe.getMessage();
        }
        return url;
    }

    @Override
    public int getEASActiveThreadCount() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Set<Thread> set = map.keySet();
        StackTraceElement[] e = null;
        int threadCount = 0;
        for (Thread t : set) {
            e = map.get(t);
            if (e.length <= 20) continue;
            ++threadCount;
        }
        return threadCount;
    }
}

