/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.recycle;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.workflow.enactment.recycle.TableRecycleInfo;
import com.kingdee.bos.workflow.enactment.recycle.TimeInfo;
import com.kingdee.bos.workflow.enactment.recycle.WfRecycleMange;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class WfRecycelThread
extends Thread {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.recycle.WfRecycelThread");
    WfRecycleMange wfRecycleMange;
    private List<Context> ailsList = new ArrayList<Context>();
    private ORMServiceLocation osl;
    private int date = -1;
    public String dMessage = "";

    public WfRecycelThread(WfRecycleMange wfRecycleMange) {
        super("WfRecycelThread");
        this.wfRecycleMange = wfRecycleMange;
        this.reloadDCConfig();
    }

    public void reloadDCConfig() {
        try {
            this.ailsList.clear();
            ArrayList list = DCManager.getInstance().getDCList();
            for (DCInfo info : list) {
                Context ctx = new Context(null, info.getSolutionName(), info.getNumber(), null);
                ctx.setUserName(info.getUserName());
                ctx.put((Object)"dbtype", (Object)info.getDBType());
                this.ailsList.add(ctx);
            }
            this.osl = new ORMServiceLocation("Workflow");
        }
        catch (Exception ex) {
            logger.error((Object)"clean workflow data Error, context initialized error", (Throwable)ex);
        }
    }

    @Override
    public void run() {
        if (!this.isMaster()) {
            this.wfRecycleMange.setMessage("Current instance is slave instance and wfRecycle must working on master.");
            return;
        }
        while (true) {
            if (!this.wfRecycleMange.getStop()) {
                Date day = new Date();
                this.configWhenNewDay(day);
                int hour = this.getHour(day);
                if (this.isRunningTime(hour)) {
                    this.recycelWorkFlowData();
                } else {
                    this.wfRecycleMange.setMessage("the wfRecycle is been sleepping time.Run time between " + this.wfRecycleMange.getRunBeginClock() + " to " + this.wfRecycleMange.getRunEndClock());
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                this.wfRecycleMange.setMessage("the wfRecycle has been stopped.");
            }
            try {
                Thread.sleep(this.wfRecycleMange.getInterval() * 1000 + 10);
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
                continue;
            }
            break;
        }
    }

    private void configWhenNewDay(Date day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        if (this.date != calendar.get(6)) {
            this.date = calendar.get(6);
            this.reloadDCConfig();
            TableRecycleInfo.clear();
        }
    }

    private boolean isRunningTime(int hour) {
        if (this.wfRecycleMange.getRunBeginClock() == 0 && this.wfRecycleMange.getRunEndClock() == 0) {
            return true;
        }
        if (this.wfRecycleMange.getRunBeginClock() <= hour && this.wfRecycleMange.getRunEndClock() >= hour) {
            return true;
        }
        return this.wfRecycleMange.getRunBeginClock() > this.wfRecycleMange.getRunEndClock() && (this.wfRecycleMange.getRunBeginClock() <= hour || this.wfRecycleMange.getRunEndClock() >= hour);
    }

    private int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycelWorkFlowData() {
        TableRecycleInfo tableRecycle;
        ArrayList<Context> tList = new ArrayList<Context>(this.ailsList.size());
        boolean needRecycle = false;
        for (Context ctx : this.ailsList) {
            tList.add(ctx);
            tableRecycle = TableRecycleInfo.getInstance(ctx.getAIS());
            if (tableRecycle.isEmpty()) continue;
            needRecycle = true;
        }
        if (!needRecycle) {
            return;
        }
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (Context ctx : tList) {
            tableRecycle = TableRecycleInfo.getInstance(ctx.getAIS());
            if (tableRecycle.isEmpty()) continue;
            Connection con = null;
            try {
                try {
                    con = EJBFactory.getConnection((Context)ctx);
                }
                catch (SQLException e) {
                    this.ailsList.remove(ctx);
                    this.wfRecycleMange.addMessage(" Connected failed of datasource " + ctx.getAIS() + " . ");
                    throw e;
                }
                con.setAutoCommit(false);
                this.recycelWorkFlowTable(con, ctx.getAIS());
                this.dMessage = TimeInfo.toStrings();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                if (con == null) continue;
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void recycelWorkFlowTable(Connection con, String ais) {
        String sql = "delete T_WFR_PROCESSINSTLOG where fid in ( select top " + this.wfRecycleMange.getNumberOfPerRecycle() + " fid   FROM T_WFR_PROCESSINSTLOG wrid WHERE EXISTS (          SELECT fprocinstid            FROM t_wfr_procinst pid           WHERE (fstate = 'closed.completed' OR fstate = 'closed.aborted')             AND pid.fprocinstid = wrid.FPROCESSINSTID) and ? > -1 ) ";
        this.executeSql(con, sql, "T_WFR_PROCESSINSTLOG", ais);
        sql = "delete T_WFR_SSCLOG where fid in ( select top " + this.wfRecycleMange.getNumberOfPerRecycle() + " fid   from T_WFR_SSCLOG  where DATEDIFF(DD, FCREATETIME,NOW()) >= ?)";
        this.executeSql(con, sql, "T_WFR_SSCLOG", ais);
        sql = "delete T_WFR_SSCLOGHST where fid in ( select top " + this.wfRecycleMange.getNumberOfPerRecycle() + " fid   from T_WFR_SSCLOGHST  where DATEDIFF(DD, FCREATETIME,NOW()) >= ?)";
        this.executeSql(con, sql, "T_WFR_SSCLOGHST", ais);
        sql = "delete T_WFR_ENGINELOG where fid in ( select top " + this.wfRecycleMange.getNumberOfPerRecycle() + " fid   from T_WFR_ENGINELOG  where DATEDIFF(DD, ftime,NOW()) >= ?)";
        this.executeSql(con, sql, "T_WFR_ENGINELOG", ais);
        sql = "delete T_WFR_BIZRECORD where fid in ( select top " + this.wfRecycleMange.getNumberOfPerRecycle() + " fid   from T_WFR_BIZRECORD  where DATEDIFF(DD, FSTARTTIME ,NOW()) >= 30 and ? > -1)";
        this.executeSql(con, sql, "T_WFR_BIZRECORD", ais);
        try {
            con.close();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(Connection con, String sql, String table, String ais) {
        TableRecycleInfo tableRecycle = TableRecycleInfo.getInstance(ais);
        if (!tableRecycle.hasTable(table)) {
            return;
        }
        PreparedStatement ps = null;
        try {
            TimeInfo.getInstance(table + "_" + ais).begin();
            ps = con.prepareStatement(sql);
            ps.setInt(1, this.wfRecycleMange.getDaysOfBeforeToClear());
            int countOfdelete = ps.executeUpdate();
            con.commit();
            if (countOfdelete < this.wfRecycleMange.getNumberOfPerRecycle()) {
                tableRecycle.removeTable(table);
            }
            TimeInfo.getInstance(table + "_" + ais).addRemoveNumber(countOfdelete);
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            logger.error((Object)("error sql for recycel workflow data: " + sql));
            logger.error((Object)e);
            tableRecycle.removeTable(table);
        }
        finally {
            TimeInfo.getInstance(table + "_" + ais).end();
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private boolean isMaster() {
        return this.osl.isLocal();
    }
}

