/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.util;

import com.kingdee.bos.management.util.CompositeDataBuilder;
import com.kingdee.bos.management.util.MBeanDataException;
import com.kingdee.bos.workflow.enactment.util.IDubiousValueStringParser;
import com.kingdee.util.BeanWrapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.log4j.Logger;

public class BeanTabularDataBuilder {
    protected final String typeName;
    protected final String typeDescription;
    protected final Object[] beans;
    protected String[] tabularIndexNames;
    protected final Set dubiousOpenTypePropertyNames;
    private static final Logger logger = Logger.getLogger(BeanTabularDataBuilder.class);
    protected IDubiousValueStringParser parser = null;

    public BeanTabularDataBuilder(String typeName, String typeDescription, Object[] beans, String[] tabularIndexNames) {
        assert (beans != null && beans.length > 0);
        this.typeName = typeName;
        this.typeDescription = typeDescription;
        this.beans = beans;
        this.tabularIndexNames = tabularIndexNames;
        this.dubiousOpenTypePropertyNames = new HashSet();
    }

    public BeanTabularDataBuilder(String typeName, String typeDescription, Object[] beans) {
        this(typeName, typeDescription, beans, null);
    }

    public void setTabularIndexNames(String[] tabularIndexNames) {
        this.tabularIndexNames = tabularIndexNames;
    }

    public TabularData toTabularData() {
        this.processDubiousOpenTypeProperty();
        try {
            CompositeData[] compositeDatas = new CompositeData[this.beans.length];
            TabularDataSupport tabularDataSupport = null;
            int size = this.beans.length;
            for (int i = 0; i < size; ++i) {
                CompositeDataBuilder builder = new CompositeDataBuilder(this.typeName, this.typeDescription);
                Map map = new BeanWrapper(this.beans[i]).toMap();
                for (Map.Entry entry : map.entrySet()) {
                    if (this.dubiousOpenTypePropertyNames.contains(entry.getKey())) {
                        builder.addValue((String)entry.getKey(), entry.getValue() == null ? " unknown" : this.parseDubiousValue(entry.getValue()));
                        continue;
                    }
                    builder.addValue((String)entry.getKey(), entry.getValue());
                }
                compositeDatas[i] = builder.toCompositeData();
                if (tabularDataSupport == null) {
                    TabularType type = new TabularType(this.typeName, this.typeDescription, compositeDatas[i].getCompositeType(), this.tabularIndexNames);
                    tabularDataSupport = new TabularDataSupport(type);
                }
                tabularDataSupport.put(compositeDatas[i]);
            }
            return tabularDataSupport;
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new MBeanDataException(e.getMessage());
        }
    }

    private void processDubiousOpenTypeProperty() {
        int size = this.beans.length;
        for (int i = 0; i < size; ++i) {
            Map map = new BeanWrapper(this.beans[i]).toMap();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() != null) continue;
                this.dubiousOpenTypePropertyNames.add(entry.getKey());
            }
        }
    }

    protected String parseDubiousValue(Object object) {
        if (this.parser != null) {
            return this.parser.parse(object);
        }
        return object.toString();
    }

    public void setDubiousValueStringParser(IDubiousValueStringParser parser) {
        this.parser = parser;
    }
}

