/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.service.message.agent.MessageServiceThreadPool;
import com.kingdee.bos.service.message.agent.ReceiverAgent;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class BOSMessageService
implements ServletContextListener {
    public static String SERVICE_TYPE_DIRECT = "Direct";
    public static String SERVICE_TYPE_JMS = "JMS";
    public static String SERVICE_TYPE_JMS_CACHE = "JMS_Cahce";
    private static String serviceType = SERVICE_TYPE_DIRECT;
    static MessageServiceThreadPool threadPool = null;
    public static final int DEFAULT_REDELIVER_MAXTIMES = 5;
    ReceiverAgent receiverAgent;
    SenderAgent senderAgent;
    boolean isLoadEjbOnEASStart = true;
    private int maxThread = 50;
    private int minThread = 10;
    private int idleTimeout = 1000;
    static int messageRedeliverMaxTimes = 5;
    private final IBuddyObject buddy;
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.message.agent.BOSMessageService");

    public BOSMessageService() {
        ConfigurationItem threadPoolCfgItem;
        ConfigurationItem msgcfgItem;
        String nonejb;
        Configuration config = Configuration.getInstance();
        ConfigurationItem cfgItem = config.getConfigItemByPath("DebugOptions");
        if (cfgItem != null && "true".equals(nonejb = cfgItem.getProperty("nonejb"))) {
            String serverType;
            this.isLoadEjbOnEASStart = false;
            ConfigurationItem cfgItem2 = config.getConfigItemByPath("AppServer");
            if (cfgItem2 != null && "websphere".equalsIgnoreCase(serverType = cfgItem2.getProperty("type"))) {
                this.isLoadEjbOnEASStart = true;
            }
        }
        if ((msgcfgItem = config.getConfigItemByPath("MessageService")) != null) {
            String sMessageRedeliverMaxTimes;
            String _serviceType = msgcfgItem.getProperty("serviceType");
            if (!StringUtils.isEmpty((String)_serviceType)) {
                serviceType = _serviceType;
            }
            if ((sMessageRedeliverMaxTimes = msgcfgItem.getProperty("messageRedeliverMaxTimes")) != null) {
                try {
                    messageRedeliverMaxTimes = Integer.parseInt(sMessageRedeliverMaxTimes);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (SERVICE_TYPE_DIRECT.equals(serviceType)) {
            this.isLoadEjbOnEASStart = true;
        }
        if ((threadPoolCfgItem = config.getConfigItemByPath("MessageService/ThreadPool")) != null) {
            String sIdleTimeout;
            String minSize;
            String maxSize = threadPoolCfgItem.getProperty("maxSize");
            if (maxSize != null) {
                try {
                    this.maxThread = Integer.parseInt(maxSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((minSize = threadPoolCfgItem.getProperty("minSize")) != null) {
                try {
                    this.minThread = Integer.parseInt(minSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((sIdleTimeout = threadPoolCfgItem.getProperty("idleTimeout")) != null) {
                try {
                    this.idleTimeout = Integer.parseInt(sIdleTimeout);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.buddy = BuddyObjectFactory.getInstance((Object)this);
    }

    public void contextInitialized(ServletContextEvent event) {
        this.buddy.initialize();
        this.start();
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.stop();
        this.buddy.terminate();
    }

    public synchronized void start() {
        threadPool = new MessageServiceThreadPool(this.maxThread, this.minThread, this.idleTimeout);
        if (SERVICE_TYPE_DIRECT.equals(serviceType)) {
            this.isLoadEjbOnEASStart = true;
        }
        if (!this.isLoadEjbOnEASStart) {
            logger.info((Object)"BOS Message Service will load ReceiverAgent.");
            this.receiverAgent = ReceiverAgent.getReceiverAgent();
            this.receiverAgent.start();
        }
        this.senderAgent = SenderAgent.getSenderAgent();
        this.senderAgent.start();
        logger.info((Object)("BOS Message Service started for " + serviceType));
        this.buddy.operationPerformed("start");
    }

    public synchronized void stop() {
        this.senderAgent.stop();
        threadPool.shutDown();
        threadPool = null;
        if (!this.isLoadEjbOnEASStart) {
            this.receiverAgent.stop();
        }
        logger.info((Object)"BOS Message Service stoped ");
        this.buddy.operationPerformed("stop");
    }

    static String getServiceType() {
        return serviceType;
    }

    static void setServiceType(String type) {
        serviceType = type;
    }

    public static int getMessageRedeliverMaxTimes() {
        return messageRedeliverMaxTimes;
    }

    public static MessageServiceThreadPool getMessageTheadPool() {
        return threadPool;
    }
}

