/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.agent.BOSMessageService;
import com.kingdee.bos.service.message.agent.ListenerInfo;
import com.kingdee.bos.service.message.agent.ListenerManager;
import com.kingdee.bos.service.message.agent.ReceiverAgent;

public class DirectReceiverAgent
extends ReceiverAgent {
    private int state = 0;
    private ListenerManager listeners;

    private void dispatch(Message bosMsg) {
        String listenerDomain = null;
        String senderDomain = bosMsg.getDomian();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListenerInfo listenInfo = this.listeners.get(i);
            listenerDomain = listenInfo.doamin;
            if (listenerDomain == null || senderDomain == null) continue;
            MessageListener listener = listenInfo.listener;
            if (listenerDomain.length() == 0) {
                this.newMsgListenerThread(listener, bosMsg);
                continue;
            }
            if (!senderDomain.startsWith(listenerDomain)) continue;
            if (senderDomain.length() == listenerDomain.length()) {
                this.newMsgListenerThread(listener, bosMsg);
                continue;
            }
            if (senderDomain.charAt(listenerDomain.length()) != '.') continue;
            this.newMsgListenerThread(listener, bosMsg);
        }
    }

    private void newMsgListenerThread(final MessageListener listener, final Message bosMsg) {
        if (BOSMessageService.getMessageTheadPool() != null) {
            BOSMessageService.getMessageTheadPool().startThread(new Runnable(){

                @Override
                public void run() {
                    listener.onMessage(bosMsg);
                }
            });
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    listener.onMessage(bosMsg);
                }
            }).start();
        }
    }

    @Override
    public int onMessage(Message message) {
        this.dispatch(message);
        return 1;
    }

    @Override
    public void start() {
        if (this.state == 1) {
            return;
        }
        this.state = 1;
    }

    @Override
    public void stop() {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    protected void init() {
        this.listeners = new ListenerManager();
        this.listeners.loadListeners();
    }
}

