/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.agent.ListenerInfo;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ListenerManager {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.agent.ListenerManager");
    private ArrayList listeners = new ArrayList();
    private boolean bLoaded = false;

    public int size() {
        return this.listeners.size();
    }

    public ListenerInfo get(int i) {
        return (ListenerInfo)this.listeners.get(i);
    }

    public void loadListeners() {
        if (this.bLoaded) {
            return;
        }
        ConfigurationItem config = Configuration.getInstance().getConfigItemByPath("MessageService/listeners");
        if (config == null) {
            log.error((Object)"MessageService Listeners Configuration error!");
            return;
        }
        List listenerConfigs = config.getAllChildren();
        for (int i = 0; i < listenerConfigs.size(); ++i) {
            ConfigurationItem item = (ConfigurationItem)listenerConfigs.get(i);
            String name = item.getProperty("name");
            String className = item.getProperty("class");
            String domamin = item.getProperty("domain");
            String filter = item.getProperty("filter");
            if (className == null || className.length() == 0) continue;
            MessageListener messageListener = null;
            try {
                Class<?> listenerClass = Class.forName(className);
                messageListener = (MessageListener)listenerClass.newInstance();
            }
            catch (IllegalAccessException ex) {
                log.error((Object)"cannot laod listener class!", (Throwable)ex);
            }
            catch (InstantiationException ex) {
                log.error((Object)"cannot laod listener class!", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                log.error((Object)"cannot laod listener class!", (Throwable)ex);
            }
            catch (Throwable ex) {
                log.error((Object)"cannot laod listener class!", ex);
            }
            if (messageListener == null) continue;
            ListenerInfo listener = new ListenerInfo(name, domamin, filter, messageListener);
            if (!this.listeners.contains(listener)) {
                log.debug((Object)("load listener " + className));
                this.listeners.add(listener);
                continue;
            }
            log.warn((Object)("listener " + className + " already loaded,ingnore it!"));
        }
        this.bLoaded = true;
    }

    public void reloadListeners() {
        this.listeners.clear();
        this.bLoaded = false;
        this.loadListeners();
    }

    public void clear() {
        this.listeners.clear();
    }
}

