/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MessageServiceThreadPool {
    static final Logger logger = Logger.getLogger(MessageServiceThreadPool.class);
    private int maxSize = 20;
    private int minSize = 10;
    private long idleTimeout = 500L;
    private final ArrayList pool = new ArrayList();
    private long workId = 1L;
    private int activeCount = 0;

    public MessageServiceThreadPool() {
    }

    public MessageServiceThreadPool(int maxSize, int minSize, long idleTimeout) {
        this.maxSize = maxSize;
        this.minSize = minSize;
        this.idleTimeout = idleTimeout;
        this.activeCount = 0;
    }

    private synchronized void decreaseCount() {
        --this.activeCount;
    }

    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    public synchronized long getIdleTimeout() {
        return this.idleTimeout;
    }

    public synchronized void setParameters(int maxSize, long idleTimeout) {
        this.maxSize = maxSize;
        this.idleTimeout = idleTimeout;
    }

    public synchronized int getMinSize() {
        return this.minSize;
    }

    public synchronized int getActiveCount() {
        return this.activeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThread(Runnable runner) {
        Worker worker = null;
        MessageServiceThreadPool messageServiceThreadPool = this;
        synchronized (messageServiceThreadPool) {
            while (this.activeCount >= this.maxSize) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MessageServiceThread count :" + this.activeCount + "-" + this.maxSize));
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (this.pool.size() == 0) {
                ++this.activeCount;
                new Worker("MessageServiceThread - " + this.workId++ + "-" + this.activeCount, runner).start();
            } else {
                ++this.activeCount;
                worker = (Worker)this.pool.remove(this.pool.size() - 1);
            }
        }
        if (worker != null) {
            worker.startWork(runner);
        }
    }

    synchronized void notifyFree(Worker worker) {
        this.pool.add(worker);
    }

    synchronized boolean notifyTimeout(Worker worker) {
        if (this.pool.size() <= this.minSize) {
            return false;
        }
        this.removeWorker(worker);
        return true;
    }

    synchronized void removeWorker(Worker worker) {
        this.pool.remove(worker);
        worker = null;
    }

    synchronized void shutDown() {
    }

    private class Worker
    extends Thread {
        private final Object monitor;
        Runnable runner;
        boolean interrupted;

        Worker(String name, Runnable runner) {
            super(name);
            this.monitor = new Object();
            this.interrupted = false;
            this.setDaemon(true);
            this.runner = runner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: while (this.runner != null) {
                try {
                    this.runner.run();
                }
                catch (Throwable e) {
                    this.runner = null;
                    logger.error((Object)e, e);
                    break;
                }
                finally {
                    MessageServiceThreadPool.this.decreaseCount();
                }
                this.runner = null;
                MessageServiceThreadPool.this.notifyFree(this);
                while (true) {
                    Object object = this.monitor;
                    synchronized (object) {
                        block15: {
                            try {
                                if (this.runner == null) {
                                    this.monitor.wait(MessageServiceThreadPool.this.getIdleTimeout());
                                    if (MessageServiceThreadPool.this.notifyTimeout(this)) {
                                        continue block10;
                                    }
                                    break block15;
                                }
                            }
                            catch (Throwable e) {
                                this.interrupted = true;
                                this.runner = null;
                                MessageServiceThreadPool.this.removeWorker(this);
                                logger.debug((Object)e, e);
                            }
                            continue block10;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startWork(Runnable runner) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.interrupted) {
                    return;
                }
                this.runner = runner;
                this.monitor.notify();
            }
        }
    }
}

