/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.Destination;
import com.kingdee.bos.service.message.DestinationManager;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.agent.Agent;
import com.kingdee.bos.service.message.agent.BOSMessageService;
import com.kingdee.bos.service.message.agent.DirectReceiverAgent;
import com.kingdee.bos.service.message.agent.ListenerInfo;
import com.kingdee.bos.service.message.agent.ListenerManager;
import org.apache.log4j.Logger;

public class ReceiverAgent
implements Agent,
MessageListener {
    private int state = 0;
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.agent.ReceiverAgent");
    ListenerManager listeners;
    private Connection conn;
    Destination dest;
    private static ReceiverAgent receiverAgent;

    protected ReceiverAgent() {
    }

    private void dispatch(final Message message) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListenerInfo listenInfo = this.listeners.get(i);
            final MessageListener listener = listenInfo.listener;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    listener.onMessage(message);
                }
            }).start();
        }
    }

    @Override
    public int onMessage(Message message) {
        this.dispatch(message);
        return 1;
    }

    @Override
    public void start() {
        if (this.state == 1) {
            return;
        }
        try {
            this.conn = this.dest.getConnection(null);
            this.installListeners();
        }
        catch (MessageException ex) {
            log.error((Object)"cannot start receiver agent", (Throwable)((Object)ex));
        }
        this.state = 1;
    }

    @Override
    public void stop() {
        if (this.state != 1) {
            return;
        }
        try {
            this.unInstallListeners();
            this.conn.close();
        }
        catch (MessageException ex) {
            log.error((Object)"stop agnet error", (Throwable)((Object)ex));
        }
        this.state = 2;
    }

    @Override
    public int getState() {
        return this.state;
    }

    protected void init() {
        this.dest = DestinationManager.getDefaultDestination();
        this.listeners = new ListenerManager();
        this.listeners.loadListeners();
    }

    private void installListeners() throws MessageException {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListenerInfo listener = this.listeners.get(i);
            listener.open(this.conn);
        }
    }

    private void unInstallListeners() throws MessageException {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListenerInfo listener = this.listeners.get(i);
            listener.close();
        }
        this.listeners.clear();
    }

    public static ReceiverAgent getReceiverAgent() {
        if (receiverAgent == null) {
            receiverAgent = BOSMessageService.getServiceType().equals(BOSMessageService.SERVICE_TYPE_DIRECT) ? new DirectReceiverAgent() : new ReceiverAgent();
            receiverAgent.init();
            receiverAgent.start();
        }
        return receiverAgent;
    }
}

