/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.agent.BOSMessageService;
import com.kingdee.bos.service.message.agent.ListenerInfo;
import com.kingdee.bos.service.message.agent.ListenerManager;
import com.kingdee.bos.service.message.agent.MessageRedeliverHelper;
import com.kingdee.bos.service.message.jms.MessageConvert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

public class ReceiverAgentMDB
implements MessageDrivenBean,
javax.jms.MessageListener {
    private static final int processMessageTimeout = 3600000;
    private static final Logger logger = Logger.getLogger(ReceiverAgentMDB.class);
    private ListenerManager listeners = null;

    public void setMessageDrivenContext(MessageDrivenContext ctx) {
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public void ejbPassivate() {
    }

    public void ejbCreate() {
        this.init();
        logger.info((Object)"BOS Message ReceiverAgentMDB started.");
    }

    void init() {
        this.listeners = new ListenerManager();
        this.listeners.loadListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiMessageResult dispatch(boolean bRedelivered, Message bosMsg) {
        String listenerDomain = null;
        String senderDomain = bosMsg.getDomian();
        MultiMessageResult mrt = new MultiMessageResult();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListenerInfo listenInfo = this.listeners.get(i);
            listenerDomain = listenInfo.doamin;
            MessageListener listener = listenInfo.listener;
            boolean match = false;
            if (bRedelivered && !MessageRedeliverHelper.shouldReCallOnMessage(listenInfo, bosMsg)) continue;
            if (listenerDomain != null && senderDomain != null) {
                if (listenerDomain.length() == 0) {
                    match = true;
                } else if (senderDomain.equals(listenerDomain) || senderDomain.length() > listenerDomain.length() && senderDomain.charAt(listenerDomain.length()) == '.' && senderDomain.startsWith(listenerDomain)) {
                    match = true;
                }
            } else if (listenerDomain != null) {
                match = true;
            }
            if (!match) continue;
            MessageResult rt = new MessageResult(listenInfo);
            MultiMessageResult multiMessageResult = mrt;
            synchronized (multiMessageResult) {
                mrt.process(rt);
                MessageRedeliverHelper.notifyStartDeliver(listenInfo, bosMsg);
            }
            this.newMsgListenerThread(listener, bosMsg, rt, mrt);
        }
        return mrt;
    }

    private void newMsgListenerThread(final MessageListener listener, final Message bosMsg, final MessageResult ret, final MultiMessageResult mrt) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int i = listener.onMessage(bosMsg);
                MultiMessageResult multiMessageResult = mrt;
                synchronized (multiMessageResult) {
                    ret.ret = i;
                    mrt.notify();
                }
            }
        };
        if (BOSMessageService.getMessageTheadPool() != null) {
            BOSMessageService.getMessageTheadPool().startThread(r);
        } else {
            new Thread(r).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(javax.jms.Message jmsMsg) {
        block16: {
            try {
                MultiMessageResult mret;
                if (!(jmsMsg instanceof TextMessage)) break block16;
                Message bosMsg = MessageConvert.convertFromJMS(jmsMsg);
                boolean bRedelivered = false;
                boolean bRollbackTest = true;
                if (jmsMsg.getJMSRedelivered()) {
                    int times = MessageRedeliverHelper.messageRedelivered(bosMsg);
                    if ("give me a rollback".equals(bosMsg.getStringHeader("bodyl2")) && times > 3) {
                        bRollbackTest = false;
                    }
                    logger.info((Object)("bosMsg " + bosMsg.getMessageID() + " Redelivered " + times + " times"));
                    bRedelivered = true;
                    if (times >= BOSMessageService.getMessageRedeliverMaxTimes()) {
                        logger.warn((Object)("bosMsg " + bosMsg.getMessageID() + " RedeliveredMaxTimes, ignore it"));
                        return;
                    }
                }
                if (bRollbackTest && "give me a rollback".equals(bosMsg.getStringHeader("bodyl2"))) {
                    logger.error((Object)MessageConvert.dumpMessage((TextMessage)jmsMsg));
                    throw new RuntimeException("give me a rollback want to rollback");
                }
                MultiMessageResult multiMessageResult = mret = this.dispatch(bRedelivered, bosMsg);
                synchronized (multiMessageResult) {
                    long t0 = System.currentTimeMillis();
                    long t = 0L;
                    boolean timeOut = false;
                    while (!mret.ready()) {
                        t = System.currentTimeMillis() - t0;
                        if (t >= 3600000L) {
                            timeOut = true;
                            break;
                        }
                        try {
                            mret.wait(500L);
                        }
                        catch (InterruptedException e) {
                            logger.error((Object)"InterruptedException", (Throwable)e);
                        }
                    }
                    List<ListenerInfo> listeners = mret.getSuccessListeners();
                    Iterator<ListenerInfo> iter = listeners.iterator();
                    while (iter.hasNext()) {
                        MessageRedeliverHelper.notifySuccessDeliver(iter.next(), bosMsg);
                    }
                    if (timeOut) {
                        logger.error((Object)("MDB Process Message [" + bosMsg.getMessageID() + "] TimeOut!\n"));
                        this.logMessageTimeout(mret, bosMsg);
                        throw new RuntimeException("MDB Process Message [" + bosMsg.getMessageID() + "] TimeOut");
                    }
                    if (!mret.success()) {
                        logger.error((Object)("MDB Process Message [" + bosMsg.getMessageID() + "] error!\n"));
                        this.logMessageFailed(mret, bosMsg);
                        throw new RuntimeException("MDB process message [" + bosMsg.getMessageID() + "] error!");
                    }
                }
            }
            catch (JMSException me) {
                logger.error((Object)"MDB process message error", (Throwable)me);
            }
        }
    }

    private void logMessageTimeout(MultiMessageResult mret, Message bosMsg) {
        List<ListenerInfo> listeners = mret.getTimeoutListeners();
        for (ListenerInfo element : listeners) {
            StringBuffer sb = new StringBuffer();
            sb.append("message listener:[name='").append(element.name);
            sb.append("' class='").append(element.listener.getClass().getName());
            sb.append("' ] process Message[").append(bosMsg.getMessageID());
            sb.append("] time out!");
            logger.error((Object)sb.toString());
        }
    }

    private void logMessageFailed(MultiMessageResult mret, Message bosMsg) {
        List<ListenerInfo> listeners = mret.getFailedListeners();
        for (ListenerInfo element : listeners) {
            StringBuffer sb = new StringBuffer();
            sb.append("message listener:[name='").append(element.name);
            sb.append("' class='").append(element.listener.getClass().getName());
            sb.append("' ] process Message[").append(bosMsg.getMessageID());
            sb.append("] failed!");
            logger.error((Object)sb.toString());
        }
    }

    private static class MultiMessageResult {
        private final List<MessageResult> rtList = new ArrayList<MessageResult>(4);

        private MultiMessageResult() {
        }

        public boolean ready() {
            for (MessageResult element : this.rtList) {
                if (element.ret != -1) continue;
                return false;
            }
            return true;
        }

        public void process(MessageResult other) {
            this.rtList.add(other);
        }

        public boolean success() {
            for (MessageResult element : this.rtList) {
                if (element.ret == 1) continue;
                return false;
            }
            return true;
        }

        public List<ListenerInfo> getSuccessListeners() {
            ArrayList<ListenerInfo> successListeners = new ArrayList<ListenerInfo>(4);
            for (MessageResult element : this.rtList) {
                if (element.ret != 1) continue;
                successListeners.add(element.listenerInfo);
            }
            return successListeners;
        }

        public List<ListenerInfo> getFailedListeners() {
            ArrayList<ListenerInfo> failedListeners = new ArrayList<ListenerInfo>();
            for (MessageResult element : this.rtList) {
                if (element.ret != 0) continue;
                failedListeners.add(element.listenerInfo);
            }
            return failedListeners;
        }

        public List<ListenerInfo> getTimeoutListeners() {
            ArrayList<ListenerInfo> timeoutListeners = new ArrayList<ListenerInfo>();
            for (MessageResult element : this.rtList) {
                if (element.ret != -1) continue;
                timeoutListeners.add(element.listenerInfo);
            }
            return timeoutListeners;
        }
    }

    private static class MessageResult {
        private int ret = -1;
        private final ListenerInfo listenerInfo;

        MessageResult(ListenerInfo listenerInfo) {
            this.listenerInfo = listenerInfo;
        }
    }
}

