/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.jms.MessageConvert;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

public class JMSMessageListenerImpl
implements javax.jms.MessageListener {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.jms.JMSMessageListenerImpl");
    private MessageListener listener;

    public JMSMessageListenerImpl(MessageListener listener) {
        this.listener = listener;
    }

    public void onMessage(javax.jms.Message message) {
        Message m = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("receive Message successfully! \n{" + MessageConvert.dumpMessage((TextMessage)message) + "}"));
            }
            m = MessageConvert.convertFromJMS(message);
        }
        catch (JMSException ex) {
            log.error((Object)"convert message from JMS error", (Throwable)ex);
        }
        if (m == null) {
            log.warn((Object)"reveive a junk message,ingnore it!");
            return;
        }
        this.newMsgListenerThread(this.listener, m);
    }

    private void newMsgListenerThread(final MessageListener listener, final Message bosMsg) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                listener.onMessage(bosMsg);
            }
        }).start();
    }
}

