/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.grouptopic;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.jms.MessageConvert;
import com.kingdee.bos.service.message.jms.grouptopic.TopicGroup;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

public class GroupTopicMessageProducer
implements MessageProducer {
    private TopicGroup topics;
    private TopicSession session;

    public GroupTopicMessageProducer(TopicConnection topicConnection, Properties props) throws MessageException {
        this.topics = new TopicGroup(topicConnection, props);
        this.topics.openTopicsForPublish();
        this.session = this.topics.getSession();
    }

    @Override
    public void send(Message message) throws MessageException {
        try {
            TopicPublisher sender = this.topics.getJMSTopicProducerByDomain(message.getDomian());
            sender.publish(MessageConvert.convertToJMS((Session)this.session, message));
        }
        catch (JMSException me) {
            throw new MessageException("JMS Exception", me);
        }
    }

    @Override
    public void close() throws MessageException {
        if (this.topics != null) {
            this.topics.close();
        }
    }
}

