/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.grouptopic;

import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.jms.grouptopic.TopicInfo;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.log4j.Logger;

public class TopicGroup {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.jms.grouptopic.TopicGroup");
    private TopicConnection topicConnection;
    private boolean transactionSupport;
    private int acknowledgeMode;
    private TopicSession topicSession;
    private TopicInfo theDefaultTopic;

    public TopicGroup(TopicConnection conn, Properties props) throws MessageException {
        this.topicConnection = conn;
        if (props != null) {
            Object amObj;
            block12: {
                Object tsObj = props.get("transactionSupport");
                if (tsObj != null) {
                    try {
                        if (tsObj instanceof Boolean) {
                            this.transactionSupport = (Boolean)tsObj;
                            break block12;
                        }
                        this.transactionSupport = Boolean.valueOf(tsObj.toString());
                    }
                    catch (Exception exception) {}
                } else {
                    this.transactionSupport = false;
                }
            }
            if ((amObj = props.get("acknowledgeMode")) != null) {
                try {
                    this.acknowledgeMode = amObj instanceof Integer ? (Integer)amObj : Integer.parseInt(amObj.toString());
                    if (this.acknowledgeMode != 1 && this.acknowledgeMode != 2 && this.acknowledgeMode != 3) {
                        throw new MessageException("invalid acknowledge mode setting");
                    }
                }
                catch (Exception exception) {}
            } else {
                this.acknowledgeMode = 1;
            }
            String topics = props.getProperty("topics");
            this.theDefaultTopic = new TopicInfo(topics);
        } else {
            this.transactionSupport = false;
            this.acknowledgeMode = 1;
        }
    }

    public void openTopicsForPublish() throws MessageException {
        try {
            this.topicSession = this.topicConnection.createTopicSession(this.transactionSupport, this.acknowledgeMode);
            this.theDefaultTopic.openPublisher(this.topicSession);
        }
        catch (JMSException ex) {
            throw new MessageException("open topics for publish error!", ex);
        }
    }

    public void openTopicsForConsume() throws MessageException {
        try {
            this.topicSession = this.topicConnection.createTopicSession(this.transactionSupport, this.acknowledgeMode);
            this.theDefaultTopic.openSubscriber(this.topicSession);
        }
        catch (JMSException ex) {
            throw new MessageException("open topics for publish error!", ex);
        }
    }

    public TopicPublisher getJMSTopicProducerByDomain(String domain) {
        return this.theDefaultTopic.getProducer();
    }

    public TopicSubscriber getJMSTopicConsumer() {
        return this.theDefaultTopic.getConsumer();
    }

    public TopicSession getSession() {
        return this.topicSession;
    }

    public void close() throws MessageException {
        try {
            if (this.theDefaultTopic != null) {
                this.theDefaultTopic.close();
            }
            if (this.topicSession != null) {
                this.topicSession.close();
            }
        }
        catch (JMSException ex) {
            log.error((Object)"close topic group error!", (Throwable)ex);
            throw new MessageException("close topic group error", ex);
        }
    }
}

