/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.queue;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.MessageConsumer;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.jms.queue.QueueMessageConsumer;
import com.kingdee.bos.service.message.jms.queue.QueueMessageProducer;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class QueueConnection
implements Connection {
    public static final String TRANSACTION_SUPPORT = "transactionSupport";
    public static final String ACKNOWLEDGE_MODE = "acknowledgeMode";
    public static final boolean DEFAULT_TRANSACTION_SUPPORT = false;
    public static final int DEFAULT_ACKNOWLEDGE_MODE = 1;
    Context ctx = null;
    javax.jms.QueueConnection queueConnection = null;
    Queue queue = null;

    protected QueueConnection(String url, Properties info) throws MessageException {
        try {
            String[] protocol = StringUtils.split((String)url, (int)58);
            info.setProperty("queueJNDIName", protocol[3]);
            String contextFactory = info.getProperty("contextFactory");
            String jndiUrl = info.getProperty("jndiURL");
            String securityCredential = info.getProperty("securityCredential");
            String securityPrincipal = info.getProperty("securityPrincipal");
            Hashtable<String, String> env = new Hashtable<String, String>();
            if (jndiUrl != null) {
                env.put("java.naming.provider.url", jndiUrl);
            }
            if (contextFactory != null) {
                env.put("java.naming.factory.initial", contextFactory);
            }
            if (securityCredential != null) {
                env.put("java.naming.security.credentials", securityCredential);
            }
            if (securityPrincipal != null) {
                env.put("java.naming.security.principal", securityPrincipal);
            }
            this.ctx = new InitialContext(env);
            String connectionFactoryJNDIName = info.getProperty("connectionFactoryJNDIName");
            if (connectionFactoryJNDIName == null) {
                throw new MessageException("connectionFactoryJNDIName is null");
            }
            String queueJNDIName = info.getProperty("queueJNDIName");
            if (queueJNDIName == null) {
                throw new MessageException("queueJNDIName is null");
            }
            QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)this.ctx.lookup(connectionFactoryJNDIName);
            this.queueConnection = queueConnectionFactory.createQueueConnection();
            this.queue = (Queue)this.ctx.lookup(queueJNDIName);
            this.queueConnection.start();
            this.ctx.close();
        }
        catch (NamingException ex) {
            throw new MessageException("error when using InitialContext", ex);
        }
        catch (JMSException me) {
            throw new MessageException("error when create queueConnection", me);
        }
    }

    @Override
    public MessageProducer createSender(Properties props) throws MessageException {
        return new QueueMessageProducer(this.queueConnection, this.queue, props);
    }

    @Override
    public MessageConsumer createRecevier(Properties props) throws MessageException {
        return new QueueMessageConsumer(this.queueConnection, this.queue, props);
    }

    @Override
    public void close() throws MessageException {
        try {
            if (this.queueConnection != null) {
                this.queueConnection.close();
            }
        }
        catch (JMSException ex) {
            throw new MessageException("", ex);
        }
    }
}

