/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.queue;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageConsumer;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.jms.JMSMessageListenerImpl;
import com.kingdee.bos.service.message.jms.MessageConvert;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

public class QueueMessageConsumer
implements MessageConsumer {
    QueueConnection queueConnection;
    Queue queue;
    QueueSession session;
    QueueReceiver receiver;
    JMSMessageListenerImpl listener;
    boolean transactionSupport;
    int acknowledgeMode;
    String selector;

    public QueueMessageConsumer(QueueConnection queueConnection, Queue queue, Properties props) throws MessageException {
        try {
            this.queueConnection = queueConnection;
            this.queue = queue;
            if (props != null) {
                String domain;
                Object amObj;
                block15: {
                    Object tsObj = props.get("transactionSupport");
                    if (tsObj != null) {
                        try {
                            if (tsObj instanceof Boolean) {
                                this.transactionSupport = (Boolean)tsObj;
                                break block15;
                            }
                            this.transactionSupport = Boolean.valueOf(tsObj.toString());
                        }
                        catch (Exception exception) {}
                    } else {
                        this.transactionSupport = false;
                    }
                }
                if ((amObj = props.get("acknowledgeMode")) != null) {
                    try {
                        this.acknowledgeMode = amObj instanceof Integer ? (Integer)amObj : Integer.parseInt(amObj.toString());
                        if (this.acknowledgeMode != 1 && this.acknowledgeMode != 2 && this.acknowledgeMode != 3) {
                            throw new MessageException("invalid acknowledge mode setting");
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    this.acknowledgeMode = 1;
                }
                if ((domain = (String)props.get("messageDomianPrefix")) != null) {
                    this.selector = "BosMessageDomain LIKE '" + domain + "%'";
                }
            } else {
                this.transactionSupport = false;
                this.acknowledgeMode = 1;
            }
            this.session = queueConnection.createQueueSession(this.transactionSupport, this.acknowledgeMode);
            this.receiver = this.session.createReceiver(queue, this.selector);
        }
        catch (JMSException me) {
            throw new MessageException("is ...", me);
        }
    }

    @Override
    public Message receive() throws MessageException {
        try {
            javax.jms.Message jmsMessage = this.receiver.receive();
            if (jmsMessage instanceof TextMessage) {
                return MessageConvert.convertFromJMS(jmsMessage);
            }
            return null;
        }
        catch (JMSException me) {
            throw new MessageException("", me);
        }
    }

    @Override
    public Message receive(long timeout) throws MessageException {
        try {
            javax.jms.Message jmsMessage = this.receiver.receive(timeout);
            if (jmsMessage instanceof TextMessage) {
                return MessageConvert.convertFromJMS(jmsMessage);
            }
            return null;
        }
        catch (JMSException me) {
            throw new MessageException("", me);
        }
    }

    @Override
    public Message receiveNoWait() throws MessageException {
        try {
            javax.jms.Message jmsMessage = this.receiver.receiveNoWait();
            if (jmsMessage instanceof TextMessage) {
                return MessageConvert.convertFromJMS(jmsMessage);
            }
            return null;
        }
        catch (JMSException me) {
            throw new MessageException("", me);
        }
    }

    @Override
    public void setMessageListener(MessageListener listener) throws MessageException {
        if (this.listener == null) {
            this.listener = new JMSMessageListenerImpl(listener);
            try {
                this.receiver.setMessageListener((javax.jms.MessageListener)this.listener);
            }
            catch (JMSException ex) {
                throw new MessageException("JMS Exception", ex);
            }
        }
    }

    @Override
    public void close() throws MessageException {
        if (this.receiver != null) {
            try {
                this.receiver.close();
            }
            catch (JMSException me) {
                throw new MessageException("", me);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException me) {
                throw new MessageException("", me);
            }
        }
    }
}

