/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.topic;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.MessageConsumer;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.jms.JMSCache;
import com.kingdee.bos.service.message.jms.topic.TopicMessageConsumer;
import com.kingdee.bos.service.message.jms.topic.TopicMessageProducer;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class TopicConnection
implements Connection {
    public static final String TRANSACTION_SUPPORT = "transactionSupport";
    public static final String ACKNOWLEDGE_MODE = "acknowledgeMode";
    public static final boolean DEFAULT_TRANSACTION_SUPPORT = false;
    public static final String BE_DURABLE_PROPERTY_NAME = "durable";
    public static final String SUBSCRIBE_ID_PROPERTY_NAME = "subscribeId";
    public static final String CLIENT_ID_PROPERTY_NAME = "clientId";
    public static final int DEFAULT_ACKNOWLEDGE_MODE = 1;
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.jms.topic.TopicConnection");
    javax.jms.TopicConnection topicConnection = null;
    Topic topic = null;

    protected TopicConnection(String url, Properties info) throws MessageException {
        try {
            String connectionFactoryJNDIName;
            String[] protocol = StringUtils.split((String)url, (int)58);
            info.setProperty("topicJNDIName", protocol[3]);
            String contextFactory = info.getProperty("contextFactory");
            String jndiUrl = info.getProperty("jndiURL");
            String securityCredential = info.getProperty("securityCredential");
            String securityPrincipal = info.getProperty("securityPrincipal");
            Hashtable<String, String> env = null;
            String sIsDefaultLocal = info.getProperty("isLocal");
            if (!"true".equalsIgnoreCase(sIsDefaultLocal)) {
                env = new Hashtable<String, String>();
                if (jndiUrl != null) {
                    env.put("java.naming.provider.url", jndiUrl);
                }
                if (contextFactory != null) {
                    env.put("java.naming.factory.initial", contextFactory);
                }
                if (securityCredential != null) {
                    env.put("java.naming.security.credentials", securityCredential);
                }
                if (securityPrincipal != null) {
                    env.put("java.naming.security.principal", securityPrincipal);
                }
            }
            if ((connectionFactoryJNDIName = info.getProperty("connectionFactoryJNDIName")) == null) {
                throw new MessageException("connectionFactoryJNDIName is null");
            }
            String topicJNDIName = info.getProperty("topicJNDIName");
            if (topicJNDIName == null) {
                throw new MessageException("topicJNDIName is null");
            }
            TopicConnectionFactory topicConnectionFactory = JMSCache.getJMSCache(env).getTopicConnectionFactory(connectionFactoryJNDIName);
            long t = System.currentTimeMillis();
            this.topicConnection = topicConnectionFactory.createTopicConnection();
            String clientId = info.getProperty(CLIENT_ID_PROPERTY_NAME);
            if (clientId != null) {
                this.topicConnection.setClientID(clientId);
            }
            this.topic = JMSCache.getJMSCache(env).getTopic(topicJNDIName);
            this.topicConnection.start();
            log.debug((Object)("get JMS Connect internl " + (System.currentTimeMillis() - t) + "ms"));
        }
        catch (NamingException ex) {
            throw new MessageException("error when using InitialContext", ex);
        }
        catch (JMSException me) {
            throw new MessageException("error when create topicConnection", me);
        }
    }

    @Override
    public MessageProducer createSender(Properties props) throws MessageException {
        return new TopicMessageProducer(this.topicConnection, this.topic, props);
    }

    @Override
    public MessageConsumer createRecevier(Properties props) throws MessageException {
        return new TopicMessageConsumer(this.topicConnection, this.topic, props);
    }

    public void subscribeDurable(String subscribeId, String domain, Map selector, MessageListener listen) throws MessageException {
        if (subscribeId == null) {
            throw new MessageException("subscribeId cannot be Null");
        }
        Properties prop = new Properties();
        prop.put("messageDomianPrefix", domain);
        prop.put(BE_DURABLE_PROPERTY_NAME, "true");
        prop.put("selector", selector);
        prop.put(SUBSCRIBE_ID_PROPERTY_NAME, subscribeId);
        MessageConsumer consumer = this.createRecevier(prop);
        consumer.setMessageListener(listen);
    }

    public void unSubscribeDurable(String subscribeId) throws MessageException {
        try {
            TopicSession session = this.topicConnection.createTopicSession(false, 1);
            session.unsubscribe(subscribeId);
        }
        catch (JMSException ex) {
            throw new MessageException("JMS Exception", ex);
        }
    }

    @Override
    public void close() throws MessageException {
        try {
            if (this.topicConnection != null) {
                this.topicConnection.close();
            }
        }
        catch (JMSException ex) {
            throw new MessageException("", ex);
        }
    }
}

