/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.topic;

import com.kingdee.bos.service.message.JMSLocalTransactionException;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.TransactionSupport;
import com.kingdee.bos.service.message.jms.MessageConvert;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.log4j.Logger;

public class TopicMessageProducer
implements MessageProducer,
TransactionSupport {
    TopicConnection topicConnection;
    Topic topic;
    TopicSession session;
    TopicPublisher sender;
    boolean transactionSupport;
    int acknowledgeMode;
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.jms.topic.TopicMessageProducer");

    public TopicMessageProducer(TopicConnection topicConnection, Topic topic, Properties props) throws MessageException {
        try {
            this.topicConnection = topicConnection;
            this.topic = topic;
            if (props != null) {
                Object amObj;
                block14: {
                    Object tsObj = props.get("transactionSupport");
                    if (tsObj != null) {
                        try {
                            if (tsObj instanceof Boolean) {
                                this.transactionSupport = (Boolean)tsObj;
                                break block14;
                            }
                            this.transactionSupport = Boolean.valueOf(tsObj.toString());
                        }
                        catch (Exception exception) {}
                    } else {
                        this.transactionSupport = false;
                    }
                }
                if ((amObj = props.get("acknowledgeMode")) != null) {
                    try {
                        this.acknowledgeMode = amObj instanceof Integer ? (Integer)amObj : Integer.parseInt(amObj.toString());
                        if (this.acknowledgeMode != 1 && this.acknowledgeMode != 2 && this.acknowledgeMode != 3) {
                            throw new MessageException("invalid acknowledge mode setting");
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    this.acknowledgeMode = 1;
                }
            } else {
                this.transactionSupport = false;
                this.acknowledgeMode = 1;
            }
            this.session = topicConnection.createTopicSession(this.transactionSupport, this.acknowledgeMode);
            this.sender = this.session.createPublisher(topic);
        }
        catch (JMSException me) {
            throw new MessageException("JMS Exception", me);
        }
    }

    @Override
    public void send(Message message) throws MessageException {
        try {
            TextMessage msg = (TextMessage)MessageConvert.convertToJMS((Session)this.session, message);
            this.sender.publish((javax.jms.Message)msg);
            if (log.isDebugEnabled()) {
                log.debug((Object)("send Message successfully! \n{" + MessageConvert.dumpMessage(msg) + "}"));
            }
        }
        catch (JMSException me) {
            throw new MessageException("JMS Exception", me);
        }
    }

    @Override
    public void close() throws MessageException {
        if (this.sender != null) {
            try {
                this.sender.close();
            }
            catch (JMSException me) {
                throw new MessageException("JMS Exception", me);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException me) {
                throw new MessageException("JMS Exception", me);
            }
        }
    }

    @Override
    public void begainTransaction() throws JMSLocalTransactionException {
        if (!this.transactionSupport) {
            throw new JMSLocalTransactionException("Transaction Not Support!");
        }
        this.commit();
    }

    @Override
    public void commit() throws JMSLocalTransactionException {
        try {
            if (this.session.getTransacted()) {
                this.session.commit();
            }
        }
        catch (JMSException e) {
            throw new JMSLocalTransactionException("commit error", e);
        }
    }

    @Override
    public void rollback() throws JMSLocalTransactionException {
        try {
            if (this.session.getTransacted()) {
                this.session.rollback();
            }
        }
        catch (JMSException e) {
            throw new JMSLocalTransactionException("commit error", e);
        }
    }
}

