/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.mail;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.MessageDriver;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.mail.MailConnection;
import java.util.Properties;
import java.util.Vector;

public class MailDriver
implements MessageDriver {
    public static final String SMTP_SERVER = "smtpServer";
    public static final String POP3_SERVER = "pop3Server";
    public static final String NEED_AUTH = "needAuth";
    public static final String AUTH_USER = "authUser";
    public static final String AUTH_P = "authPassword";
    public static final String USER = "user";
    public static final String MAIL_P = "password";

    @Override
    public Connection connect(String url, Properties info) throws MessageException {
        if (!this.acceptsURL(url)) {
            throw new MessageException("url not suitable for this driver");
        }
        return new MailConnection(info);
    }

    @Override
    public boolean acceptsURL(String url) throws MessageException {
        String[] protocol = MailDriver.split(url, ":");
        if (protocol.length < 3) {
            return false;
        }
        if (!protocol[0].equalsIgnoreCase("bosmessage")) {
            return false;
        }
        if (!protocol[1].equalsIgnoreCase("mail")) {
            return false;
        }
        return protocol[2].equalsIgnoreCase("smtp;pop3");
    }

    private static String[] split(String line, String seperator) {
        int j;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while ((j = line.indexOf(seperator, i)) >= 0) {
            v.addElement(line.substring(i, j).trim());
            i = j + seperator.length();
        }
        v.addElement(line.substring(i).trim());
        int size = v.size();
        Object[] ps = new String[size];
        if (size > 0) {
            v.copyInto(ps);
        }
        return ps;
    }
}

