/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.swtimpl.WebBrowserObject;
import chrriis.dj.nativeswing.swtimpl.components.JVLCPlayer;

public class VLCVideo {
    private WebBrowserObject webBrowserObject;

    VLCVideo(JVLCPlayer vlcPlayer) {
        this.webBrowserObject = vlcPlayer.getWebBrowserObject();
    }

    public int getWidth() {
        Object value = this.webBrowserObject.getObjectProperty("video.width");
        return value == null ? -1 : ((Number)value).intValue();
    }

    public int getHeight() {
        Object value = this.webBrowserObject.getObjectProperty("video.height");
        return value == null ? -1 : ((Number)value).intValue();
    }

    public void setFullScreen(boolean isFullScreen) {
        this.webBrowserObject.setObjectProperty("video.fullscreen", isFullScreen);
    }

    public boolean isFullScreen() {
        return Boolean.TRUE.equals(this.webBrowserObject.getObjectProperty("video.fullscreen"));
    }

    public void setAspectRatio(VLCAspectRatio aspectRatio) {
        String value;
        switch (aspectRatio) {
            case _1x1: {
                value = "1:1";
                break;
            }
            case _4x3: {
                value = "4:3";
                break;
            }
            case _16x9: {
                value = "16:9";
                break;
            }
            case _16x10: {
                value = "16:10";
                break;
            }
            case _221x100: {
                value = "221:100";
                break;
            }
            case _5x4: {
                value = "5:4";
                break;
            }
            default: {
                throw new IllegalArgumentException("The aspect ratio value is invalid!");
            }
        }
        this.webBrowserObject.setObjectProperty("video.aspectRatio", value);
    }

    public VLCAspectRatio getAspectRatio() {
        String value = (String)this.webBrowserObject.getObjectProperty("video.aspectRatio");
        if ("1:1".equals(value)) {
            return VLCAspectRatio._1x1;
        }
        if ("4:3".equals(value)) {
            return VLCAspectRatio._4x3;
        }
        if ("16:9".equals(value)) {
            return VLCAspectRatio._16x9;
        }
        if ("16:10".equals(value)) {
            return VLCAspectRatio._16x10;
        }
        if ("221:100".equals(value)) {
            return VLCAspectRatio._221x100;
        }
        if ("5:4".equals(value)) {
            return VLCAspectRatio._5x4;
        }
        return null;
    }

    public void setSubtitleTrack(int subtitleTrack) {
        this.webBrowserObject.setObjectProperty("video.subtitle", subtitleTrack);
    }

    public int getSubtitleTrack() {
        Object value = this.webBrowserObject.getObjectProperty("video.subtitle");
        return value == null ? -1 : ((Number)value).intValue();
    }

    public void toggleFullScreen() {
        this.webBrowserObject.invokeObjectFunction("video.toggleFullscreen", new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VLCAspectRatio {
        _1x1,
        _4x3,
        _16x9,
        _16x10,
        _221x100,
        _5x4;

    }
}

