/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class DmdbOutputStream
extends OutputStream {
    public static final int BINARY = 1;
    public static final int ASCII = 2;
    private int type = 1;
    public static final int IS_BLOB = 1;
    public static final int IS_CLOB = 2;
    private int typeFlag;
    private Object obj;
    private long objPos;
    private byte[] buf;
    private int bufPos;

    public DmdbOutputStream(Object o2, long pos) throws SQLException {
        this.obj = o2;
        this.objPos = pos;
        this.buf = new byte[32640];
        this.bufPos = 0;
        if (o2 instanceof DmdbBlob) {
            this.typeFlag = 1;
        } else if (o2 instanceof DmdbClob) {
            this.typeFlag = 2;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    public DmdbOutputStream(Object o2, long pos, int type) throws SQLException {
        this(o2, pos);
        this.type = type;
    }

    @Override
    public void write(int a2) throws IOException {
        byte[] tempByte = new byte[]{(byte)a2};
        this.write(tempByte, 0, 1);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (off < 0) {
            DBError.throwIOException("off IndexOutOfBounds :" + off);
        }
        if (len < 0) {
            DBError.throwIOException("len IndexOutOfBounds :" + len);
        }
        if (off + len > b2.length) {
            DBError.throwIOException("off + len IndexOutOfBounds :" + off + len);
        }
        int writeLen = 0;
        while (writeLen < len) {
            int bufLeaveLen = this.bufLeaveLen();
            if (bufLeaveLen == 0) {
                this.flush();
                bufLeaveLen = this.bufLeaveLen();
            }
            int iLen = Math.min(bufLeaveLen, len - writeLen);
            System.arraycopy(b2, off, this.buf, this.bufPos, iLen);
            writeLen += iLen;
            this.bufPos += iLen;
            off += iLen;
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        super.write(b2);
    }

    @Override
    public void flush() throws IOException {
        if (this.bufPos <= 0) {
            return;
        }
        try {
            switch (this.typeFlag) {
                case 1: {
                    this.writeToBlob();
                    break;
                }
                case 2: {
                    this.writeToClob();
                    break;
                }
                default: {
                    DBError.throwIOException("Fatal error occured in DmdbOutputStream ");
                    break;
                }
            }
        }
        catch (SQLException e2) {
            DBError.throwIOException(e2.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    private int bufLeaveLen() {
        return this.buf == null ? 0 : this.buf.length - this.bufPos;
    }

    private void writeToBlob() throws SQLException {
        if (this.bufPos <= 0) {
            return;
        }
        DmdbBlob blob = (DmdbBlob)this.obj;
        int writeLen = blob.do_setBytes(this.objPos, this.buf, 0, this.bufPos);
        this.objPos += (long)writeLen;
        this.bufPos = 0;
    }

    private void writeToClob() throws SQLException {
        if (this.bufPos <= 0) {
            return;
        }
        DmdbClob clob = (DmdbClob)this.obj;
        String str = "";
        str = this.type == 2 ? String.valueOf(ConvertUtil.ASCIIBytesToJavaChars(this.buf, 0, this.bufPos)) : ByteUtil.getString(this.buf, 0, this.bufPos, clob.serverEncoding);
        int writeLen = clob.do_setString(this.objPos, str);
        this.objPos += (long)writeLen;
        this.bufPos = 0;
    }
}

